/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.enum.PublicPrivateEnum;
import com.sap.ide.metamodel.webdynpro.implementation.ViewsetHierarchyNodeState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class WindowState
extends CommonDevelopmentObjectState
implements MainDevelopmentObjectState {
    private String mMetamodelRelease = null;
    private String mMetamodelVersion = null;
    private String mMetamodelTimestamp = null;
    protected String mPackage = null;
    private String mMasterLanguage = null;
    private Reference mParent;
    private String mVisibility = "public";
    private boolean mHasVisibility = false;
    private Reference mNavigationLinksRef = null;
    private HashMap mViewsetHierarchyRootNodes = new HashMap();
    private Reference mInterfaceViewRef = null;
    private Reference mDefaultViewsetHierarchyRootNodeRef = null;

    WindowState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        WindowState lState = (WindowState)object;
        if (!isRootObject && !this.mPackage.equals(lState.mPackage)) {
            return false;
        }
        return String.valueOf(this.mVisibility).equals(String.valueOf(lState.mVisibility));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        WindowState lState = (WindowState)object;
        if (!isRootObject && !this.mPackage.equals(lState.mPackage)) {
            compareContext.addPropertyDelta(sourceObject, "package", (Object)lState.mPackage);
        }
        if (!String.valueOf(this.mVisibility).equals(String.valueOf(lState.mVisibility))) {
            compareContext.addPropertyDelta(sourceObject, "visibility", (Object)PublicPrivateEnum.valueOf(lState.mVisibility));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        WindowState lState = (WindowState)((Object)super.clone());
        lState.mViewsetHierarchyRootNodes = new HashMap();
        Iterator it = this.mViewsetHierarchyRootNodes.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mViewsetHierarchyRootNodes.put(lKey, ((ViewsetHierarchyNodeState)((Object)this.mViewsetHierarchyRootNodes.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mInterfaceViewRef != null && !innerObjectKeys.contains(this.mInterfaceViewRef.toString())) {
            this.mInterfaceViewRef = null;
        }
        if (this.mDefaultViewsetHierarchyRootNodeRef != null && !innerObjectKeys.contains(this.mDefaultViewsetHierarchyRootNodeRef.toString())) {
            this.mDefaultViewsetHierarchyRootNodeRef = null;
        }
        Iterator it = this.mViewsetHierarchyRootNodes.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            this.setPackage(clipboardService.getNewPackage(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        if (this.mNavigationLinksRef != null && clipboardService.isExcluded(this.mNavigationLinksRef)) {
            this.mNavigationLinksRef = null;
        }
        Iterator it = this.mViewsetHierarchyRootNodes.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mNavigationLinksRef != null) {
            this.mNavigationLinksRef = clipboardService.refactor(this.mNavigationLinksRef);
        }
        Iterator it = this.mViewsetHierarchyRootNodes.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mParent != null) {
            this.mParent = clipboardService.refactor(this.mParent);
        }
        if (this.mInterfaceViewRef != null) {
            if (clipboardService.isExcluded(this.mInterfaceViewRef)) {
                this.mInterfaceViewRef = null;
            } else if (innerObjectKeys.contains(this.mInterfaceViewRef.toReferenceString())) {
                this.mInterfaceViewRef = clipboardService.refactor(this.mInterfaceViewRef);
            }
        }
        if (this.mDefaultViewsetHierarchyRootNodeRef != null) {
            if (clipboardService.isExcluded(this.mDefaultViewsetHierarchyRootNodeRef)) {
                this.mDefaultViewsetHierarchyRootNodeRef = null;
            } else if (innerObjectKeys.contains(this.mDefaultViewsetHierarchyRootNodeRef.toReferenceString())) {
                this.mDefaultViewsetHierarchyRootNodeRef = clipboardService.refactor(this.mDefaultViewsetHierarchyRootNodeRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        if (this.mNavigationLinksRef != null && this.mNavigationLinksRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        if (this.mInterfaceViewRef != null && this.mInterfaceViewRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        return this.mDefaultViewsetHierarchyRootNodeRef != null && this.mDefaultViewsetHierarchyRootNodeRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mParent != null) {
            this.mParent = refactoringService.refactor(this.mParent);
        }
        if (this.mInterfaceViewRef != null) {
            this.mInterfaceViewRef = refactoringService.refactor(this.mInterfaceViewRef);
        }
        if (this.mDefaultViewsetHierarchyRootNodeRef != null) {
            this.mDefaultViewsetHierarchyRootNodeRef = refactoringService.refactor(this.mDefaultViewsetHierarchyRootNodeRef);
        }
    }

    public String getPackage() {
        return this.mPackage;
    }

    public void setPackage(String newPackage) {
        this.mPackage = newPackage;
    }

    public String getMasterLanguage() {
        return this.mMasterLanguage;
    }

    public void setMasterLanguage(String language) {
        this.mMasterLanguage = language;
    }

    public String _getMetamodelRelease() {
        return this.mMetamodelRelease;
    }

    public String _getMetamodelVersion() {
        return this.mMetamodelVersion;
    }

    public String _getMetamodelTimestamp() {
        return this.mMetamodelTimestamp;
    }

    void setVisibility(String value) {
        this.mVisibility = value;
        this.mHasVisibility = true;
    }

    String getVisibility() {
        return this.mVisibility;
    }

    boolean hasVisibility() {
        return this.mHasVisibility;
    }

    public Reference getParent() {
        return this.mParent;
    }

    public void setParent(Reference parentReference) {
        this.mParent = parentReference;
    }

    void setNavigationLinks(Reference reference) {
        this.mNavigationLinksRef = reference;
    }

    Reference getNavigationLinks() {
        return this.mNavigationLinksRef;
    }

    void addViewsetHierarchyRootNode(ViewsetHierarchyNodeState state) {
        this.mViewsetHierarchyRootNodes.put(state.getName().toLowerCase(), state);
    }

    int getViewsetHierarchyRootNodeCount() {
        return this.mViewsetHierarchyRootNodes.size();
    }

    ViewsetHierarchyNodeState getViewsetHierarchyRootNode(String name) {
        return (ViewsetHierarchyNodeState)((Object)this.mViewsetHierarchyRootNodes.get(name.toLowerCase()));
    }

    Vector getViewsetHierarchyRootNodes() {
        return new Vector(this.mViewsetHierarchyRootNodes.values());
    }

    void removeViewsetHierarchyRootNode(String aggregationKey) {
        this.mViewsetHierarchyRootNodes.remove(aggregationKey.toLowerCase());
    }

    void removeViewsetHierarchyRootNode(ViewsetHierarchyNodeState state) {
        this.mViewsetHierarchyRootNodes.remove(state.getName().toLowerCase());
    }

    void removeAllViewsetHierarchyRootNodes() {
        this.mViewsetHierarchyRootNodes.clear();
    }

    Reference getInterfaceView() {
        return this.mInterfaceViewRef;
    }

    void setInterfaceView(Reference reference) {
        this.mInterfaceViewRef = reference;
    }

    Reference getDefaultViewsetHierarchyRootNode() {
        return this.mDefaultViewsetHierarchyRootNodeRef;
    }

    void setDefaultViewsetHierarchyRootNode(Reference reference) {
        this.mDefaultViewsetHierarchyRootNodeRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("mmRelease")) {
            this.mMetamodelRelease = (String)value;
        } else if (propertyName.equals("mmVersion")) {
            this.mMetamodelVersion = (String)value;
        } else if (propertyName.equals("mmTimestamp")) {
            this.mMetamodelTimestamp = (String)value;
        } else if (propertyName.equals("name")) {
            this.setName((String)value);
        } else if (propertyName.equals("visibility")) {
            if (PublicPrivateEnum.valueOf((String)value) != null) {
                this.setVisibility((String)value);
            }
        } else if (propertyName.equals("package")) {
            this.setPackage((String)value);
        } else if (propertyName.equals("masterLanguage")) {
            this.setMasterLanguage((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Parent")) {
            this.setParent((Reference)data);
        } else if (roleName.equals("NavigationLinks")) {
            this.setNavigationLinks((Reference)data);
        } else if (roleName.equals("ViewsetHierarchyRootNodes")) {
            this.addViewsetHierarchyRootNode((ViewsetHierarchyNodeState)((Object)data));
        } else if (roleName.equals("InterfaceView")) {
            this.setInterfaceView((Reference)data);
        } else if (roleName.equals("DefaultViewsetHierarchyRootNode")) {
            this.setDefaultViewsetHierarchyRootNode((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

