/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.PlaceholderState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

abstract class ViewsetHierarchyNodeState
extends CommonDevelopmentObjectState {
    private HashMap mViewAreas = new HashMap();
    private Reference mViewRef = null;

    ViewsetHierarchyNodeState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ViewsetHierarchyNodeState lState = (ViewsetHierarchyNodeState)object;
        return true;
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ViewsetHierarchyNodeState lState = (ViewsetHierarchyNodeState)object;
    }

    public Object clone() throws CloneNotSupportedException {
        ViewsetHierarchyNodeState lState = (ViewsetHierarchyNodeState)((Object)super.clone());
        lState.mViewAreas = new HashMap();
        Iterator it = this.mViewAreas.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mViewAreas.put(lKey, ((PlaceholderState)((Object)this.mViewAreas.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = this.mViewAreas.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mViewAreas.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = this.mViewAreas.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mViewRef != null) {
            if (clipboardService.isExcluded(this.mViewRef)) {
                this.mViewRef = null;
            } else if (innerObjectKeys.contains(this.mViewRef.toReferenceString())) {
                this.mViewRef = clipboardService.refactor(this.mViewRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mViewRef != null && this.mViewRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mViewRef != null) {
            this.mViewRef = refactoringService.refactor(this.mViewRef);
        }
    }

    void addViewArea(PlaceholderState state) {
        this.mViewAreas.put(state.getName().toLowerCase(), state);
    }

    int getViewAreaCount() {
        return this.mViewAreas.size();
    }

    PlaceholderState getViewArea(String name) {
        return (PlaceholderState)((Object)this.mViewAreas.get(name.toLowerCase()));
    }

    Vector getViewAreas() {
        return new Vector(this.mViewAreas.values());
    }

    void removeViewArea(String aggregationKey) {
        this.mViewAreas.remove(aggregationKey.toLowerCase());
    }

    void removeViewArea(PlaceholderState state) {
        this.mViewAreas.remove(state.getName().toLowerCase());
    }

    void removeAllViewAreas() {
        this.mViewAreas.clear();
    }

    Reference getView() {
        return this.mViewRef;
    }

    void setView(Reference reference) {
        this.mViewRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ViewAreas")) {
            this.addViewArea((PlaceholderState)((Object)data));
        } else if (roleName.equals("View")) {
            this.setView((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

