/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.DimensionDefinitionState;
import com.sap.ide.metamodel.webdynpro.implementation.SimplePropertyDefinitionState;
import com.sap.ide.metamodel.webdynpro.implementation.ViewAreaDefinitionState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class ViewsetDefinitionState
extends CommonDevelopmentObjectState
implements MainDevelopmentObjectState {
    private String mMetamodelRelease = null;
    private String mMetamodelVersion = null;
    private String mMetamodelTimestamp = null;
    protected String mPackage = null;
    private String mMasterLanguage = null;
    private HashMap mDimensionDefinitions = new HashMap();
    private HashMap mSimplePropertyDefinitions = new HashMap();
    private HashMap mViewAreaDefinitions = new HashMap();

    ViewsetDefinitionState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ViewsetDefinitionState lState = (ViewsetDefinitionState)object;
        return isRootObject || this.mPackage.equals(lState.mPackage);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ViewsetDefinitionState lState = (ViewsetDefinitionState)object;
        if (!isRootObject && !this.mPackage.equals(lState.mPackage)) {
            compareContext.addPropertyDelta(sourceObject, "package", (Object)lState.mPackage);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ViewsetDefinitionState lState = (ViewsetDefinitionState)((Object)super.clone());
        lState.mDimensionDefinitions = new HashMap();
        Iterator it = this.mDimensionDefinitions.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mDimensionDefinitions.put(lKey, ((DimensionDefinitionState)((Object)this.mDimensionDefinitions.get(lKey))).clone());
        }
        lState.mSimplePropertyDefinitions = new HashMap();
        Iterator it2 = this.mSimplePropertyDefinitions.keySet().iterator();
        while (it2.hasNext()) {
            String lKey = (String)it2.next();
            lState.mSimplePropertyDefinitions.put(lKey, ((SimplePropertyDefinitionState)((Object)this.mSimplePropertyDefinitions.get(lKey))).clone());
        }
        lState.mViewAreaDefinitions = new HashMap();
        Iterator it3 = this.mViewAreaDefinitions.keySet().iterator();
        while (it3.hasNext()) {
            String lKey = (String)it3.next();
            lState.mViewAreaDefinitions.put(lKey, ((ViewAreaDefinitionState)((Object)this.mViewAreaDefinitions.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = this.mDimensionDefinitions.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it2 = this.mSimplePropertyDefinitions.values().iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it3 = this.mViewAreaDefinitions.values().iterator();
        while (it3.hasNext()) {
            ((DevelopmentObjectState)it3.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            this.setPackage(clipboardService.getNewPackage(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mDimensionDefinitions.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it2 = this.mSimplePropertyDefinitions.values().iterator();
        while (it2.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it2.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it2.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it3 = this.mViewAreaDefinitions.values().iterator();
        while (it3.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it3.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it3.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = this.mDimensionDefinitions.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it2 = this.mSimplePropertyDefinitions.values().iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it3 = this.mViewAreaDefinitions.values().iterator();
        while (it3.hasNext()) {
            ((DevelopmentObjectState)it3.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return super._hasReferencesToRefactor(oldReference);
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
    }

    public String getPackage() {
        return this.mPackage;
    }

    public void setPackage(String newPackage) {
        this.mPackage = newPackage;
    }

    public String getMasterLanguage() {
        return this.mMasterLanguage;
    }

    public void setMasterLanguage(String language) {
        this.mMasterLanguage = language;
    }

    public String _getMetamodelRelease() {
        return this.mMetamodelRelease;
    }

    public String _getMetamodelVersion() {
        return this.mMetamodelVersion;
    }

    public String _getMetamodelTimestamp() {
        return this.mMetamodelTimestamp;
    }

    public Reference getParent() {
        return null;
    }

    public void setParent(Reference parentReference) {
    }

    void addDimensionDefinition(DimensionDefinitionState state) {
        this.mDimensionDefinitions.put(state.getName().toLowerCase(), state);
    }

    int getDimensionDefinitionCount() {
        return this.mDimensionDefinitions.size();
    }

    DimensionDefinitionState getDimensionDefinition(String name) {
        return (DimensionDefinitionState)((Object)this.mDimensionDefinitions.get(name.toLowerCase()));
    }

    Vector getDimensionDefinitions() {
        return new Vector(this.mDimensionDefinitions.values());
    }

    void removeDimensionDefinition(String aggregationKey) {
        this.mDimensionDefinitions.remove(aggregationKey.toLowerCase());
    }

    void removeDimensionDefinition(DimensionDefinitionState state) {
        this.mDimensionDefinitions.remove(state.getName().toLowerCase());
    }

    void removeAllDimensionDefinitions() {
        this.mDimensionDefinitions.clear();
    }

    void addSimplePropertyDefinition(SimplePropertyDefinitionState state) {
        this.mSimplePropertyDefinitions.put(state.getName().toLowerCase(), state);
    }

    int getSimplePropertyDefinitionCount() {
        return this.mSimplePropertyDefinitions.size();
    }

    SimplePropertyDefinitionState getSimplePropertyDefinition(String name) {
        return (SimplePropertyDefinitionState)((Object)this.mSimplePropertyDefinitions.get(name.toLowerCase()));
    }

    Vector getSimplePropertyDefinitions() {
        return new Vector(this.mSimplePropertyDefinitions.values());
    }

    void removeSimplePropertyDefinition(String aggregationKey) {
        this.mSimplePropertyDefinitions.remove(aggregationKey.toLowerCase());
    }

    void removeSimplePropertyDefinition(SimplePropertyDefinitionState state) {
        this.mSimplePropertyDefinitions.remove(state.getName().toLowerCase());
    }

    void removeAllSimplePropertyDefinitions() {
        this.mSimplePropertyDefinitions.clear();
    }

    void addViewAreaDefinition(ViewAreaDefinitionState state) {
        this.mViewAreaDefinitions.put(state.getName().toLowerCase(), state);
    }

    int getViewAreaDefinitionCount() {
        return this.mViewAreaDefinitions.size();
    }

    ViewAreaDefinitionState getViewAreaDefinition(String name) {
        return (ViewAreaDefinitionState)((Object)this.mViewAreaDefinitions.get(name.toLowerCase()));
    }

    Vector getViewAreaDefinitions() {
        return new Vector(this.mViewAreaDefinitions.values());
    }

    void removeViewAreaDefinition(String aggregationKey) {
        this.mViewAreaDefinitions.remove(aggregationKey.toLowerCase());
    }

    void removeViewAreaDefinition(ViewAreaDefinitionState state) {
        this.mViewAreaDefinitions.remove(state.getName().toLowerCase());
    }

    void removeAllViewAreaDefinitions() {
        this.mViewAreaDefinitions.clear();
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("mmRelease")) {
            this.mMetamodelRelease = (String)value;
        } else if (propertyName.equals("mmVersion")) {
            this.mMetamodelVersion = (String)value;
        } else if (propertyName.equals("mmTimestamp")) {
            this.mMetamodelTimestamp = (String)value;
        } else if (propertyName.equals("name")) {
            this.setName((String)value);
        } else if (propertyName.equals("package")) {
            this.setPackage((String)value);
        } else if (propertyName.equals("masterLanguage")) {
            this.setMasterLanguage((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("DimensionDefinitions")) {
            this.addDimensionDefinition((DimensionDefinitionState)((Object)data));
        } else if (roleName.equals("SimplePropertyDefinitions")) {
            this.addSimplePropertyDefinition((SimplePropertyDefinitionState)((Object)data));
        } else if (roleName.equals("ViewAreaDefinitions")) {
            this.addViewAreaDefinition((ViewAreaDefinitionState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

