/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.ViewsetHierarchyNodeState;
import java.util.ArrayList;

class ViewUsageState
extends ViewsetHierarchyNodeState {
    private String mId = null;
    private boolean mHasId = false;
    private Reference mComponentUsageRef = null;

    ViewUsageState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ViewUsageState lState = (ViewUsageState)object;
        return String.valueOf(this.mId).equals(String.valueOf(lState.mId));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ViewUsageState lState = (ViewUsageState)object;
        if (!String.valueOf(this.mId).equals(String.valueOf(lState.mId))) {
            compareContext.addPropertyDelta(sourceObject, "id", (Object)lState.mId);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ViewUsageState lState = (ViewUsageState)((Object)super.clone());
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mComponentUsageRef != null) {
            if (clipboardService.isExcluded(this.mComponentUsageRef)) {
                this.mComponentUsageRef = null;
            } else if (innerObjectKeys.contains(this.mComponentUsageRef.toReferenceString())) {
                this.mComponentUsageRef = clipboardService.refactor(this.mComponentUsageRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mComponentUsageRef != null && this.mComponentUsageRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mComponentUsageRef != null) {
            this.mComponentUsageRef = refactoringService.refactor(this.mComponentUsageRef);
        }
    }

    void setId(String value) {
        if (value == null) {
            this.unsetId();
            return;
        }
        this.mId = value;
        this.mHasId = true;
    }

    String getId() {
        return this.mId;
    }

    boolean hasId() {
        return this.mHasId;
    }

    void unsetId() {
        this.mId = null;
        this.mHasId = false;
    }

    Reference getComponentUsage() {
        return this.mComponentUsageRef;
    }

    void setComponentUsage(Reference reference) {
        this.mComponentUsageRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("id")) {
            this.setId((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ComponentUsage")) {
            this.setComponentUsage((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

