/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.AbstractViewState;
import com.sap.ide.metamodel.webdynpro.implementation.UIElementContainerState;
import com.sap.ide.metamodel.webdynpro.implementation.ViewContainerState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class ViewState
extends AbstractViewState
implements MainDevelopmentObjectState {
    private String mMetamodelRelease = null;
    private String mMetamodelVersion = null;
    private String mMetamodelTimestamp = null;
    protected String mPackage = null;
    private String mMasterLanguage = null;
    private Reference mParent;
    private UIElementContainerState mRootUIElementContainer = null;
    private HashMap mViewContainers = new HashMap();

    ViewState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ViewState lState = (ViewState)object;
        return isRootObject || this.mPackage.equals(lState.mPackage);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ViewState lState = (ViewState)object;
        if (!isRootObject && !this.mPackage.equals(lState.mPackage)) {
            compareContext.addPropertyDelta(sourceObject, "package", (Object)lState.mPackage);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ViewState lState = (ViewState)((Object)super.clone());
        if (this.mRootUIElementContainer != null) {
            lState.mRootUIElementContainer = (UIElementContainerState)((Object)this.mRootUIElementContainer.clone());
        }
        lState.mViewContainers = new HashMap();
        Iterator it = this.mViewContainers.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mViewContainers.put(lKey, ((ViewContainerState)((Object)this.mViewContainers.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mRootUIElementContainer != null) {
            this.mRootUIElementContainer.removeExternalReferences(innerObjectKeys);
        }
        Iterator it = this.mViewContainers.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            this.setPackage(clipboardService.getNewPackage(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        if (this.mRootUIElementContainer != null) {
            if (clipboardService.isExcluded((Reference)this.mRootUIElementContainer.getProxyReference())) {
                this.mRootUIElementContainer = null;
            } else {
                this.mRootUIElementContainer.refactor(clipboardService);
            }
        }
        Iterator it = this.mViewContainers.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mRootUIElementContainer != null) {
            this.mRootUIElementContainer.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it = this.mViewContainers.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mParent != null) {
            this.mParent = clipboardService.refactor(this.mParent);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return super._hasReferencesToRefactor(oldReference);
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mParent != null) {
            this.mParent = refactoringService.refactor(this.mParent);
        }
    }

    public String getPackage() {
        return this.mPackage;
    }

    public void setPackage(String newPackage) {
        this.mPackage = newPackage;
    }

    public String getMasterLanguage() {
        return this.mMasterLanguage;
    }

    public void setMasterLanguage(String language) {
        this.mMasterLanguage = language;
    }

    public String _getMetamodelRelease() {
        return this.mMetamodelRelease;
    }

    public String _getMetamodelVersion() {
        return this.mMetamodelVersion;
    }

    public String _getMetamodelTimestamp() {
        return this.mMetamodelTimestamp;
    }

    public Reference getParent() {
        return this.mParent;
    }

    public void setParent(Reference parentReference) {
        this.mParent = parentReference;
    }

    void setRootUIElementContainer(UIElementContainerState state) {
        this.mRootUIElementContainer = state;
    }

    UIElementContainerState getRootUIElementContainer() {
        return this.mRootUIElementContainer;
    }

    void addViewContainer(ViewContainerState state) {
        this.mViewContainers.put(state.getName().toLowerCase(), state);
    }

    int getViewContainerCount() {
        return this.mViewContainers.size();
    }

    ViewContainerState getViewContainer(String name) {
        return (ViewContainerState)((Object)this.mViewContainers.get(name.toLowerCase()));
    }

    Vector getViewContainers() {
        return new Vector(this.mViewContainers.values());
    }

    void removeViewContainer(String aggregationKey) {
        this.mViewContainers.remove(aggregationKey.toLowerCase());
    }

    void removeViewContainer(ViewContainerState state) {
        this.mViewContainers.remove(state.getName().toLowerCase());
    }

    void removeAllViewContainers() {
        this.mViewContainers.clear();
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("mmRelease")) {
            this.mMetamodelRelease = (String)value;
        } else if (propertyName.equals("mmVersion")) {
            this.mMetamodelVersion = (String)value;
        } else if (propertyName.equals("mmTimestamp")) {
            this.mMetamodelTimestamp = (String)value;
        } else if (propertyName.equals("package")) {
            this.setPackage((String)value);
        } else if (propertyName.equals("masterLanguage")) {
            this.setMasterLanguage((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Parent")) {
            this.setParent((Reference)data);
        } else if (roleName.equals("RootUIElementContainer")) {
            this.setRootUIElementContainer((UIElementContainerState)((Object)data));
        } else if (roleName.equals("ViewContainers")) {
            this.addViewContainer((ViewContainerState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

