/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.AbstractViewElementPropertyState;
import com.sap.ide.metamodel.webdynpro.implementation.UIElementContextBindingState;
import com.sap.ide.metamodel.webdynpro.implementation.UIElementEventBindingState;
import com.sap.ide.metamodel.webdynpro.implementation.ViewElementAggregationState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class ViewElementState
extends CommonDevelopmentObjectState {
    private HashMap mContextBindings = new HashMap();
    private HashMap mEventBindings = new HashMap();
    private Vector mOutgoingAggregations = new Vector();
    private Vector mProperties = new Vector();
    private Reference mDefinitionRef = null;

    ViewElementState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ViewElementState lState = (ViewElementState)object;
        return true;
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ViewElementState lState = (ViewElementState)object;
    }

    public Object clone() throws CloneNotSupportedException {
        ViewElementState lState = (ViewElementState)((Object)super.clone());
        lState.mContextBindings = new HashMap();
        Iterator it = this.mContextBindings.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mContextBindings.put(lKey, ((UIElementContextBindingState)((Object)this.mContextBindings.get(lKey))).clone());
        }
        lState.mEventBindings = new HashMap();
        Iterator it2 = this.mEventBindings.keySet().iterator();
        while (it2.hasNext()) {
            String lKey = (String)it2.next();
            lState.mEventBindings.put(lKey, ((UIElementEventBindingState)((Object)this.mEventBindings.get(lKey))).clone());
        }
        lState.mOutgoingAggregations = new Vector();
        int i = 0;
        while (i < this.mOutgoingAggregations.size()) {
            lState.mOutgoingAggregations.add(((ViewElementAggregationState)((Object)this.mOutgoingAggregations.get(i))).clone());
            ++i;
        }
        lState.mProperties = new Vector();
        int i2 = 0;
        while (i2 < this.mProperties.size()) {
            lState.mProperties.add(((AbstractViewElementPropertyState)((Object)this.mProperties.get(i2))).clone());
            ++i2;
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = this.mContextBindings.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it2 = this.mEventBindings.values().iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it3 = ((AbstractList)this.mOutgoingAggregations).iterator();
        while (it3.hasNext()) {
            ((DevelopmentObjectState)it3.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it4 = ((AbstractList)this.mProperties).iterator();
        while (it4.hasNext()) {
            ((DevelopmentObjectState)it4.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mContextBindings.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it2 = this.mEventBindings.values().iterator();
        while (it2.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it2.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it2.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it3 = ((AbstractList)this.mOutgoingAggregations).iterator();
        while (it3.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it3.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it3.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it4 = ((AbstractList)this.mProperties).iterator();
        while (it4.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it4.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it4.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = this.mContextBindings.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it2 = this.mEventBindings.values().iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it3 = ((AbstractList)this.mOutgoingAggregations).iterator();
        while (it3.hasNext()) {
            ((DevelopmentObjectState)it3.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it4 = ((AbstractList)this.mProperties).iterator();
        while (it4.hasNext()) {
            ((DevelopmentObjectState)it4.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mDefinitionRef != null) {
            if (clipboardService.isExcluded(this.mDefinitionRef)) {
                this.mDefinitionRef = null;
            } else if (innerObjectKeys.contains(this.mDefinitionRef.toReferenceString())) {
                this.mDefinitionRef = clipboardService.refactor(this.mDefinitionRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mDefinitionRef != null && this.mDefinitionRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mDefinitionRef != null) {
            this.mDefinitionRef = refactoringService.refactor(this.mDefinitionRef);
        }
    }

    void addContextBinding(UIElementContextBindingState state) {
        this.mContextBindings.put(state.getName().toLowerCase(), state);
    }

    int getContextBindingCount() {
        return this.mContextBindings.size();
    }

    UIElementContextBindingState getContextBinding(String name) {
        return (UIElementContextBindingState)((Object)this.mContextBindings.get(name.toLowerCase()));
    }

    Vector getContextBindings() {
        return new Vector(this.mContextBindings.values());
    }

    void removeContextBinding(String aggregationKey) {
        this.mContextBindings.remove(aggregationKey.toLowerCase());
    }

    void removeContextBinding(UIElementContextBindingState state) {
        this.mContextBindings.remove(state.getName().toLowerCase());
    }

    void removeAllContextBindings() {
        this.mContextBindings.clear();
    }

    void addEventBinding(UIElementEventBindingState state) {
        this.mEventBindings.put(state.getName().toLowerCase(), state);
    }

    int getEventBindingCount() {
        return this.mEventBindings.size();
    }

    UIElementEventBindingState getEventBinding(String name) {
        return (UIElementEventBindingState)((Object)this.mEventBindings.get(name.toLowerCase()));
    }

    Vector getEventBindings() {
        return new Vector(this.mEventBindings.values());
    }

    void removeEventBinding(String aggregationKey) {
        this.mEventBindings.remove(aggregationKey.toLowerCase());
    }

    void removeEventBinding(UIElementEventBindingState state) {
        this.mEventBindings.remove(state.getName().toLowerCase());
    }

    void removeAllEventBindings() {
        this.mEventBindings.clear();
    }

    void addOutgoingAggregation(ViewElementAggregationState state) {
        this.mOutgoingAggregations.add(state);
    }

    void addOutgoingAggregation(ViewElementAggregationState state, int position) {
        this.mOutgoingAggregations.add(position, state);
    }

    int getOutgoingAggregationCount() {
        return this.mOutgoingAggregations.size();
    }

    ViewElementAggregationState getOutgoingAggregation(String name) {
        int i = 0;
        while (i < this.mOutgoingAggregations.size()) {
            ViewElementAggregationState lState = (ViewElementAggregationState)((Object)this.mOutgoingAggregations.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getOutgoingAggregations() {
        return this.mOutgoingAggregations;
    }

    void removeOutgoingAggregation(ViewElementAggregationState state) {
        this.mOutgoingAggregations.remove((Object)state);
    }

    void removeAllOutgoingAggregations() {
        this.mOutgoingAggregations.clear();
    }

    void addProperty(AbstractViewElementPropertyState state) {
        this.mProperties.add(state);
    }

    void addProperty(AbstractViewElementPropertyState state, int position) {
        this.mProperties.add(position, state);
    }

    int getPropertyCount() {
        return this.mProperties.size();
    }

    AbstractViewElementPropertyState getProperty(String name) {
        int i = 0;
        while (i < this.mProperties.size()) {
            AbstractViewElementPropertyState lState = (AbstractViewElementPropertyState)((Object)this.mProperties.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getProperties() {
        return this.mProperties;
    }

    void removeProperty(AbstractViewElementPropertyState state) {
        this.mProperties.remove((Object)state);
    }

    void removeAllProperties() {
        this.mProperties.clear();
    }

    void moveOutgoingAggregation(int fromPosition, int toPosition) {
        this.mOutgoingAggregations.add(toPosition, this.mOutgoingAggregations.remove(fromPosition));
    }

    void moveProperty(int fromPosition, int toPosition) {
        this.mProperties.add(toPosition, this.mProperties.remove(fromPosition));
    }

    Reference getDefinition() {
        return this.mDefinitionRef;
    }

    void setDefinition(Reference reference) {
        this.mDefinitionRef = reference;
    }

    void reorderOutgoingAggregations(Vector orderedStates) {
        this.mOutgoingAggregations = orderedStates;
    }

    void reorderProperties(Vector orderedStates) {
        this.mProperties = orderedStates;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ContextBindings")) {
            this.addContextBinding((UIElementContextBindingState)((Object)data));
        } else if (roleName.equals("EventBindings")) {
            this.addEventBinding((UIElementEventBindingState)((Object)data));
        } else if (roleName.equals("OutgoingAggregations")) {
            this.addOutgoingAggregation((ViewElementAggregationState)((Object)data));
        } else if (roleName.equals("Properties")) {
            this.addProperty((AbstractViewElementPropertyState)((Object)data));
        } else if (roleName.equals("Definition")) {
            this.setDefinition((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

