/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.AbstractViewElementPropertyDefState;
import com.sap.ide.metamodel.webdynpro.implementation.FrameworkObjectDefinitionState;
import com.sap.ide.metamodel.webdynpro.implementation.TaggedValueState;
import com.sap.ide.metamodel.webdynpro.implementation.ViewElementAggregationDefState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

abstract class ViewElementDefinitionState
extends FrameworkObjectDefinitionState {
    private Vector mOutgoingAggregations = new Vector();
    private Vector mProperties = new Vector();
    private Vector mTaggedValues = new Vector();
    private Reference mDefaultAggregationRef = null;
    private HashMap mImplementedInterfaceRefs = new HashMap();

    ViewElementDefinitionState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        return super.isEqualTo(object, isRootObject);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
    }

    public Object clone() throws CloneNotSupportedException {
        ViewElementDefinitionState lState = (ViewElementDefinitionState)((Object)super.clone());
        lState.mOutgoingAggregations = new Vector();
        int i = 0;
        while (i < this.mOutgoingAggregations.size()) {
            lState.mOutgoingAggregations.add(((ViewElementAggregationDefState)((Object)this.mOutgoingAggregations.get(i))).clone());
            ++i;
        }
        lState.mProperties = new Vector();
        int i2 = 0;
        while (i2 < this.mProperties.size()) {
            lState.mProperties.add(((AbstractViewElementPropertyDefState)((Object)this.mProperties.get(i2))).clone());
            ++i2;
        }
        lState.mTaggedValues = new Vector();
        int i3 = 0;
        while (i3 < this.mTaggedValues.size()) {
            lState.mTaggedValues.add(((TaggedValueState)((Object)this.mTaggedValues.get(i3))).clone());
            ++i3;
        }
        lState.mImplementedInterfaceRefs = (HashMap)this.mImplementedInterfaceRefs.clone();
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mDefaultAggregationRef != null && !innerObjectKeys.contains(this.mDefaultAggregationRef.toString())) {
            this.mDefaultAggregationRef = null;
        }
        Iterator it = ((AbstractList)this.mOutgoingAggregations).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it2 = ((AbstractList)this.mProperties).iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it3 = ((AbstractList)this.mTaggedValues).iterator();
        while (it3.hasNext()) {
            ((DevelopmentObjectState)it3.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = ((AbstractList)this.mOutgoingAggregations).iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it2 = ((AbstractList)this.mProperties).iterator();
        while (it2.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it2.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it2.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it3 = ((AbstractList)this.mTaggedValues).iterator();
        while (it3.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it3.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it3.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = ((AbstractList)this.mOutgoingAggregations).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it2 = ((AbstractList)this.mProperties).iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it3 = ((AbstractList)this.mTaggedValues).iterator();
        while (it3.hasNext()) {
            ((DevelopmentObjectState)it3.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mDefaultAggregationRef != null) {
            if (clipboardService.isExcluded(this.mDefaultAggregationRef)) {
                this.mDefaultAggregationRef = null;
            } else if (innerObjectKeys.contains(this.mDefaultAggregationRef.toReferenceString())) {
                this.mDefaultAggregationRef = clipboardService.refactor(this.mDefaultAggregationRef);
            }
        }
        HashMap<String, Reference> lHashMap = new HashMap<String, Reference>();
        Iterator it4 = this.mImplementedInterfaceRefs.values().iterator();
        while (it4.hasNext()) {
            Reference lReference = (Reference)it4.next();
            if (clipboardService.isExcluded(lReference)) continue;
            if (innerObjectKeys.contains(lReference.toReferenceString())) {
                lReference = clipboardService.refactor(lReference);
            }
            lHashMap.put(lReference.toString(), lReference);
        }
        this.mImplementedInterfaceRefs = lHashMap;
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        if (this.mDefaultAggregationRef != null && this.mDefaultAggregationRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        Iterator it = this.mImplementedInterfaceRefs.values().iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        return false;
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mDefaultAggregationRef != null) {
            this.mDefaultAggregationRef = refactoringService.refactor(this.mDefaultAggregationRef);
        }
        HashMap<String, Reference> lHashMap = new HashMap<String, Reference>();
        Iterator it = this.mImplementedInterfaceRefs.values().iterator();
        while (it.hasNext()) {
            Reference lReference = refactoringService.refactor((Reference)it.next());
            lHashMap.put(lReference.toString(), lReference);
        }
        this.mImplementedInterfaceRefs = lHashMap;
    }

    void addOutgoingAggregation(ViewElementAggregationDefState state) {
        this.mOutgoingAggregations.add(state);
    }

    void addOutgoingAggregation(ViewElementAggregationDefState state, int position) {
        this.mOutgoingAggregations.add(position, state);
    }

    int getOutgoingAggregationCount() {
        return this.mOutgoingAggregations.size();
    }

    ViewElementAggregationDefState getOutgoingAggregation(String name) {
        int i = 0;
        while (i < this.mOutgoingAggregations.size()) {
            ViewElementAggregationDefState lState = (ViewElementAggregationDefState)((Object)this.mOutgoingAggregations.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getOutgoingAggregations() {
        return this.mOutgoingAggregations;
    }

    void removeOutgoingAggregation(ViewElementAggregationDefState state) {
        this.mOutgoingAggregations.remove((Object)state);
    }

    void removeAllOutgoingAggregations() {
        this.mOutgoingAggregations.clear();
    }

    void addProperty(AbstractViewElementPropertyDefState state) {
        this.mProperties.add(state);
    }

    void addProperty(AbstractViewElementPropertyDefState state, int position) {
        this.mProperties.add(position, state);
    }

    int getPropertyCount() {
        return this.mProperties.size();
    }

    AbstractViewElementPropertyDefState getProperty(String name) {
        int i = 0;
        while (i < this.mProperties.size()) {
            AbstractViewElementPropertyDefState lState = (AbstractViewElementPropertyDefState)((Object)this.mProperties.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getProperties() {
        return this.mProperties;
    }

    void removeProperty(AbstractViewElementPropertyDefState state) {
        this.mProperties.remove((Object)state);
    }

    void removeAllProperties() {
        this.mProperties.clear();
    }

    void addTaggedValue(TaggedValueState state) {
        this.mTaggedValues.add(state);
    }

    void addTaggedValue(TaggedValueState state, int position) {
        this.mTaggedValues.add(position, state);
    }

    int getTaggedValueCount() {
        return this.mTaggedValues.size();
    }

    TaggedValueState getTaggedValue(String name) {
        int i = 0;
        while (i < this.mTaggedValues.size()) {
            TaggedValueState lState = (TaggedValueState)((Object)this.mTaggedValues.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getTaggedValues() {
        return this.mTaggedValues;
    }

    void removeTaggedValue(TaggedValueState state) {
        this.mTaggedValues.remove((Object)state);
    }

    void removeAllTaggedValues() {
        this.mTaggedValues.clear();
    }

    void moveOutgoingAggregation(int fromPosition, int toPosition) {
        this.mOutgoingAggregations.add(toPosition, this.mOutgoingAggregations.remove(fromPosition));
    }

    void moveProperty(int fromPosition, int toPosition) {
        this.mProperties.add(toPosition, this.mProperties.remove(fromPosition));
    }

    void moveTaggedValue(int fromPosition, int toPosition) {
        this.mTaggedValues.add(toPosition, this.mTaggedValues.remove(fromPosition));
    }

    Reference getDefaultAggregation() {
        return this.mDefaultAggregationRef;
    }

    void setDefaultAggregation(Reference reference) {
        this.mDefaultAggregationRef = reference;
    }

    void addImplementedInterface(Reference reference) {
        this.mImplementedInterfaceRefs.put(reference.toString(), reference);
    }

    int getImplementedInterfaceCount() {
        return this.mImplementedInterfaceRefs.size();
    }

    Reference getImplementedInterface(Reference reference) {
        return (Reference)this.mImplementedInterfaceRefs.get(reference.toString());
    }

    Vector getImplementedInterfaces() {
        return new Vector(this.mImplementedInterfaceRefs.values());
    }

    void removeImplementedInterface(Reference reference) {
        this.mImplementedInterfaceRefs.remove(reference.toString());
    }

    void removeAllImplementedInterfaces() {
        this.mImplementedInterfaceRefs.clear();
    }

    void replaceImplementedInterface(Reference oldReference, Reference newReference) {
        this.mImplementedInterfaceRefs.remove(oldReference.toString());
        this.mImplementedInterfaceRefs.put(newReference.toString(), newReference);
    }

    void reorderOutgoingAggregations(Vector orderedStates) {
        this.mOutgoingAggregations = orderedStates;
    }

    void reorderProperties(Vector orderedStates) {
        this.mProperties = orderedStates;
    }

    void reorderTaggedValues(Vector orderedStates) {
        this.mTaggedValues = orderedStates;
    }

    public void setProperty(String propertyName, Object value) {
        super.setProperty(propertyName, value);
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("OutgoingAggregations")) {
            this.addOutgoingAggregation((ViewElementAggregationDefState)((Object)data));
        } else if (roleName.equals("Properties")) {
            this.addProperty((AbstractViewElementPropertyDefState)((Object)data));
        } else if (roleName.equals("TaggedValues")) {
            this.addTaggedValue((TaggedValueState)((Object)data));
        } else if (roleName.equals("DefaultAggregation")) {
            this.setDefaultAggregation((Reference)data);
        } else if (roleName.equals("ImplementedInterfaces")) {
            this.addImplementedInterface((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

