/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.MarkerInterfaceState;
import com.sap.ide.metamodel.webdynpro.implementation.TaggedValueState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class UIElementLibraryState
extends CommonDevelopmentObjectState
implements MainDevelopmentObjectState {
    private String mMetamodelRelease = null;
    private String mMetamodelVersion = null;
    private String mMetamodelTimestamp = null;
    protected String mPackage = null;
    private String mMasterLanguage = null;
    private HashMap mLayoutDefinitionRefs = new HashMap();
    private Vector mMarkerInterfaces = new Vector();
    private Vector mTaggedValues = new Vector();
    private HashMap mUIElementContainerDefinitionRefs = new HashMap();
    private HashMap mUIElementDefinitionRefs = new HashMap();
    private HashMap mViewElementDefinitionRefs = new HashMap();
    private Vector mUsedLibraryRefs = new Vector();

    UIElementLibraryState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        UIElementLibraryState lState = (UIElementLibraryState)object;
        return isRootObject || this.mPackage.equals(lState.mPackage);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        UIElementLibraryState lState = (UIElementLibraryState)object;
        if (!isRootObject && !this.mPackage.equals(lState.mPackage)) {
            compareContext.addPropertyDelta(sourceObject, "package", (Object)lState.mPackage);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        UIElementLibraryState lState = (UIElementLibraryState)((Object)super.clone());
        lState.mLayoutDefinitionRefs = (HashMap)this.mLayoutDefinitionRefs.clone();
        lState.mMarkerInterfaces = new Vector();
        int i = 0;
        while (i < this.mMarkerInterfaces.size()) {
            lState.mMarkerInterfaces.add(((MarkerInterfaceState)((Object)this.mMarkerInterfaces.get(i))).clone());
            ++i;
        }
        lState.mTaggedValues = new Vector();
        int i2 = 0;
        while (i2 < this.mTaggedValues.size()) {
            lState.mTaggedValues.add(((TaggedValueState)((Object)this.mTaggedValues.get(i2))).clone());
            ++i2;
        }
        lState.mUIElementContainerDefinitionRefs = (HashMap)this.mUIElementContainerDefinitionRefs.clone();
        lState.mUIElementDefinitionRefs = (HashMap)this.mUIElementDefinitionRefs.clone();
        lState.mViewElementDefinitionRefs = (HashMap)this.mViewElementDefinitionRefs.clone();
        lState.mUsedLibraryRefs = (Vector)this.mUsedLibraryRefs.clone();
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = ((AbstractList)this.mMarkerInterfaces).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it2 = ((AbstractList)this.mTaggedValues).iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            this.setPackage(clipboardService.getNewPackage(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mLayoutDefinitionRefs.values().iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (!clipboardService.isExcluded(lReference)) continue;
            it.remove();
        }
        Iterator it2 = ((AbstractList)this.mMarkerInterfaces).iterator();
        while (it2.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it2.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it2.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it3 = ((AbstractList)this.mTaggedValues).iterator();
        while (it3.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it3.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it3.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it4 = this.mUIElementContainerDefinitionRefs.values().iterator();
        while (it4.hasNext()) {
            Reference lReference = (Reference)it4.next();
            if (!clipboardService.isExcluded(lReference)) continue;
            it4.remove();
        }
        Iterator it5 = this.mUIElementDefinitionRefs.values().iterator();
        while (it5.hasNext()) {
            Reference lReference = (Reference)it5.next();
            if (!clipboardService.isExcluded(lReference)) continue;
            it5.remove();
        }
        Iterator it6 = this.mViewElementDefinitionRefs.values().iterator();
        while (it6.hasNext()) {
            Reference lReference = (Reference)it6.next();
            if (!clipboardService.isExcluded(lReference)) continue;
            it6.remove();
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        Reference lReference;
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        HashMap<String, Reference> lHashMap = new HashMap<String, Reference>();
        Iterator<Object> it = this.mLayoutDefinitionRefs.values().iterator();
        while (it.hasNext()) {
            Reference lReference2 = clipboardService.refactor((Reference)it.next());
            lHashMap.put((lReference2.getMDOPackage() + "." + lReference2.getMDOName()).toLowerCase(), lReference2);
        }
        this.mLayoutDefinitionRefs = lHashMap;
        Iterator it2 = ((AbstractList)this.mMarkerInterfaces).iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        it = ((AbstractList)this.mTaggedValues).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        HashMap<String, Reference> lHashMap2 = new HashMap<String, Reference>();
        Iterator<Object> it3 = this.mUIElementContainerDefinitionRefs.values().iterator();
        while (it3.hasNext()) {
            lReference = clipboardService.refactor((Reference)it3.next());
            lHashMap2.put((lReference.getMDOPackage() + "." + lReference.getMDOName()).toLowerCase(), lReference);
        }
        this.mUIElementContainerDefinitionRefs = lHashMap2;
        lHashMap2 = new HashMap();
        it3 = this.mUIElementDefinitionRefs.values().iterator();
        while (it3.hasNext()) {
            lReference = clipboardService.refactor((Reference)it3.next());
            lHashMap2.put((lReference.getMDOPackage() + "." + lReference.getMDOName()).toLowerCase(), lReference);
        }
        this.mUIElementDefinitionRefs = lHashMap2;
        lHashMap2 = new HashMap();
        it3 = this.mViewElementDefinitionRefs.values().iterator();
        while (it3.hasNext()) {
            lReference = clipboardService.refactor((Reference)it3.next());
            lHashMap2.put((lReference.getMDOPackage() + "." + lReference.getMDOName()).toLowerCase(), lReference);
        }
        this.mViewElementDefinitionRefs = lHashMap2;
        Vector<Reference> lVector = new Vector<Reference>();
        it3 = ((AbstractList)this.mUsedLibraryRefs).iterator();
        while (it3.hasNext()) {
            lReference = (Reference)it3.next();
            if (clipboardService.isExcluded(lReference)) continue;
            if (innerObjectKeys.contains(lReference.toReferenceString())) {
                lReference = clipboardService.refactor(lReference);
            }
            lVector.add(lReference);
        }
        this.mUsedLibraryRefs = lVector;
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        Iterator it = this.mLayoutDefinitionRefs.values().iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        Iterator it2 = this.mUIElementContainerDefinitionRefs.values().iterator();
        while (it2.hasNext()) {
            Reference lReference = (Reference)it2.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        Iterator it3 = this.mUIElementDefinitionRefs.values().iterator();
        while (it3.hasNext()) {
            Reference lReference = (Reference)it3.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        Iterator it4 = this.mViewElementDefinitionRefs.values().iterator();
        while (it4.hasNext()) {
            Reference lReference = (Reference)it4.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        Iterator it5 = ((AbstractList)this.mUsedLibraryRefs).iterator();
        while (it5.hasNext()) {
            Reference lReference = (Reference)it5.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        return false;
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        Vector<Reference> lList = new Vector<Reference>();
        Iterator it = ((AbstractList)this.mUsedLibraryRefs).iterator();
        while (it.hasNext()) {
            lList.add(refactoringService.refactor((Reference)it.next()));
        }
        this.mUsedLibraryRefs = lList;
    }

    public String getPackage() {
        return this.mPackage;
    }

    public void setPackage(String newPackage) {
        this.mPackage = newPackage;
    }

    public String getMasterLanguage() {
        return this.mMasterLanguage;
    }

    public void setMasterLanguage(String language) {
        this.mMasterLanguage = language;
    }

    public String _getMetamodelRelease() {
        return this.mMetamodelRelease;
    }

    public String _getMetamodelVersion() {
        return this.mMetamodelVersion;
    }

    public String _getMetamodelTimestamp() {
        return this.mMetamodelTimestamp;
    }

    public Reference getParent() {
        return null;
    }

    public void setParent(Reference parentReference) {
    }

    void addLayoutDefinition(Reference reference) {
        this.mLayoutDefinitionRefs.put((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase(), reference);
    }

    int getLayoutDefinitionCount() {
        return this.mLayoutDefinitionRefs.size();
    }

    Reference getLayoutDefinition(String _package, String name) {
        return (Reference)this.mLayoutDefinitionRefs.get((_package + "." + name).toLowerCase());
    }

    Vector getLayoutDefinitions() {
        return new Vector(this.mLayoutDefinitionRefs.values());
    }

    void removeLayoutDefinition(Reference reference) {
        this.mLayoutDefinitionRefs.remove((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase());
    }

    void removeLayoutDefinition(String aggregationKey) {
        this.mLayoutDefinitionRefs.remove(aggregationKey);
    }

    void removeLayoutDefinition(String _package, String name) {
        this.mLayoutDefinitionRefs.remove((_package + "." + name).toLowerCase());
    }

    void removeAllLayoutDefinitions() {
        this.mLayoutDefinitionRefs.clear();
    }

    void addMarkerInterface(MarkerInterfaceState state) {
        this.mMarkerInterfaces.add(state);
    }

    void addMarkerInterface(MarkerInterfaceState state, int position) {
        this.mMarkerInterfaces.add(position, state);
    }

    int getMarkerInterfaceCount() {
        return this.mMarkerInterfaces.size();
    }

    MarkerInterfaceState getMarkerInterface(String name) {
        int i = 0;
        while (i < this.mMarkerInterfaces.size()) {
            MarkerInterfaceState lState = (MarkerInterfaceState)((Object)this.mMarkerInterfaces.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getMarkerInterfaces() {
        return this.mMarkerInterfaces;
    }

    void removeMarkerInterface(MarkerInterfaceState state) {
        this.mMarkerInterfaces.remove((Object)state);
    }

    void removeAllMarkerInterfaces() {
        this.mMarkerInterfaces.clear();
    }

    void addTaggedValue(TaggedValueState state) {
        this.mTaggedValues.add(state);
    }

    void addTaggedValue(TaggedValueState state, int position) {
        this.mTaggedValues.add(position, state);
    }

    int getTaggedValueCount() {
        return this.mTaggedValues.size();
    }

    TaggedValueState getTaggedValue(String name) {
        int i = 0;
        while (i < this.mTaggedValues.size()) {
            TaggedValueState lState = (TaggedValueState)((Object)this.mTaggedValues.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getTaggedValues() {
        return this.mTaggedValues;
    }

    void removeTaggedValue(TaggedValueState state) {
        this.mTaggedValues.remove((Object)state);
    }

    void removeAllTaggedValues() {
        this.mTaggedValues.clear();
    }

    void addUIElementContainerDefinition(Reference reference) {
        this.mUIElementContainerDefinitionRefs.put((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase(), reference);
    }

    int getUIElementContainerDefinitionCount() {
        return this.mUIElementContainerDefinitionRefs.size();
    }

    Reference getUIElementContainerDefinition(String _package, String name) {
        return (Reference)this.mUIElementContainerDefinitionRefs.get((_package + "." + name).toLowerCase());
    }

    Vector getUIElementContainerDefinitions() {
        return new Vector(this.mUIElementContainerDefinitionRefs.values());
    }

    void removeUIElementContainerDefinition(Reference reference) {
        this.mUIElementContainerDefinitionRefs.remove((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase());
    }

    void removeUIElementContainerDefinition(String aggregationKey) {
        this.mUIElementContainerDefinitionRefs.remove(aggregationKey);
    }

    void removeUIElementContainerDefinition(String _package, String name) {
        this.mUIElementContainerDefinitionRefs.remove((_package + "." + name).toLowerCase());
    }

    void removeAllUIElementContainerDefinitions() {
        this.mUIElementContainerDefinitionRefs.clear();
    }

    void addUIElementDefinition(Reference reference) {
        this.mUIElementDefinitionRefs.put((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase(), reference);
    }

    int getUIElementDefinitionCount() {
        return this.mUIElementDefinitionRefs.size();
    }

    Reference getUIElementDefinition(String _package, String name) {
        return (Reference)this.mUIElementDefinitionRefs.get((_package + "." + name).toLowerCase());
    }

    Vector getUIElementDefinitions() {
        return new Vector(this.mUIElementDefinitionRefs.values());
    }

    void removeUIElementDefinition(Reference reference) {
        this.mUIElementDefinitionRefs.remove((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase());
    }

    void removeUIElementDefinition(String aggregationKey) {
        this.mUIElementDefinitionRefs.remove(aggregationKey);
    }

    void removeUIElementDefinition(String _package, String name) {
        this.mUIElementDefinitionRefs.remove((_package + "." + name).toLowerCase());
    }

    void removeAllUIElementDefinitions() {
        this.mUIElementDefinitionRefs.clear();
    }

    void addViewElementDefinition(Reference reference) {
        this.mViewElementDefinitionRefs.put((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase(), reference);
    }

    int getViewElementDefinitionCount() {
        return this.mViewElementDefinitionRefs.size();
    }

    Reference getViewElementDefinition(String _package, String name) {
        return (Reference)this.mViewElementDefinitionRefs.get((_package + "." + name).toLowerCase());
    }

    Vector getViewElementDefinitions() {
        return new Vector(this.mViewElementDefinitionRefs.values());
    }

    void removeViewElementDefinition(Reference reference) {
        this.mViewElementDefinitionRefs.remove((reference.getMDOPackage() + "." + reference.getMDOName()).toLowerCase());
    }

    void removeViewElementDefinition(String aggregationKey) {
        this.mViewElementDefinitionRefs.remove(aggregationKey);
    }

    void removeViewElementDefinition(String _package, String name) {
        this.mViewElementDefinitionRefs.remove((_package + "." + name).toLowerCase());
    }

    void removeAllViewElementDefinitions() {
        this.mViewElementDefinitionRefs.clear();
    }

    void moveMarkerInterface(int fromPosition, int toPosition) {
        this.mMarkerInterfaces.add(toPosition, this.mMarkerInterfaces.remove(fromPosition));
    }

    void moveTaggedValue(int fromPosition, int toPosition) {
        this.mTaggedValues.add(toPosition, this.mTaggedValues.remove(fromPosition));
    }

    void moveUsedLibrary(int fromPosition, int toPosition) {
        this.mUsedLibraryRefs.add(toPosition, this.mUsedLibraryRefs.remove(fromPosition));
    }

    void addUsedLibrary(Reference reference) {
        this.mUsedLibraryRefs.add(reference);
    }

    void addUsedLibrary(Reference reference, int position) {
        this.mUsedLibraryRefs.add(position, reference);
    }

    int getUsedLibraryCount() {
        return this.mUsedLibraryRefs.size();
    }

    Reference getUsedLibrary(Reference reference) {
        int i = 0;
        while (i < this.mUsedLibraryRefs.size()) {
            Reference lReference = (Reference)this.mUsedLibraryRefs.get(i);
            if (lReference.equals(reference)) {
                return lReference;
            }
            ++i;
        }
        return null;
    }

    Vector getUsedLibraries() {
        return this.mUsedLibraryRefs;
    }

    void removeUsedLibrary(Reference reference) {
        Reference lReference = this.getUsedLibrary(reference);
        if (lReference != null) {
            this.mUsedLibraryRefs.remove(lReference);
        }
    }

    void removeAllUsedLibraries() {
        this.mUsedLibraryRefs.clear();
    }

    void replaceUsedLibrary(Reference oldReference, Reference newReference) {
        int lPos = this.mUsedLibraryRefs.indexOf(oldReference);
        this.mUsedLibraryRefs.remove(lPos);
        this.mUsedLibraryRefs.add(lPos, newReference);
    }

    void reorderMarkerInterfaces(Vector orderedStates) {
        this.mMarkerInterfaces = orderedStates;
    }

    void reorderTaggedValues(Vector orderedStates) {
        this.mTaggedValues = orderedStates;
    }

    void reorderUsedLibraries(Vector orderedReferences) {
        this.mUsedLibraryRefs = orderedReferences;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("mmRelease")) {
            this.mMetamodelRelease = (String)value;
        } else if (propertyName.equals("mmVersion")) {
            this.mMetamodelVersion = (String)value;
        } else if (propertyName.equals("mmTimestamp")) {
            this.mMetamodelTimestamp = (String)value;
        } else if (propertyName.equals("name")) {
            this.setName((String)value);
        } else if (propertyName.equals("package")) {
            this.setPackage((String)value);
        } else if (propertyName.equals("masterLanguage")) {
            this.setMasterLanguage((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("LayoutDefinitions")) {
            this.addLayoutDefinition((Reference)data);
        } else if (roleName.equals("MarkerInterfaces")) {
            this.addMarkerInterface((MarkerInterfaceState)((Object)data));
        } else if (roleName.equals("TaggedValues")) {
            this.addTaggedValue((TaggedValueState)((Object)data));
        } else if (roleName.equals("UIElementContainerDefinitions")) {
            this.addUIElementContainerDefinition((Reference)data);
        } else if (roleName.equals("UIElementDefinitions")) {
            this.addUIElementDefinition((Reference)data);
        } else if (roleName.equals("ViewElementDefinitions")) {
            this.addViewElementDefinition((Reference)data);
        } else if (roleName.equals("UsedLibraries")) {
            this.addUsedLibrary((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

