/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.ToolBarDesign;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Visibility;
import com.sap.ide.metamodel.webdynpro.implementation.ViewElementState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

class ToolBarState
extends ViewElementState {
    private String mDesign = "standard";
    private boolean mHasDesign = false;
    private boolean mEnabled = true;
    private boolean mHasEnabled = false;
    private String mVisible = "visible";
    private boolean mHasVisible = false;
    private Vector mToolBarItems = new Vector();

    ToolBarState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ToolBarState lState = (ToolBarState)object;
        if (!String.valueOf(this.mDesign).equals(String.valueOf(lState.mDesign))) {
            return false;
        }
        if (!String.valueOf(this.mEnabled).equals(String.valueOf(lState.mEnabled))) {
            return false;
        }
        return String.valueOf(this.mVisible).equals(String.valueOf(lState.mVisible));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ToolBarState lState = (ToolBarState)object;
        if (!String.valueOf(this.mDesign).equals(String.valueOf(lState.mDesign))) {
            compareContext.addPropertyDelta(sourceObject, "design", (Object)ToolBarDesign.valueOf(lState.mDesign));
        }
        if (!String.valueOf(this.mEnabled).equals(String.valueOf(lState.mEnabled))) {
            compareContext.addPropertyDelta(sourceObject, "enabled", (Object)new Boolean(lState.mEnabled));
        }
        if (!String.valueOf(this.mVisible).equals(String.valueOf(lState.mVisible))) {
            compareContext.addPropertyDelta(sourceObject, "visible", (Object)Visibility.valueOf(lState.mVisible));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ToolBarState lState = (ToolBarState)((Object)super.clone());
        lState.mToolBarItems = new Vector();
        int i = 0;
        while (i < this.mToolBarItems.size()) {
            lState.mToolBarItems.add(((ViewElementState)((Object)this.mToolBarItems.get(i))).clone());
            ++i;
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = ((AbstractList)this.mToolBarItems).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = ((AbstractList)this.mToolBarItems).iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = ((AbstractList)this.mToolBarItems).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return super._hasReferencesToRefactor(oldReference);
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
    }

    void setDesign(String value) {
        this.mDesign = value;
        this.mHasDesign = true;
    }

    String getDesign() {
        return this.mDesign;
    }

    boolean hasDesign() {
        return this.mHasDesign;
    }

    void setEnabled(boolean value) {
        this.mEnabled = value;
        this.mHasEnabled = true;
    }

    boolean getEnabled() {
        return this.mEnabled;
    }

    boolean hasEnabled() {
        return this.mHasEnabled;
    }

    void setVisible(String value) {
        this.mVisible = value;
        this.mHasVisible = true;
    }

    String getVisible() {
        return this.mVisible;
    }

    boolean hasVisible() {
        return this.mHasVisible;
    }

    void addToolBarItem(ViewElementState state) {
        this.mToolBarItems.add(state);
    }

    void addToolBarItem(ViewElementState state, int position) {
        this.mToolBarItems.add(position, state);
    }

    int getToolBarItemCount() {
        return this.mToolBarItems.size();
    }

    ViewElementState getToolBarItem(String name) {
        int i = 0;
        while (i < this.mToolBarItems.size()) {
            ViewElementState lState = (ViewElementState)((Object)this.mToolBarItems.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getToolBarItems() {
        return this.mToolBarItems;
    }

    void removeToolBarItem(ViewElementState state) {
        this.mToolBarItems.remove((Object)state);
    }

    void removeAllToolBarItems() {
        this.mToolBarItems.clear();
    }

    void moveToolBarItem(int fromPosition, int toPosition) {
        this.mToolBarItems.add(toPosition, this.mToolBarItems.remove(fromPosition));
    }

    void reorderToolBarItems(Vector orderedStates) {
        this.mToolBarItems = orderedStates;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("design")) {
            if (ToolBarDesign.valueOf((String)value) != null) {
                this.setDesign((String)value);
            }
        } else if (propertyName.equals("enabled")) {
            this.setEnabled(new Boolean((String)value));
        } else if (propertyName.equals("visible")) {
            if (Visibility.valueOf((String)value) != null) {
                this.setVisible((String)value);
            }
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ToolBarItems")) {
            this.addToolBarItem((ViewElementState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

