/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.TabState;
import com.sap.ide.metamodel.webdynpro.implementation.UIElementState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

class TabStripState
extends UIElementState {
    private String mHeight = null;
    private boolean mHasHeight = false;
    private String mSelectedTab = null;
    private boolean mHasSelectedTab = false;
    private String mWidth = null;
    private boolean mHasWidth = false;
    private Vector mTabs = new Vector();

    TabStripState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        TabStripState lState = (TabStripState)object;
        if (!String.valueOf(this.mHeight).equals(String.valueOf(lState.mHeight))) {
            return false;
        }
        if (!String.valueOf(this.mSelectedTab).equals(String.valueOf(lState.mSelectedTab))) {
            return false;
        }
        return String.valueOf(this.mWidth).equals(String.valueOf(lState.mWidth));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        TabStripState lState = (TabStripState)object;
        if (!String.valueOf(this.mHeight).equals(String.valueOf(lState.mHeight))) {
            compareContext.addPropertyDelta(sourceObject, "height", (Object)lState.mHeight);
        }
        if (!String.valueOf(this.mSelectedTab).equals(String.valueOf(lState.mSelectedTab))) {
            compareContext.addPropertyDelta(sourceObject, "selectedTab", (Object)lState.mSelectedTab);
        }
        if (!String.valueOf(this.mWidth).equals(String.valueOf(lState.mWidth))) {
            compareContext.addPropertyDelta(sourceObject, "width", (Object)lState.mWidth);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        TabStripState lState = (TabStripState)((Object)super.clone());
        lState.mTabs = new Vector();
        int i = 0;
        while (i < this.mTabs.size()) {
            lState.mTabs.add(((TabState)((Object)this.mTabs.get(i))).clone());
            ++i;
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = ((AbstractList)this.mTabs).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = ((AbstractList)this.mTabs).iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = ((AbstractList)this.mTabs).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return super._hasReferencesToRefactor(oldReference);
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
    }

    void setHeight(String value) {
        if (value == null) {
            this.unsetHeight();
            return;
        }
        this.mHeight = value;
        this.mHasHeight = true;
    }

    String getHeight() {
        return this.mHeight;
    }

    boolean hasHeight() {
        return this.mHasHeight;
    }

    void unsetHeight() {
        this.mHeight = null;
        this.mHasHeight = false;
    }

    void setSelectedTab(String value) {
        if (value == null) {
            this.unsetSelectedTab();
            return;
        }
        this.mSelectedTab = value;
        this.mHasSelectedTab = true;
    }

    String getSelectedTab() {
        return this.mSelectedTab;
    }

    boolean hasSelectedTab() {
        return this.mHasSelectedTab;
    }

    void unsetSelectedTab() {
        this.mSelectedTab = null;
        this.mHasSelectedTab = false;
    }

    void setWidth(String value) {
        if (value == null) {
            this.unsetWidth();
            return;
        }
        this.mWidth = value;
        this.mHasWidth = true;
    }

    String getWidth() {
        return this.mWidth;
    }

    boolean hasWidth() {
        return this.mHasWidth;
    }

    void unsetWidth() {
        this.mWidth = null;
        this.mHasWidth = false;
    }

    void addTab(TabState state) {
        this.mTabs.add(state);
    }

    void addTab(TabState state, int position) {
        this.mTabs.add(position, state);
    }

    int getTabCount() {
        return this.mTabs.size();
    }

    TabState getTab(String name) {
        int i = 0;
        while (i < this.mTabs.size()) {
            TabState lState = (TabState)((Object)this.mTabs.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getTabs() {
        return this.mTabs;
    }

    void removeTab(TabState state) {
        this.mTabs.remove((Object)state);
    }

    void removeAllTabs() {
        this.mTabs.clear();
    }

    void moveTab(int fromPosition, int toPosition) {
        this.mTabs.add(toPosition, this.mTabs.remove(fromPosition));
    }

    void reorderTabs(Vector orderedStates) {
        this.mTabs = orderedStates;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("height")) {
            this.setHeight((String)value);
        } else if (propertyName.equals("selectedTab")) {
            this.setSelectedTab((String)value);
        } else if (propertyName.equals("width")) {
            this.setWidth((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Tabs")) {
            this.addTab((TabState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

