/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.enum.VisibilityEnum;
import com.sap.ide.metamodel.webdynpro.implementation.NativeTypeState;
import java.util.ArrayList;

abstract class PropertyState
extends CommonDevelopmentObjectState {
    private boolean mReadonly = false;
    private boolean mHasReadonly = false;
    private String mVisibility = "public";
    private boolean mHasVisibility = false;
    private NativeTypeState mNativeType = null;
    private Reference mTypeRef = null;

    PropertyState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        PropertyState lState = (PropertyState)object;
        if (!String.valueOf(this.mReadonly).equals(String.valueOf(lState.mReadonly))) {
            return false;
        }
        return String.valueOf(this.mVisibility).equals(String.valueOf(lState.mVisibility));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        PropertyState lState = (PropertyState)object;
        if (!String.valueOf(this.mReadonly).equals(String.valueOf(lState.mReadonly))) {
            compareContext.addPropertyDelta(sourceObject, "readonly", (Object)new Boolean(lState.mReadonly));
        }
        if (!String.valueOf(this.mVisibility).equals(String.valueOf(lState.mVisibility))) {
            compareContext.addPropertyDelta(sourceObject, "visibility", (Object)VisibilityEnum.valueOf(lState.mVisibility));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PropertyState lState = (PropertyState)((Object)super.clone());
        if (this.mNativeType != null) {
            lState.mNativeType = (NativeTypeState)((Object)this.mNativeType.clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mNativeType != null) {
            this.mNativeType.removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        if (this.mNativeType != null) {
            if (clipboardService.isExcluded((Reference)this.mNativeType.getProxyReference())) {
                this.mNativeType = null;
            } else {
                this.mNativeType.refactor(clipboardService);
            }
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mNativeType != null) {
            this.mNativeType.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mTypeRef != null) {
            if (clipboardService.isExcluded(this.mTypeRef)) {
                this.mTypeRef = null;
            } else if (innerObjectKeys.contains(this.mTypeRef.toReferenceString())) {
                this.mTypeRef = clipboardService.refactor(this.mTypeRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mTypeRef != null && this.mTypeRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mTypeRef != null) {
            this.mTypeRef = refactoringService.refactor(this.mTypeRef);
        }
    }

    void setReadonly(boolean value) {
        this.mReadonly = value;
        this.mHasReadonly = true;
    }

    boolean getReadonly() {
        return this.mReadonly;
    }

    boolean hasReadonly() {
        return this.mHasReadonly;
    }

    void setVisibility(String value) {
        this.mVisibility = value;
        this.mHasVisibility = true;
    }

    String getVisibility() {
        return this.mVisibility;
    }

    boolean hasVisibility() {
        return this.mHasVisibility;
    }

    void setNativeType(NativeTypeState state) {
        this.mNativeType = state;
    }

    NativeTypeState getNativeType() {
        return this.mNativeType;
    }

    Reference getType() {
        return this.mTypeRef;
    }

    void setType(Reference reference) {
        this.mTypeRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else if (propertyName.equals("readonly")) {
            this.setReadonly(new Boolean((String)value));
        } else if (propertyName.equals("visibility")) {
            if (VisibilityEnum.valueOf((String)value) != null) {
                this.setVisibility((String)value);
            }
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("NativeType")) {
            this.setNativeType((NativeTypeState)((Object)data));
        } else if (roleName.equals("Type")) {
            this.setType((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

