/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.AbstractValueState;
import com.sap.ide.metamodel.webdynpro.implementation.ViewElementState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

class PointState
extends ViewElementState {
    private String mCustomizingID = null;
    private boolean mHasCustomizingID = false;
    private Vector mValues = new Vector();

    PointState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        PointState lState = (PointState)object;
        return String.valueOf(this.mCustomizingID).equals(String.valueOf(lState.mCustomizingID));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        PointState lState = (PointState)object;
        if (!String.valueOf(this.mCustomizingID).equals(String.valueOf(lState.mCustomizingID))) {
            compareContext.addPropertyDelta(sourceObject, "customizingID", (Object)lState.mCustomizingID);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PointState lState = (PointState)((Object)super.clone());
        lState.mValues = new Vector();
        int i = 0;
        while (i < this.mValues.size()) {
            lState.mValues.add(((AbstractValueState)((Object)this.mValues.get(i))).clone());
            ++i;
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = ((AbstractList)this.mValues).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = ((AbstractList)this.mValues).iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = ((AbstractList)this.mValues).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return super._hasReferencesToRefactor(oldReference);
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
    }

    void setCustomizingID(String value) {
        if (value == null) {
            this.unsetCustomizingID();
            return;
        }
        this.mCustomizingID = value;
        this.mHasCustomizingID = true;
    }

    String getCustomizingID() {
        return this.mCustomizingID;
    }

    boolean hasCustomizingID() {
        return this.mHasCustomizingID;
    }

    void unsetCustomizingID() {
        this.mCustomizingID = null;
        this.mHasCustomizingID = false;
    }

    void addValue(AbstractValueState state) {
        this.mValues.add(state);
    }

    void addValue(AbstractValueState state, int position) {
        this.mValues.add(position, state);
    }

    int getValueCount() {
        return this.mValues.size();
    }

    AbstractValueState getValue(String name) {
        int i = 0;
        while (i < this.mValues.size()) {
            AbstractValueState lState = (AbstractValueState)((Object)this.mValues.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getValues() {
        return this.mValues;
    }

    void removeValue(AbstractValueState state) {
        this.mValues.remove((Object)state);
    }

    void removeAllValues() {
        this.mValues.clear();
    }

    void moveValue(int fromPosition, int toPosition) {
        this.mValues.add(toPosition, this.mValues.remove(fromPosition));
    }

    void reorderValues(Vector orderedStates) {
        this.mValues = orderedStates;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("customizingID")) {
            this.setCustomizingID((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Values")) {
            this.addValue((AbstractValueState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

