/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.ViewsetHierarchyNodeState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

abstract class PlaceholderState
extends CommonDevelopmentObjectState {
    private HashMap mEmbeddedNodes = new HashMap();
    private Reference mDefaultNodeRef = null;
    private Reference mViewContainerRef = null;

    PlaceholderState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        PlaceholderState lState = (PlaceholderState)object;
        return true;
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        PlaceholderState lState = (PlaceholderState)object;
    }

    public Object clone() throws CloneNotSupportedException {
        PlaceholderState lState = (PlaceholderState)((Object)super.clone());
        lState.mEmbeddedNodes = new HashMap();
        Iterator it = this.mEmbeddedNodes.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mEmbeddedNodes.put(lKey, ((ViewsetHierarchyNodeState)((Object)this.mEmbeddedNodes.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mDefaultNodeRef != null && !innerObjectKeys.contains(this.mDefaultNodeRef.toString())) {
            this.mDefaultNodeRef = null;
        }
        Iterator it = this.mEmbeddedNodes.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mEmbeddedNodes.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = this.mEmbeddedNodes.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mDefaultNodeRef != null) {
            if (clipboardService.isExcluded(this.mDefaultNodeRef)) {
                this.mDefaultNodeRef = null;
            } else if (innerObjectKeys.contains(this.mDefaultNodeRef.toReferenceString())) {
                this.mDefaultNodeRef = clipboardService.refactor(this.mDefaultNodeRef);
            }
        }
        if (this.mViewContainerRef != null) {
            if (clipboardService.isExcluded(this.mViewContainerRef)) {
                this.mViewContainerRef = null;
            } else if (innerObjectKeys.contains(this.mViewContainerRef.toReferenceString())) {
                this.mViewContainerRef = clipboardService.refactor(this.mViewContainerRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        if (this.mDefaultNodeRef != null && this.mDefaultNodeRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        return this.mViewContainerRef != null && this.mViewContainerRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mDefaultNodeRef != null) {
            this.mDefaultNodeRef = refactoringService.refactor(this.mDefaultNodeRef);
        }
        if (this.mViewContainerRef != null) {
            this.mViewContainerRef = refactoringService.refactor(this.mViewContainerRef);
        }
    }

    void addEmbeddedNode(ViewsetHierarchyNodeState state) {
        this.mEmbeddedNodes.put(state.getName().toLowerCase(), state);
    }

    int getEmbeddedNodeCount() {
        return this.mEmbeddedNodes.size();
    }

    ViewsetHierarchyNodeState getEmbeddedNode(String name) {
        return (ViewsetHierarchyNodeState)((Object)this.mEmbeddedNodes.get(name.toLowerCase()));
    }

    Vector getEmbeddedNodes() {
        return new Vector(this.mEmbeddedNodes.values());
    }

    void removeEmbeddedNode(String aggregationKey) {
        this.mEmbeddedNodes.remove(aggregationKey.toLowerCase());
    }

    void removeEmbeddedNode(ViewsetHierarchyNodeState state) {
        this.mEmbeddedNodes.remove(state.getName().toLowerCase());
    }

    void removeAllEmbeddedNodes() {
        this.mEmbeddedNodes.clear();
    }

    Reference getDefaultNode() {
        return this.mDefaultNodeRef;
    }

    void setDefaultNode(Reference reference) {
        this.mDefaultNodeRef = reference;
    }

    Reference getViewContainer() {
        return this.mViewContainerRef;
    }

    void setViewContainer(Reference reference) {
        this.mViewContainerRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("EmbeddedNodes")) {
            this.addEmbeddedNode((ViewsetHierarchyNodeState)((Object)data));
        } else if (roleName.equals("DefaultNode")) {
            this.setDefaultNode((Reference)data);
        } else if (roleName.equals("ViewContainer")) {
            this.setViewContainer((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

