/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.EventBindingState;
import java.util.ArrayList;

class NavigationTargetReferenceState
extends EventBindingState {
    private Reference mTargetRef = null;
    private Reference mTargetViewUsageRef = null;

    NavigationTargetReferenceState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        return super.isEqualTo(object, isRootObject);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
    }

    public Object clone() throws CloneNotSupportedException {
        NavigationTargetReferenceState lState = (NavigationTargetReferenceState)((Object)super.clone());
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mTargetRef != null) {
            if (clipboardService.isExcluded(this.mTargetRef)) {
                this.mTargetRef = null;
            } else if (innerObjectKeys.contains(this.mTargetRef.toReferenceString())) {
                this.mTargetRef = clipboardService.refactor(this.mTargetRef);
            }
        }
        if (this.mTargetViewUsageRef != null) {
            if (clipboardService.isExcluded(this.mTargetViewUsageRef)) {
                this.mTargetViewUsageRef = null;
            } else if (innerObjectKeys.contains(this.mTargetViewUsageRef.toReferenceString())) {
                this.mTargetViewUsageRef = clipboardService.refactor(this.mTargetViewUsageRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        if (this.mTargetRef != null && this.mTargetRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        return this.mTargetViewUsageRef != null && this.mTargetViewUsageRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mTargetRef != null) {
            this.mTargetRef = refactoringService.refactor(this.mTargetRef);
        }
        if (this.mTargetViewUsageRef != null) {
            this.mTargetViewUsageRef = refactoringService.refactor(this.mTargetViewUsageRef);
        }
    }

    Reference getTarget() {
        return this.mTargetRef;
    }

    void setTarget(Reference reference) {
        this.mTargetRef = reference;
    }

    Reference getTargetViewUsage() {
        return this.mTargetViewUsageRef;
    }

    void setTargetViewUsage(Reference reference) {
        this.mTargetViewUsageRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        super.setProperty(propertyName, value);
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Target")) {
            this.setTarget((Reference)data);
        } else if (roleName.equals("TargetViewUsage")) {
            this.setTargetViewUsage((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

