/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.NavigationTargetReferenceState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class NavigationLinkState
extends CommonDevelopmentObjectState {
    private HashMap mTargetReferences = new HashMap();
    private Reference mSourceRef = null;
    private Reference mSourceViewUsageRef = null;

    NavigationLinkState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        NavigationLinkState lState = (NavigationLinkState)object;
        return true;
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        NavigationLinkState lState = (NavigationLinkState)object;
    }

    public Object clone() throws CloneNotSupportedException {
        NavigationLinkState lState = (NavigationLinkState)((Object)super.clone());
        lState.mTargetReferences = new HashMap();
        Iterator it = this.mTargetReferences.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mTargetReferences.put(lKey, ((NavigationTargetReferenceState)((Object)this.mTargetReferences.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = this.mTargetReferences.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mTargetReferences.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = this.mTargetReferences.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mSourceRef != null) {
            if (clipboardService.isExcluded(this.mSourceRef)) {
                this.mSourceRef = null;
            } else if (innerObjectKeys.contains(this.mSourceRef.toReferenceString())) {
                this.mSourceRef = clipboardService.refactor(this.mSourceRef);
            }
        }
        if (this.mSourceViewUsageRef != null) {
            if (clipboardService.isExcluded(this.mSourceViewUsageRef)) {
                this.mSourceViewUsageRef = null;
            } else if (innerObjectKeys.contains(this.mSourceViewUsageRef.toReferenceString())) {
                this.mSourceViewUsageRef = clipboardService.refactor(this.mSourceViewUsageRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        if (this.mSourceRef != null && this.mSourceRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        return this.mSourceViewUsageRef != null && this.mSourceViewUsageRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mSourceRef != null) {
            this.mSourceRef = refactoringService.refactor(this.mSourceRef);
        }
        if (this.mSourceViewUsageRef != null) {
            this.mSourceViewUsageRef = refactoringService.refactor(this.mSourceViewUsageRef);
        }
    }

    void addTargetReference(NavigationTargetReferenceState state) {
        this.mTargetReferences.put(state.getName().toLowerCase(), state);
    }

    int getTargetReferenceCount() {
        return this.mTargetReferences.size();
    }

    NavigationTargetReferenceState getTargetReference(String name) {
        return (NavigationTargetReferenceState)((Object)this.mTargetReferences.get(name.toLowerCase()));
    }

    Vector getTargetReferences() {
        return new Vector(this.mTargetReferences.values());
    }

    void removeTargetReference(String aggregationKey) {
        this.mTargetReferences.remove(aggregationKey.toLowerCase());
    }

    void removeTargetReference(NavigationTargetReferenceState state) {
        this.mTargetReferences.remove(state.getName().toLowerCase());
    }

    void removeAllTargetReferences() {
        this.mTargetReferences.clear();
    }

    Reference getSource() {
        return this.mSourceRef;
    }

    void setSource(Reference reference) {
        this.mSourceRef = reference;
    }

    Reference getSourceViewUsage() {
        return this.mSourceViewUsageRef;
    }

    void setSourceViewUsage(Reference reference) {
        this.mSourceViewUsageRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("TargetReferences")) {
            this.addTargetReference((NavigationTargetReferenceState)((Object)data));
        } else if (roleName.equals("Source")) {
            this.setSource((Reference)data);
        } else if (roleName.equals("SourceViewUsage")) {
            this.setSourceViewUsage((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

