/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.AppClassState;
import com.sap.ide.metamodel.webdynpro.implementation.ModelClassSettingState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class ModelClassState
extends AppClassState
implements MainDevelopmentObjectState {
    private String mMetamodelRelease = null;
    private String mMetamodelVersion = null;
    private String mMetamodelTimestamp = null;
    protected String mPackage = null;
    private String mMasterLanguage = null;
    private Reference mParent;
    private boolean mIsAbstract = false;
    private boolean mHasIsAbstract = false;
    private boolean mIsInterface = false;
    private boolean mHasIsInterface = false;
    private boolean mIsRootObject = false;
    private boolean mHasIsRootObject = false;
    private String mStereotype = null;
    private boolean mHasStereotype = false;
    private HashMap mSettings = new HashMap();
    private Vector mInterfaceRefs = new Vector();
    private Reference mStructureRef = null;

    ModelClassState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ModelClassState lState = (ModelClassState)object;
        if (!isRootObject && !this.mPackage.equals(lState.mPackage)) {
            return false;
        }
        if (!String.valueOf(this.mIsAbstract).equals(String.valueOf(lState.mIsAbstract))) {
            return false;
        }
        if (!String.valueOf(this.mIsInterface).equals(String.valueOf(lState.mIsInterface))) {
            return false;
        }
        if (!String.valueOf(this.mIsRootObject).equals(String.valueOf(lState.mIsRootObject))) {
            return false;
        }
        return String.valueOf(this.mStereotype).equals(String.valueOf(lState.mStereotype));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ModelClassState lState = (ModelClassState)object;
        if (!isRootObject && !this.mPackage.equals(lState.mPackage)) {
            compareContext.addPropertyDelta(sourceObject, "package", (Object)lState.mPackage);
        }
        if (!String.valueOf(this.mIsAbstract).equals(String.valueOf(lState.mIsAbstract))) {
            compareContext.addPropertyDelta(sourceObject, "isAbstract", (Object)new Boolean(lState.mIsAbstract));
        }
        if (!String.valueOf(this.mIsInterface).equals(String.valueOf(lState.mIsInterface))) {
            compareContext.addPropertyDelta(sourceObject, "isInterface", (Object)new Boolean(lState.mIsInterface));
        }
        if (!String.valueOf(this.mIsRootObject).equals(String.valueOf(lState.mIsRootObject))) {
            compareContext.addPropertyDelta(sourceObject, "isRootObject", (Object)new Boolean(lState.mIsRootObject));
        }
        if (!String.valueOf(this.mStereotype).equals(String.valueOf(lState.mStereotype))) {
            compareContext.addPropertyDelta(sourceObject, "stereotype", (Object)lState.mStereotype);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ModelClassState lState = (ModelClassState)((Object)super.clone());
        lState.mSettings = new HashMap();
        Iterator it = this.mSettings.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mSettings.put(lKey, ((ModelClassSettingState)((Object)this.mSettings.get(lKey))).clone());
        }
        lState.mInterfaceRefs = (Vector)this.mInterfaceRefs.clone();
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = this.mSettings.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            this.setPackage(clipboardService.getNewPackage(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mSettings.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = this.mSettings.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mParent != null) {
            this.mParent = clipboardService.refactor(this.mParent);
        }
        Vector<Reference> lVector = new Vector<Reference>();
        Iterator it2 = ((AbstractList)this.mInterfaceRefs).iterator();
        while (it2.hasNext()) {
            Reference lReference = (Reference)it2.next();
            if (clipboardService.isExcluded(lReference)) continue;
            if (innerObjectKeys.contains(lReference.toReferenceString())) {
                lReference = clipboardService.refactor(lReference);
            }
            lVector.add(lReference);
        }
        this.mInterfaceRefs = lVector;
        if (this.mStructureRef != null) {
            if (clipboardService.isExcluded(this.mStructureRef)) {
                this.mStructureRef = null;
            } else if (innerObjectKeys.contains(this.mStructureRef.toReferenceString())) {
                this.mStructureRef = clipboardService.refactor(this.mStructureRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        Iterator it = ((AbstractList)this.mInterfaceRefs).iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        return this.mStructureRef != null && this.mStructureRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mParent != null) {
            this.mParent = refactoringService.refactor(this.mParent);
        }
        Vector<Reference> lList = new Vector<Reference>();
        Iterator it = ((AbstractList)this.mInterfaceRefs).iterator();
        while (it.hasNext()) {
            lList.add(refactoringService.refactor((Reference)it.next()));
        }
        this.mInterfaceRefs = lList;
        if (this.mStructureRef != null) {
            this.mStructureRef = refactoringService.refactor(this.mStructureRef);
        }
    }

    public String getPackage() {
        return this.mPackage;
    }

    public void setPackage(String newPackage) {
        this.mPackage = newPackage;
    }

    public String getMasterLanguage() {
        return this.mMasterLanguage;
    }

    public void setMasterLanguage(String language) {
        this.mMasterLanguage = language;
    }

    public String _getMetamodelRelease() {
        return this.mMetamodelRelease;
    }

    public String _getMetamodelVersion() {
        return this.mMetamodelVersion;
    }

    public String _getMetamodelTimestamp() {
        return this.mMetamodelTimestamp;
    }

    void setIsAbstract(boolean value) {
        this.mIsAbstract = value;
        this.mHasIsAbstract = true;
    }

    boolean getIsAbstract() {
        return this.mIsAbstract;
    }

    boolean hasIsAbstract() {
        return this.mHasIsAbstract;
    }

    void setIsInterface(boolean value) {
        this.mIsInterface = value;
        this.mHasIsInterface = true;
    }

    boolean getIsInterface() {
        return this.mIsInterface;
    }

    boolean hasIsInterface() {
        return this.mHasIsInterface;
    }

    void setIsRootObject(boolean value) {
        this.mIsRootObject = value;
        this.mHasIsRootObject = true;
    }

    boolean getIsRootObject() {
        return this.mIsRootObject;
    }

    boolean hasIsRootObject() {
        return this.mHasIsRootObject;
    }

    void setStereotype(String value) {
        if (value == null) {
            this.unsetStereotype();
            return;
        }
        this.mStereotype = value;
        this.mHasStereotype = true;
    }

    String getStereotype() {
        return this.mStereotype;
    }

    boolean hasStereotype() {
        return this.mHasStereotype;
    }

    void unsetStereotype() {
        this.mStereotype = null;
        this.mHasStereotype = false;
    }

    public Reference getParent() {
        return this.mParent;
    }

    public void setParent(Reference parentReference) {
        this.mParent = parentReference;
    }

    void addSetting(ModelClassSettingState state) {
        this.mSettings.put(state.getName().toLowerCase(), state);
    }

    int getSettingCount() {
        return this.mSettings.size();
    }

    ModelClassSettingState getSetting(String name) {
        return (ModelClassSettingState)((Object)this.mSettings.get(name.toLowerCase()));
    }

    Vector getSettings() {
        return new Vector(this.mSettings.values());
    }

    void removeSetting(String aggregationKey) {
        this.mSettings.remove(aggregationKey.toLowerCase());
    }

    void removeSetting(ModelClassSettingState state) {
        this.mSettings.remove(state.getName().toLowerCase());
    }

    void removeAllSettings() {
        this.mSettings.clear();
    }

    void moveInterface(int fromPosition, int toPosition) {
        this.mInterfaceRefs.add(toPosition, this.mInterfaceRefs.remove(fromPosition));
    }

    Reference getStructure() {
        return this.mStructureRef;
    }

    void setStructure(Reference reference) {
        this.mStructureRef = reference;
    }

    void addInterface(Reference reference) {
        this.mInterfaceRefs.add(reference);
    }

    void addInterface(Reference reference, int position) {
        this.mInterfaceRefs.add(position, reference);
    }

    int getInterfaceCount() {
        return this.mInterfaceRefs.size();
    }

    Reference getInterface(Reference reference) {
        int i = 0;
        while (i < this.mInterfaceRefs.size()) {
            Reference lReference = (Reference)this.mInterfaceRefs.get(i);
            if (lReference.equals(reference)) {
                return lReference;
            }
            ++i;
        }
        return null;
    }

    Vector getInterfaces() {
        return this.mInterfaceRefs;
    }

    void removeInterface(Reference reference) {
        Reference lReference = this.getInterface(reference);
        if (lReference != null) {
            this.mInterfaceRefs.remove(lReference);
        }
    }

    void removeAllInterfaces() {
        this.mInterfaceRefs.clear();
    }

    void replaceInterface(Reference oldReference, Reference newReference) {
        int lPos = this.mInterfaceRefs.indexOf(oldReference);
        this.mInterfaceRefs.remove(lPos);
        this.mInterfaceRefs.add(lPos, newReference);
    }

    void reorderInterfaces(Vector orderedReferences) {
        this.mInterfaceRefs = orderedReferences;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("mmRelease")) {
            this.mMetamodelRelease = (String)value;
        } else if (propertyName.equals("mmVersion")) {
            this.mMetamodelVersion = (String)value;
        } else if (propertyName.equals("mmTimestamp")) {
            this.mMetamodelTimestamp = (String)value;
        } else if (propertyName.equals("isAbstract")) {
            this.setIsAbstract(new Boolean((String)value));
        } else if (propertyName.equals("isInterface")) {
            this.setIsInterface(new Boolean((String)value));
        } else if (propertyName.equals("isRootObject")) {
            this.setIsRootObject(new Boolean((String)value));
        } else if (propertyName.equals("stereotype")) {
            this.setStereotype((String)value);
        } else if (propertyName.equals("package")) {
            this.setPackage((String)value);
        } else if (propertyName.equals("masterLanguage")) {
            this.setMasterLanguage((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Parent")) {
            this.setParent((Reference)data);
        } else if (roleName.equals("Settings")) {
            this.addSetting((ModelClassSettingState)((Object)data));
        } else if (roleName.equals("Interfaces")) {
            this.addInterface((Reference)data);
        } else if (roleName.equals("Structure")) {
            this.setStructure((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

