/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class MarkerInterfaceState
extends CommonDevelopmentObjectState {
    private HashMap mExtendedInterfaceRefs = new HashMap();

    MarkerInterfaceState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        MarkerInterfaceState lState = (MarkerInterfaceState)object;
        return true;
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        MarkerInterfaceState lState = (MarkerInterfaceState)object;
    }

    public Object clone() throws CloneNotSupportedException {
        MarkerInterfaceState lState = (MarkerInterfaceState)((Object)super.clone());
        lState.mExtendedInterfaceRefs = (HashMap)this.mExtendedInterfaceRefs.clone();
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        HashMap<String, Reference> lHashMap = new HashMap<String, Reference>();
        Iterator it = this.mExtendedInterfaceRefs.values().iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (clipboardService.isExcluded(lReference)) continue;
            if (innerObjectKeys.contains(lReference.toReferenceString())) {
                lReference = clipboardService.refactor(lReference);
            }
            lHashMap.put(lReference.toString(), lReference);
        }
        this.mExtendedInterfaceRefs = lHashMap;
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        Iterator it = this.mExtendedInterfaceRefs.values().iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        return false;
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        HashMap<String, Reference> lHashMap = new HashMap<String, Reference>();
        Iterator it = this.mExtendedInterfaceRefs.values().iterator();
        while (it.hasNext()) {
            Reference lReference = refactoringService.refactor((Reference)it.next());
            lHashMap.put(lReference.toString(), lReference);
        }
        this.mExtendedInterfaceRefs = lHashMap;
    }

    void addExtendedInterface(Reference reference) {
        this.mExtendedInterfaceRefs.put(reference.toString(), reference);
    }

    int getExtendedInterfaceCount() {
        return this.mExtendedInterfaceRefs.size();
    }

    Reference getExtendedInterface(Reference reference) {
        return (Reference)this.mExtendedInterfaceRefs.get(reference.toString());
    }

    Vector getExtendedInterfaces() {
        return new Vector(this.mExtendedInterfaceRefs.values());
    }

    void removeExtendedInterface(Reference reference) {
        this.mExtendedInterfaceRefs.remove(reference.toString());
    }

    void removeAllExtendedInterfaces() {
        this.mExtendedInterfaceRefs.clear();
    }

    void replaceExtendedInterface(Reference oldReference, Reference newReference) {
        this.mExtendedInterfaceRefs.remove(oldReference.toString());
        this.mExtendedInterfaceRefs.put(newReference.toString(), newReference);
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ExtendedInterfaces")) {
            this.addExtendedInterface((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

