/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.ApplicationEventState;
import java.util.ArrayList;

abstract class IncomingEventState
extends ApplicationEventState {
    private Reference mEventHandlerRef = null;

    IncomingEventState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        return super.isEqualTo(object, isRootObject);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
    }

    public Object clone() throws CloneNotSupportedException {
        IncomingEventState lState = (IncomingEventState)((Object)super.clone());
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mEventHandlerRef != null) {
            if (clipboardService.isExcluded(this.mEventHandlerRef)) {
                this.mEventHandlerRef = null;
            } else if (innerObjectKeys.contains(this.mEventHandlerRef.toReferenceString())) {
                this.mEventHandlerRef = clipboardService.refactor(this.mEventHandlerRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mEventHandlerRef != null && this.mEventHandlerRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mEventHandlerRef != null) {
            this.mEventHandlerRef = refactoringService.refactor(this.mEventHandlerRef);
        }
    }

    Reference getEventHandler() {
        return this.mEventHandlerRef;
    }

    void setEventHandler(Reference reference) {
        this.mEventHandlerRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        super.setProperty(propertyName, value);
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("EventHandler")) {
            this.setEventHandler((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

