/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.ProcedureState;
import java.util.ArrayList;

abstract class EventHandlerState
extends ProcedureState {
    private Reference mErrorHandlerRef = null;
    private Reference mEventSourceRef = null;
    private Reference mSubscribedEventRef = null;

    EventHandlerState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        return super.isEqualTo(object, isRootObject);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
    }

    public Object clone() throws CloneNotSupportedException {
        EventHandlerState lState = (EventHandlerState)((Object)super.clone());
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mErrorHandlerRef != null) {
            if (clipboardService.isExcluded(this.mErrorHandlerRef)) {
                this.mErrorHandlerRef = null;
            } else if (innerObjectKeys.contains(this.mErrorHandlerRef.toReferenceString())) {
                this.mErrorHandlerRef = clipboardService.refactor(this.mErrorHandlerRef);
            }
        }
        if (this.mEventSourceRef != null) {
            if (clipboardService.isExcluded(this.mEventSourceRef)) {
                this.mEventSourceRef = null;
            } else if (innerObjectKeys.contains(this.mEventSourceRef.toReferenceString())) {
                this.mEventSourceRef = clipboardService.refactor(this.mEventSourceRef);
            }
        }
        if (this.mSubscribedEventRef != null) {
            if (clipboardService.isExcluded(this.mSubscribedEventRef)) {
                this.mSubscribedEventRef = null;
            } else if (innerObjectKeys.contains(this.mSubscribedEventRef.toReferenceString())) {
                this.mSubscribedEventRef = clipboardService.refactor(this.mSubscribedEventRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        if (this.mErrorHandlerRef != null && this.mErrorHandlerRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        if (this.mEventSourceRef != null && this.mEventSourceRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        return this.mSubscribedEventRef != null && this.mSubscribedEventRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mErrorHandlerRef != null) {
            this.mErrorHandlerRef = refactoringService.refactor(this.mErrorHandlerRef);
        }
        if (this.mEventSourceRef != null) {
            this.mEventSourceRef = refactoringService.refactor(this.mEventSourceRef);
        }
        if (this.mSubscribedEventRef != null) {
            this.mSubscribedEventRef = refactoringService.refactor(this.mSubscribedEventRef);
        }
    }

    Reference getErrorHandler() {
        return this.mErrorHandlerRef;
    }

    void setErrorHandler(Reference reference) {
        this.mErrorHandlerRef = reference;
    }

    Reference getEventSource() {
        return this.mEventSourceRef;
    }

    void setEventSource(Reference reference) {
        this.mEventSourceRef = reference;
    }

    Reference getSubscribedEvent() {
        return this.mSubscribedEventRef;
    }

    void setSubscribedEvent(Reference reference) {
        this.mSubscribedEventRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        super.setProperty(propertyName, value);
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ErrorHandler")) {
            this.setErrorHandler((Reference)data);
        } else if (roleName.equals("EventSource")) {
            this.setEventSource((Reference)data);
        } else if (roleName.equals("SubscribedEvent")) {
            this.setSubscribedEvent((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

