/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.ContextElementMappingState;
import com.sap.ide.metamodel.webdynpro.implementation.EventSourceState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

class ControllerUsageState
extends EventSourceState {
    private Vector mContextMappings = new Vector();
    private Reference mComponentUsageRef = null;
    private Reference mUsedControllerRef = null;

    ControllerUsageState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        return super.isEqualTo(object, isRootObject);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
    }

    public Object clone() throws CloneNotSupportedException {
        ControllerUsageState lState = (ControllerUsageState)((Object)super.clone());
        lState.mContextMappings = new Vector();
        int i = 0;
        while (i < this.mContextMappings.size()) {
            lState.mContextMappings.add(((ContextElementMappingState)((Object)this.mContextMappings.get(i))).clone());
            ++i;
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = ((AbstractList)this.mContextMappings).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = ((AbstractList)this.mContextMappings).iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = ((AbstractList)this.mContextMappings).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mComponentUsageRef != null) {
            if (clipboardService.isExcluded(this.mComponentUsageRef)) {
                this.mComponentUsageRef = null;
            } else if (innerObjectKeys.contains(this.mComponentUsageRef.toReferenceString())) {
                this.mComponentUsageRef = clipboardService.refactor(this.mComponentUsageRef);
            }
        }
        if (this.mUsedControllerRef != null) {
            if (clipboardService.isExcluded(this.mUsedControllerRef)) {
                this.mUsedControllerRef = null;
            } else if (innerObjectKeys.contains(this.mUsedControllerRef.toReferenceString())) {
                this.mUsedControllerRef = clipboardService.refactor(this.mUsedControllerRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        if (this.mComponentUsageRef != null && this.mComponentUsageRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        return this.mUsedControllerRef != null && this.mUsedControllerRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mComponentUsageRef != null) {
            this.mComponentUsageRef = refactoringService.refactor(this.mComponentUsageRef);
        }
        if (this.mUsedControllerRef != null) {
            this.mUsedControllerRef = refactoringService.refactor(this.mUsedControllerRef);
        }
    }

    void addContextMapping(ContextElementMappingState state) {
        this.mContextMappings.add(state);
    }

    void addContextMapping(ContextElementMappingState state, int position) {
        this.mContextMappings.add(position, state);
    }

    int getContextMappingCount() {
        return this.mContextMappings.size();
    }

    ContextElementMappingState getContextMapping(String name) {
        int i = 0;
        while (i < this.mContextMappings.size()) {
            ContextElementMappingState lState = (ContextElementMappingState)((Object)this.mContextMappings.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getContextMappings() {
        return this.mContextMappings;
    }

    void removeContextMapping(ContextElementMappingState state) {
        this.mContextMappings.remove((Object)state);
    }

    void removeAllContextMappings() {
        this.mContextMappings.clear();
    }

    void moveContextMapping(int fromPosition, int toPosition) {
        this.mContextMappings.add(toPosition, this.mContextMappings.remove(fromPosition));
    }

    Reference getComponentUsage() {
        return this.mComponentUsageRef;
    }

    void setComponentUsage(Reference reference) {
        this.mComponentUsageRef = reference;
    }

    Reference getUsedController() {
        return this.mUsedControllerRef;
    }

    void setUsedController(Reference reference) {
        this.mUsedControllerRef = reference;
    }

    void reorderContextMappings(Vector orderedStates) {
        this.mContextMappings = orderedStates;
    }

    public void setProperty(String propertyName, Object value) {
        super.setProperty(propertyName, value);
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ContextMappings")) {
            this.addContextMapping((ContextElementMappingState)((Object)data));
        } else if (roleName.equals("ComponentUsage")) {
            this.setComponentUsage((Reference)data);
        } else if (roleName.equals("UsedController")) {
            this.setUsedController((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

