/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.EventHandlerState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

class ControllerEventHandlerState
extends EventHandlerState {
    private Vector mPreconditionRefs = new Vector();

    ControllerEventHandlerState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        return super.isEqualTo(object, isRootObject);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
    }

    public Object clone() throws CloneNotSupportedException {
        ControllerEventHandlerState lState = (ControllerEventHandlerState)((Object)super.clone());
        lState.mPreconditionRefs = (Vector)this.mPreconditionRefs.clone();
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Vector<Reference> lVector = new Vector<Reference>();
        Iterator it = ((AbstractList)this.mPreconditionRefs).iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (clipboardService.isExcluded(lReference)) continue;
            if (innerObjectKeys.contains(lReference.toReferenceString())) {
                lReference = clipboardService.refactor(lReference);
            }
            lVector.add(lReference);
        }
        this.mPreconditionRefs = lVector;
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        Iterator it = ((AbstractList)this.mPreconditionRefs).iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        return false;
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        Vector<Reference> lList = new Vector<Reference>();
        Iterator it = ((AbstractList)this.mPreconditionRefs).iterator();
        while (it.hasNext()) {
            lList.add(refactoringService.refactor((Reference)it.next()));
        }
        this.mPreconditionRefs = lList;
    }

    void movePrecondition(int fromPosition, int toPosition) {
        this.mPreconditionRefs.add(toPosition, this.mPreconditionRefs.remove(fromPosition));
    }

    void addPrecondition(Reference reference) {
        this.mPreconditionRefs.add(reference);
    }

    void addPrecondition(Reference reference, int position) {
        this.mPreconditionRefs.add(position, reference);
    }

    int getPreconditionCount() {
        return this.mPreconditionRefs.size();
    }

    Reference getPrecondition(Reference reference) {
        int i = 0;
        while (i < this.mPreconditionRefs.size()) {
            Reference lReference = (Reference)this.mPreconditionRefs.get(i);
            if (lReference.equals(reference)) {
                return lReference;
            }
            ++i;
        }
        return null;
    }

    Vector getPreconditions() {
        return this.mPreconditionRefs;
    }

    void removePrecondition(Reference reference) {
        Reference lReference = this.getPrecondition(reference);
        if (lReference != null) {
            this.mPreconditionRefs.remove(lReference);
        }
    }

    void removeAllPreconditions() {
        this.mPreconditionRefs.clear();
    }

    void replacePrecondition(Reference oldReference, Reference newReference) {
        int lPos = this.mPreconditionRefs.indexOf(oldReference);
        this.mPreconditionRefs.remove(lPos);
        this.mPreconditionRefs.add(lPos, newReference);
    }

    void reorderPreconditions(Vector orderedReferences) {
        this.mPreconditionRefs = orderedReferences;
    }

    public void setProperty(String propertyName, Object value) {
        super.setProperty(propertyName, value);
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Preconditions")) {
            this.addPrecondition((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

