/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.ContextNodeState;
import java.util.ArrayList;

class ContextModelNodeState
extends ContextNodeState {
    private Reference mModelClassRef = null;
    private Reference mSupplyingRelationRoleRef = null;

    ContextModelNodeState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        return super.isEqualTo(object, isRootObject);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
    }

    public Object clone() throws CloneNotSupportedException {
        ContextModelNodeState lState = (ContextModelNodeState)((Object)super.clone());
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mModelClassRef != null) {
            if (clipboardService.isExcluded(this.mModelClassRef)) {
                this.mModelClassRef = null;
            } else if (innerObjectKeys.contains(this.mModelClassRef.toReferenceString())) {
                this.mModelClassRef = clipboardService.refactor(this.mModelClassRef);
            }
        }
        if (this.mSupplyingRelationRoleRef != null) {
            if (clipboardService.isExcluded(this.mSupplyingRelationRoleRef)) {
                this.mSupplyingRelationRoleRef = null;
            } else if (innerObjectKeys.contains(this.mSupplyingRelationRoleRef.toReferenceString())) {
                this.mSupplyingRelationRoleRef = clipboardService.refactor(this.mSupplyingRelationRoleRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        if (this.mModelClassRef != null && this.mModelClassRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        return this.mSupplyingRelationRoleRef != null && this.mSupplyingRelationRoleRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mModelClassRef != null) {
            this.mModelClassRef = refactoringService.refactor(this.mModelClassRef);
        }
        if (this.mSupplyingRelationRoleRef != null) {
            this.mSupplyingRelationRoleRef = refactoringService.refactor(this.mSupplyingRelationRoleRef);
        }
    }

    Reference getModelClass() {
        return this.mModelClassRef;
    }

    void setModelClass(Reference reference) {
        this.mModelClassRef = reference;
    }

    Reference getSupplyingRelationRole() {
        return this.mSupplyingRelationRoleRef;
    }

    void setSupplyingRelationRole(Reference reference) {
        this.mSupplyingRelationRoleRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        super.setProperty(propertyName, value);
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ModelClass")) {
            this.setModelClass((Reference)data);
        } else if (roleName.equals("SupplyingRelationRole")) {
            this.setSupplyingRelationRole((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

