/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.ContextAttributeState;
import java.util.ArrayList;

class ContextModelAttributeState
extends ContextAttributeState {
    private String mPath = null;
    private boolean mHasPath = false;
    private Reference mReferencedPropertyRef = null;

    ContextModelAttributeState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ContextModelAttributeState lState = (ContextModelAttributeState)object;
        return String.valueOf(this.mPath).equals(String.valueOf(lState.mPath));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ContextModelAttributeState lState = (ContextModelAttributeState)object;
        if (!String.valueOf(this.mPath).equals(String.valueOf(lState.mPath))) {
            compareContext.addPropertyDelta(sourceObject, "path", (Object)lState.mPath);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ContextModelAttributeState lState = (ContextModelAttributeState)((Object)super.clone());
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mReferencedPropertyRef != null) {
            if (clipboardService.isExcluded(this.mReferencedPropertyRef)) {
                this.mReferencedPropertyRef = null;
            } else if (innerObjectKeys.contains(this.mReferencedPropertyRef.toReferenceString())) {
                this.mReferencedPropertyRef = clipboardService.refactor(this.mReferencedPropertyRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mReferencedPropertyRef != null && this.mReferencedPropertyRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mReferencedPropertyRef != null) {
            this.mReferencedPropertyRef = refactoringService.refactor(this.mReferencedPropertyRef);
        }
    }

    void setPath(String value) {
        if (value == null) {
            this.unsetPath();
            return;
        }
        this.mPath = value;
        this.mHasPath = true;
    }

    String getPath() {
        return this.mPath;
    }

    boolean hasPath() {
        return this.mHasPath;
    }

    void unsetPath() {
        this.mPath = null;
        this.mHasPath = false;
    }

    Reference getReferencedProperty() {
        return this.mReferencedPropertyRef;
    }

    void setReferencedProperty(Reference reference) {
        this.mReferencedPropertyRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("path")) {
            this.setPath((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ReferencedProperty")) {
            this.setReferencedProperty((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

