/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.ApplicationPropertyState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

class ApplicationState
extends CommonDevelopmentObjectState
implements MainDevelopmentObjectState {
    private String mMetamodelRelease = null;
    private String mMetamodelVersion = null;
    private String mMetamodelTimestamp = null;
    protected String mPackage = null;
    private String mMasterLanguage = null;
    private Vector mApplicationProperties = new Vector();
    private Reference mComponentRef = null;
    private Vector mPropertyDefinitionSetRefs = new Vector();
    private Reference mStartupPlugRef = null;

    ApplicationState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ApplicationState lState = (ApplicationState)object;
        return isRootObject || this.mPackage.equals(lState.mPackage);
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ApplicationState lState = (ApplicationState)object;
        if (!isRootObject && !this.mPackage.equals(lState.mPackage)) {
            compareContext.addPropertyDelta(sourceObject, "package", (Object)lState.mPackage);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ApplicationState lState = (ApplicationState)((Object)super.clone());
        lState.mApplicationProperties = new Vector();
        int i = 0;
        while (i < this.mApplicationProperties.size()) {
            lState.mApplicationProperties.add(((ApplicationPropertyState)((Object)this.mApplicationProperties.get(i))).clone());
            ++i;
        }
        lState.mPropertyDefinitionSetRefs = (Vector)this.mPropertyDefinitionSetRefs.clone();
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = ((AbstractList)this.mApplicationProperties).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            this.setPackage(clipboardService.getNewPackage(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = ((AbstractList)this.mApplicationProperties).iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = ((AbstractList)this.mApplicationProperties).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mComponentRef != null) {
            if (clipboardService.isExcluded(this.mComponentRef)) {
                this.mComponentRef = null;
            } else if (innerObjectKeys.contains(this.mComponentRef.toReferenceString())) {
                this.mComponentRef = clipboardService.refactor(this.mComponentRef);
            }
        }
        Vector<Reference> lVector = new Vector<Reference>();
        Iterator it2 = ((AbstractList)this.mPropertyDefinitionSetRefs).iterator();
        while (it2.hasNext()) {
            Reference lReference = (Reference)it2.next();
            if (clipboardService.isExcluded(lReference)) continue;
            if (innerObjectKeys.contains(lReference.toReferenceString())) {
                lReference = clipboardService.refactor(lReference);
            }
            lVector.add(lReference);
        }
        this.mPropertyDefinitionSetRefs = lVector;
        if (this.mStartupPlugRef != null) {
            if (clipboardService.isExcluded(this.mStartupPlugRef)) {
                this.mStartupPlugRef = null;
            } else if (innerObjectKeys.contains(this.mStartupPlugRef.toReferenceString())) {
                this.mStartupPlugRef = clipboardService.refactor(this.mStartupPlugRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        if (this.mComponentRef != null && this.mComponentRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        Iterator it = ((AbstractList)this.mPropertyDefinitionSetRefs).iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        return this.mStartupPlugRef != null && this.mStartupPlugRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mComponentRef != null) {
            this.mComponentRef = refactoringService.refactor(this.mComponentRef);
        }
        Vector<Reference> lList = new Vector<Reference>();
        Iterator it = ((AbstractList)this.mPropertyDefinitionSetRefs).iterator();
        while (it.hasNext()) {
            lList.add(refactoringService.refactor((Reference)it.next()));
        }
        this.mPropertyDefinitionSetRefs = lList;
        if (this.mStartupPlugRef != null) {
            this.mStartupPlugRef = refactoringService.refactor(this.mStartupPlugRef);
        }
    }

    public String getPackage() {
        return this.mPackage;
    }

    public void setPackage(String newPackage) {
        this.mPackage = newPackage;
    }

    public String getMasterLanguage() {
        return this.mMasterLanguage;
    }

    public void setMasterLanguage(String language) {
        this.mMasterLanguage = language;
    }

    public String _getMetamodelRelease() {
        return this.mMetamodelRelease;
    }

    public String _getMetamodelVersion() {
        return this.mMetamodelVersion;
    }

    public String _getMetamodelTimestamp() {
        return this.mMetamodelTimestamp;
    }

    public Reference getParent() {
        return null;
    }

    public void setParent(Reference parentReference) {
    }

    void addApplicationProperty(ApplicationPropertyState state) {
        this.mApplicationProperties.add(state);
    }

    void addApplicationProperty(ApplicationPropertyState state, int position) {
        this.mApplicationProperties.add(position, state);
    }

    int getApplicationPropertyCount() {
        return this.mApplicationProperties.size();
    }

    ApplicationPropertyState getApplicationProperty(String name) {
        int i = 0;
        while (i < this.mApplicationProperties.size()) {
            ApplicationPropertyState lState = (ApplicationPropertyState)((Object)this.mApplicationProperties.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getApplicationProperties() {
        return this.mApplicationProperties;
    }

    void removeApplicationProperty(ApplicationPropertyState state) {
        this.mApplicationProperties.remove((Object)state);
    }

    void removeAllApplicationProperties() {
        this.mApplicationProperties.clear();
    }

    void moveApplicationProperty(int fromPosition, int toPosition) {
        this.mApplicationProperties.add(toPosition, this.mApplicationProperties.remove(fromPosition));
    }

    void movePropertyDefinitionSet(int fromPosition, int toPosition) {
        this.mPropertyDefinitionSetRefs.add(toPosition, this.mPropertyDefinitionSetRefs.remove(fromPosition));
    }

    Reference getComponent() {
        return this.mComponentRef;
    }

    void setComponent(Reference reference) {
        this.mComponentRef = reference;
    }

    Reference getStartupPlug() {
        return this.mStartupPlugRef;
    }

    void setStartupPlug(Reference reference) {
        this.mStartupPlugRef = reference;
    }

    void addPropertyDefinitionSet(Reference reference) {
        this.mPropertyDefinitionSetRefs.add(reference);
    }

    void addPropertyDefinitionSet(Reference reference, int position) {
        this.mPropertyDefinitionSetRefs.add(position, reference);
    }

    int getPropertyDefinitionSetCount() {
        return this.mPropertyDefinitionSetRefs.size();
    }

    Reference getPropertyDefinitionSet(Reference reference) {
        int i = 0;
        while (i < this.mPropertyDefinitionSetRefs.size()) {
            Reference lReference = (Reference)this.mPropertyDefinitionSetRefs.get(i);
            if (lReference.equals(reference)) {
                return lReference;
            }
            ++i;
        }
        return null;
    }

    Vector getPropertyDefinitionSets() {
        return this.mPropertyDefinitionSetRefs;
    }

    void removePropertyDefinitionSet(Reference reference) {
        Reference lReference = this.getPropertyDefinitionSet(reference);
        if (lReference != null) {
            this.mPropertyDefinitionSetRefs.remove(lReference);
        }
    }

    void removeAllPropertyDefinitionSets() {
        this.mPropertyDefinitionSetRefs.clear();
    }

    void replacePropertyDefinitionSet(Reference oldReference, Reference newReference) {
        int lPos = this.mPropertyDefinitionSetRefs.indexOf(oldReference);
        this.mPropertyDefinitionSetRefs.remove(lPos);
        this.mPropertyDefinitionSetRefs.add(lPos, newReference);
    }

    void reorderApplicationProperties(Vector orderedStates) {
        this.mApplicationProperties = orderedStates;
    }

    void reorderPropertyDefinitionSets(Vector orderedReferences) {
        this.mPropertyDefinitionSetRefs = orderedReferences;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("mmRelease")) {
            this.mMetamodelRelease = (String)value;
        } else if (propertyName.equals("mmVersion")) {
            this.mMetamodelVersion = (String)value;
        } else if (propertyName.equals("mmTimestamp")) {
            this.mMetamodelTimestamp = (String)value;
        } else if (propertyName.equals("name")) {
            this.setName((String)value);
        } else if (propertyName.equals("package")) {
            this.setPackage((String)value);
        } else if (propertyName.equals("masterLanguage")) {
            this.setMasterLanguage((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ApplicationProperties")) {
            this.addApplicationProperty((ApplicationPropertyState)((Object)data));
        } else if (roleName.equals("Component")) {
            this.setComponent((Reference)data);
        } else if (roleName.equals("PropertyDefinitionSets")) {
            this.addPropertyDefinitionSet((Reference)data);
        } else if (roleName.equals("StartupPlug")) {
            this.setStartupPlug((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

