/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import java.util.ArrayList;

class ApplicationPropertyState
extends CommonDevelopmentObjectState {
    private String mValue = null;
    private boolean mHasValue = false;
    private Reference mPropertyDefinitionRef = null;

    ApplicationPropertyState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ApplicationPropertyState lState = (ApplicationPropertyState)object;
        return String.valueOf(this.mValue).equals(String.valueOf(lState.mValue));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ApplicationPropertyState lState = (ApplicationPropertyState)object;
        if (!String.valueOf(this.mValue).equals(String.valueOf(lState.mValue))) {
            compareContext.addPropertyDelta(sourceObject, "value", (Object)lState.mValue);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ApplicationPropertyState lState = (ApplicationPropertyState)((Object)super.clone());
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mPropertyDefinitionRef != null) {
            if (clipboardService.isExcluded(this.mPropertyDefinitionRef)) {
                this.mPropertyDefinitionRef = null;
            } else if (innerObjectKeys.contains(this.mPropertyDefinitionRef.toReferenceString())) {
                this.mPropertyDefinitionRef = clipboardService.refactor(this.mPropertyDefinitionRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mPropertyDefinitionRef != null && this.mPropertyDefinitionRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mPropertyDefinitionRef != null) {
            this.mPropertyDefinitionRef = refactoringService.refactor(this.mPropertyDefinitionRef);
        }
    }

    void setValue(String value) {
        if (value == null) {
            this.unsetValue();
            return;
        }
        this.mValue = value;
        this.mHasValue = true;
    }

    String getValue() {
        return this.mValue;
    }

    boolean hasValue() {
        return this.mHasValue;
    }

    void unsetValue() {
        this.mValue = null;
        this.mHasValue = false;
    }

    Reference getPropertyDefinition() {
        return this.mPropertyDefinitionRef;
    }

    void setPropertyDefinition(Reference reference) {
        this.mPropertyDefinitionRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else if (propertyName.equals("value")) {
            this.setValue((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("PropertyDefinition")) {
            this.setPropertyDefinition((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

