/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.enum.VisibilityEnum;
import com.sap.ide.metamodel.webdynpro.implementation.CustomEventState;
import com.sap.ide.metamodel.webdynpro.implementation.ErrorHandlerState;
import com.sap.ide.metamodel.webdynpro.implementation.EventHandlerState;
import com.sap.ide.metamodel.webdynpro.implementation.MethodState;
import com.sap.ide.metamodel.webdynpro.implementation.PropertyState;
import com.sap.ide.metamodel.webdynpro.implementation.TypeState;
import com.sap.ide.metamodel.webdynpro.implementation.ValidatorState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

abstract class AppClassState
extends TypeState {
    private String mCodeBody = null;
    private boolean mHasCodeBody = false;
    private String mVisibility = "public";
    private boolean mHasVisibility = false;
    private Vector mErrorHandlers = new Vector();
    private Vector mEventHandlers = new Vector();
    private HashMap mEvents = new HashMap();
    private Vector mMethods = new Vector();
    private Vector mProperties = new Vector();
    private Vector mValidators = new Vector();
    private Reference mSuperClassRef = null;

    AppClassState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        AppClassState lState = (AppClassState)object;
        if (!String.valueOf(this.mCodeBody).equals(String.valueOf(lState.mCodeBody))) {
            return false;
        }
        return String.valueOf(this.mVisibility).equals(String.valueOf(lState.mVisibility));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        AppClassState lState = (AppClassState)object;
        if (!String.valueOf(this.mCodeBody).equals(String.valueOf(lState.mCodeBody))) {
            compareContext.addPropertyDelta(sourceObject, "codeBody", (Object)lState.mCodeBody);
        }
        if (!String.valueOf(this.mVisibility).equals(String.valueOf(lState.mVisibility))) {
            compareContext.addPropertyDelta(sourceObject, "visibility", (Object)VisibilityEnum.valueOf(lState.mVisibility));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AppClassState lState = (AppClassState)((Object)super.clone());
        lState.mErrorHandlers = new Vector();
        int i = 0;
        while (i < this.mErrorHandlers.size()) {
            lState.mErrorHandlers.add(((ErrorHandlerState)((Object)this.mErrorHandlers.get(i))).clone());
            ++i;
        }
        lState.mEventHandlers = new Vector();
        int i2 = 0;
        while (i2 < this.mEventHandlers.size()) {
            lState.mEventHandlers.add(((EventHandlerState)((Object)this.mEventHandlers.get(i2))).clone());
            ++i2;
        }
        lState.mEvents = new HashMap();
        Iterator it = this.mEvents.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mEvents.put(lKey, ((CustomEventState)((Object)this.mEvents.get(lKey))).clone());
        }
        lState.mMethods = new Vector();
        int i3 = 0;
        while (i3 < this.mMethods.size()) {
            lState.mMethods.add(((MethodState)((Object)this.mMethods.get(i3))).clone());
            ++i3;
        }
        lState.mProperties = new Vector();
        int i4 = 0;
        while (i4 < this.mProperties.size()) {
            lState.mProperties.add(((PropertyState)((Object)this.mProperties.get(i4))).clone());
            ++i4;
        }
        lState.mValidators = new Vector();
        int i5 = 0;
        while (i5 < this.mValidators.size()) {
            lState.mValidators.add(((ValidatorState)((Object)this.mValidators.get(i5))).clone());
            ++i5;
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = ((AbstractList)this.mErrorHandlers).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it2 = ((AbstractList)this.mEventHandlers).iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it3 = this.mEvents.values().iterator();
        while (it3.hasNext()) {
            ((DevelopmentObjectState)it3.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it4 = ((AbstractList)this.mMethods).iterator();
        while (it4.hasNext()) {
            ((DevelopmentObjectState)it4.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it5 = ((AbstractList)this.mProperties).iterator();
        while (it5.hasNext()) {
            ((DevelopmentObjectState)it5.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it6 = ((AbstractList)this.mValidators).iterator();
        while (it6.hasNext()) {
            ((DevelopmentObjectState)it6.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = ((AbstractList)this.mErrorHandlers).iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it2 = ((AbstractList)this.mEventHandlers).iterator();
        while (it2.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it2.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it2.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it3 = this.mEvents.values().iterator();
        while (it3.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it3.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it3.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it4 = ((AbstractList)this.mMethods).iterator();
        while (it4.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it4.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it4.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it5 = ((AbstractList)this.mProperties).iterator();
        while (it5.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it5.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it5.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it6 = ((AbstractList)this.mValidators).iterator();
        while (it6.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it6.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it6.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = ((AbstractList)this.mErrorHandlers).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it2 = ((AbstractList)this.mEventHandlers).iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it3 = this.mEvents.values().iterator();
        while (it3.hasNext()) {
            ((DevelopmentObjectState)it3.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it4 = ((AbstractList)this.mMethods).iterator();
        while (it4.hasNext()) {
            ((DevelopmentObjectState)it4.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it5 = ((AbstractList)this.mProperties).iterator();
        while (it5.hasNext()) {
            ((DevelopmentObjectState)it5.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it6 = ((AbstractList)this.mValidators).iterator();
        while (it6.hasNext()) {
            ((DevelopmentObjectState)it6.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mSuperClassRef != null) {
            if (clipboardService.isExcluded(this.mSuperClassRef)) {
                this.mSuperClassRef = null;
            } else if (innerObjectKeys.contains(this.mSuperClassRef.toReferenceString())) {
                this.mSuperClassRef = clipboardService.refactor(this.mSuperClassRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mSuperClassRef != null && this.mSuperClassRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mSuperClassRef != null) {
            this.mSuperClassRef = refactoringService.refactor(this.mSuperClassRef);
        }
    }

    void setCodeBody(String value) {
        if (value == null) {
            this.unsetCodeBody();
            return;
        }
        this.mCodeBody = value;
        this.mHasCodeBody = true;
    }

    String getCodeBody() {
        return this.mCodeBody;
    }

    boolean hasCodeBody() {
        return this.mHasCodeBody;
    }

    void unsetCodeBody() {
        this.mCodeBody = null;
        this.mHasCodeBody = false;
    }

    void setVisibility(String value) {
        this.mVisibility = value;
        this.mHasVisibility = true;
    }

    String getVisibility() {
        return this.mVisibility;
    }

    boolean hasVisibility() {
        return this.mHasVisibility;
    }

    void addErrorHandler(ErrorHandlerState state) {
        this.mErrorHandlers.add(state);
    }

    void addErrorHandler(ErrorHandlerState state, int position) {
        this.mErrorHandlers.add(position, state);
    }

    int getErrorHandlerCount() {
        return this.mErrorHandlers.size();
    }

    ErrorHandlerState getErrorHandler(String name) {
        int i = 0;
        while (i < this.mErrorHandlers.size()) {
            ErrorHandlerState lState = (ErrorHandlerState)((Object)this.mErrorHandlers.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getErrorHandlers() {
        return this.mErrorHandlers;
    }

    void removeErrorHandler(ErrorHandlerState state) {
        this.mErrorHandlers.remove((Object)state);
    }

    void removeAllErrorHandlers() {
        this.mErrorHandlers.clear();
    }

    void addEventHandler(EventHandlerState state) {
        this.mEventHandlers.add(state);
    }

    void addEventHandler(EventHandlerState state, int position) {
        this.mEventHandlers.add(position, state);
    }

    int getEventHandlerCount() {
        return this.mEventHandlers.size();
    }

    EventHandlerState getEventHandler(String name) {
        int i = 0;
        while (i < this.mEventHandlers.size()) {
            EventHandlerState lState = (EventHandlerState)((Object)this.mEventHandlers.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getEventHandlers() {
        return this.mEventHandlers;
    }

    void removeEventHandler(EventHandlerState state) {
        this.mEventHandlers.remove((Object)state);
    }

    void removeAllEventHandlers() {
        this.mEventHandlers.clear();
    }

    void addEvent(CustomEventState state) {
        this.mEvents.put(state.getName().toLowerCase(), state);
    }

    int getEventCount() {
        return this.mEvents.size();
    }

    CustomEventState getEvent(String name) {
        return (CustomEventState)((Object)this.mEvents.get(name.toLowerCase()));
    }

    Vector getEvents() {
        return new Vector(this.mEvents.values());
    }

    void removeEvent(String aggregationKey) {
        this.mEvents.remove(aggregationKey.toLowerCase());
    }

    void removeEvent(CustomEventState state) {
        this.mEvents.remove(state.getName().toLowerCase());
    }

    void removeAllEvents() {
        this.mEvents.clear();
    }

    void addMethod(MethodState state) {
        this.mMethods.add(state);
    }

    void addMethod(MethodState state, int position) {
        this.mMethods.add(position, state);
    }

    int getMethodCount() {
        return this.mMethods.size();
    }

    MethodState getMethod(String name) {
        int i = 0;
        while (i < this.mMethods.size()) {
            MethodState lState = (MethodState)((Object)this.mMethods.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getMethods() {
        return this.mMethods;
    }

    void removeMethod(MethodState state) {
        this.mMethods.remove((Object)state);
    }

    void removeAllMethods() {
        this.mMethods.clear();
    }

    void addProperty(PropertyState state) {
        this.mProperties.add(state);
    }

    void addProperty(PropertyState state, int position) {
        this.mProperties.add(position, state);
    }

    int getPropertyCount() {
        return this.mProperties.size();
    }

    PropertyState getProperty(String name) {
        int i = 0;
        while (i < this.mProperties.size()) {
            PropertyState lState = (PropertyState)((Object)this.mProperties.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getProperties() {
        return this.mProperties;
    }

    void removeProperty(PropertyState state) {
        this.mProperties.remove((Object)state);
    }

    void removeAllProperties() {
        this.mProperties.clear();
    }

    void addValidator(ValidatorState state) {
        this.mValidators.add(state);
    }

    void addValidator(ValidatorState state, int position) {
        this.mValidators.add(position, state);
    }

    int getValidatorCount() {
        return this.mValidators.size();
    }

    ValidatorState getValidator(String name) {
        int i = 0;
        while (i < this.mValidators.size()) {
            ValidatorState lState = (ValidatorState)((Object)this.mValidators.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getValidators() {
        return this.mValidators;
    }

    void removeValidator(ValidatorState state) {
        this.mValidators.remove((Object)state);
    }

    void removeAllValidators() {
        this.mValidators.clear();
    }

    void moveErrorHandler(int fromPosition, int toPosition) {
        this.mErrorHandlers.add(toPosition, this.mErrorHandlers.remove(fromPosition));
    }

    void moveEventHandler(int fromPosition, int toPosition) {
        this.mEventHandlers.add(toPosition, this.mEventHandlers.remove(fromPosition));
    }

    void moveMethod(int fromPosition, int toPosition) {
        this.mMethods.add(toPosition, this.mMethods.remove(fromPosition));
    }

    void moveProperty(int fromPosition, int toPosition) {
        this.mProperties.add(toPosition, this.mProperties.remove(fromPosition));
    }

    void moveValidator(int fromPosition, int toPosition) {
        this.mValidators.add(toPosition, this.mValidators.remove(fromPosition));
    }

    Reference getSuperClass() {
        return this.mSuperClassRef;
    }

    void setSuperClass(Reference reference) {
        this.mSuperClassRef = reference;
    }

    void reorderErrorHandlers(Vector orderedStates) {
        this.mErrorHandlers = orderedStates;
    }

    void reorderEventHandlers(Vector orderedStates) {
        this.mEventHandlers = orderedStates;
    }

    void reorderMethods(Vector orderedStates) {
        this.mMethods = orderedStates;
    }

    void reorderProperties(Vector orderedStates) {
        this.mProperties = orderedStates;
    }

    void reorderValidators(Vector orderedStates) {
        this.mValidators = orderedStates;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("visibility")) {
            if (VisibilityEnum.valueOf((String)value) != null) {
                this.setVisibility((String)value);
            }
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ErrorHandlers")) {
            this.addErrorHandler((ErrorHandlerState)((Object)data));
        } else if (roleName.equals("EventHandlers")) {
            this.addEventHandler((EventHandlerState)((Object)data));
        } else if (roleName.equals("Events")) {
            this.addEvent((CustomEventState)((Object)data));
        } else if (roleName.equals("Methods")) {
            this.addMethod((MethodState)((Object)data));
        } else if (roleName.equals("Properties")) {
            this.addProperty((PropertyState)((Object)data));
        } else if (roleName.equals("Validators")) {
            this.addValidator((ValidatorState)((Object)data));
        } else if (roleName.equals("SuperClass")) {
            this.setSuperClass((Reference)data);
        } else if (roleName.equals("CodeBody")) {
            this.setCodeBody((String)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

