/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.tools;

import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.web.IServerSource;
import com.tssap.j2ee.model.web.IWebAssemblyProject;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.model.web.IWebProject;
import com.tssap.j2ee.model.web.IWebSource;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.model.web.impl.WebSource;
import com.tssap.j2ee.ui.core.AddWebRefDialog;
import com.tssap.j2ee.ui.perspective.core.action.project.WebApplicationProjectAddWebObjectAction;
import com.tssap.selena.gde.internal.commands.ElementCreationTool;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IType;

public class WebObjectCreationTool
extends ElementCreationTool {
    protected Entity selectWebObject(Model model, Entity parent) {
        String projectName = ModelUinSupport.getProjectId((UniqueName)model.getUniqueName());
        IWebModule webAsmProject = J2eeProjectManager.getWebModule((String)projectName);
        if (webAsmProject == null) {
            throw new IllegalArgumentException();
        }
        IWebApp webApp = webAsmProject.getDescriptor();
        if (webApp == null) {
            throw new IllegalArgumentException();
        }
        AddWebRefDialog webRefDlg = new AddWebRefDialog((IWebAssemblyProject)webAsmProject, null);
        webRefDlg.open();
        if (webRefDlg.getReturnCode() == 1) {
            return null;
        }
        IWebProject[] webPrj = webRefDlg.getReferencedWebProjects();
        int i = 0;
        while (i < webPrj.length) {
            webAsmProject.setReferencedProject((IJ2eeProject)webPrj[i]);
            ++i;
        }
        IWebSource[] webObjects = webRefDlg.getReferencedWebSources();
        if (webObjects == null || webObjects.length != 1) {
            return null;
        }
        IWebSource webObject = webObjects[0];
        Model webModel = ModelAccess.getModel((UniqueName)ModelUinSupport.createModelUin((String)webObject.getProject().getName()));
        if (webModel == null) {
            return null;
        }
        UniqueName webUin = this.getUniqueName(webModel, webObject);
        return webModel.findEntity(webUin);
    }

    private UniqueName getUniqueName(Model model, IWebSource webObject) {
        switch (webObject.getType()) {
            case 10: {
                return WebModelMetaInfo.getJSPUniqueName((IFile)webObject.getFile());
            }
            case 3: {
                return this.getServerSourceUniqueName((IServerSource)webObject, "com.tssap.j2ee.core.web.Servlet");
            }
            case 1: {
                return this.getServerSourceUniqueName((IServerSource)webObject, "com.tssap.j2ee.core.web.Filter");
            }
            case 2: {
                return this.getListenerUniqueName(model, (IServerSource)webObject);
            }
        }
        return null;
    }

    private UniqueName getServerSourceUniqueName(IServerSource element, String metaclass) {
        IType type = element.getIType();
        if (type == null) {
            return null;
        }
        return WebModelMetaInfo.getSourceElementUniqueName((String)type.getFullyQualifiedName(), (String)metaclass);
    }

    private UniqueName getListenerUniqueName(Model model, IServerSource element) {
        UniqueName candidate = this.getServerSourceUniqueName(element, "com.tssap.j2ee.core.web.ServletContextAttributeListener");
        if (model.findElement(candidate) != null) {
            return candidate;
        }
        candidate = this.getServerSourceUniqueName(element, "com.tssap.j2ee.core.web.ServletContextListener");
        if (model.findElement(candidate) != null) {
            return candidate;
        }
        candidate = this.getServerSourceUniqueName(element, "com.tssap.j2ee.core.web.HttpSessionAttributeListener");
        if (model.findElement(candidate) != null) {
            return candidate;
        }
        candidate = this.getServerSourceUniqueName(element, "com.tssap.j2ee.core.web.HttpSessionActivationListener");
        if (model.findElement(candidate) != null) {
            return candidate;
        }
        candidate = this.getServerSourceUniqueName(element, "com.tssap.j2ee.core.web.HttpSessionBindingListener");
        if (model.findElement(candidate) != null) {
            return candidate;
        }
        candidate = this.getServerSourceUniqueName(element, "com.tssap.j2ee.core.web.HttpSessionListener");
        if (model.findElement(candidate) != null) {
            return candidate;
        }
        return null;
    }

    protected Entity actualCreateEntity(Model model, Entity parent) {
        WebApplicationProjectAddWebObjectAction action = new WebApplicationProjectAddWebObjectAction();
        action.run((Element[])new Entity[]{model});
        Object[] addedObjects = action.getAddedObjects();
        if (addedObjects != null && addedObjects.length > 0 && addedObjects instanceof IWebSource[]) {
            IWebSource objectForPositioning = ((IWebSource[])addedObjects)[0];
            IWebAssemblyProject webAppPrj = J2eeElementManager.getWebAssemblyProject((Element)model);
            IWebSource reference = webAppPrj.getReferenced(objectForPositioning);
            if (reference != null && reference instanceof WebSource) {
                Entity selenaEntity = ((WebSource)reference).getSelenaEntity();
                return selenaEntity;
            }
        }
        return null;
    }

    protected Entity getTemplate(Model model) {
        Entity template = super.getTemplate(model);
        if (template == null) {
            template = model.createEntityTemplate();
        }
        return template;
    }
}

