/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.tools;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ear.dd.IApplication;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.J2eeModelLabelProvider;
import com.tssap.selena.gde.internal.commands.ElementCreationTool;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.util.ui.dialog.ObjectSelectionDialog;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;

public abstract class AddModuleToEarTool
extends ElementCreationTool {
    protected IJ2eeProject selectModule(Model model, Entity parent) {
        if (parent.hasProperty("$readOnly")) {
            return null;
        }
        String projectName = ModelUinSupport.getProjectId((UniqueName)model.getUniqueName());
        IEarProject earProject = J2eeProjectManager.getEarProject((String)projectName);
        if (earProject == null) {
            throw new IllegalArgumentException();
        }
        IApplication app = earProject.getDescriptor();
        if (app == null) {
            throw new IllegalArgumentException();
        }
        ObjectSelectionDialog osd = new ObjectSelectionDialog(UIPlugin.getShell(), "Add Modules", this.getDialogName());
        osd.setSingleSelection(true);
        osd.setLabelProvider((ILabelProvider)new J2eeModelLabelProvider());
        Object[] input = this.getProjects(earProject);
        Object[] modules = osd.openDialog(input);
        if (modules == null || modules.length != 1) {
            return null;
        }
        IJ2eeProject result = (IJ2eeProject)modules[0];
        earProject.setReferencedProject(result);
        return result;
    }

    protected abstract String getDialogName();

    private IJ2eeProject[] getProjects(IEarProject earPrj) {
        ArrayList array = new ArrayList();
        this.putProjects(earPrj, array);
        IJ2eeProject[] result = new IJ2eeProject[array.size()];
        if (!array.isEmpty()) {
            result = array.toArray(result);
        }
        return result;
    }

    protected abstract void putProjects(IEarProject var1, ArrayList var2);

    protected Entity actualCreateEntity(Model model, Entity parent) {
        IJ2eeProject module = this.selectModule(model, parent);
        if (module == null) {
            return null;
        }
        Entity template = this.getTemplate(model);
        this.fillTemplate(template, module);
        return parent.createChildEntity(this.getMetaClass(), template);
    }

    protected void fillTemplate(Entity template, IJ2eeProject module) {
        template.setPropertyValue("sourceProject", module.getName());
    }

    protected Entity getTemplate(Model model) {
        Entity template = super.getTemplate(model);
        if (template == null) {
            template = model.createEntityTemplate();
        }
        return template;
    }
}

