/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt.output;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Entity;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xsl.xslt.output.AttributeRepr;
import com.sap.engine.lib.xsl.xslt.output.DocHandlerSerializer;
import com.sap.engine.lib.xsl.xslt.output.InstanceHolder;
import com.sap.engine.lib.xsl.xslt.output.Options;
import com.sap.engine.lib.xsl.xslt.output.OutputException;
import com.sap.engine.lib.xsl.xslt.output.SortableVector;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;

public class CanonicalDocHandlerSerializer
extends DocHandlerSerializer {
    protected boolean documentReached = false;
    protected int depthCounter = 0;
    protected boolean commented = true;
    protected SortableVector currentAttribs = null;
    protected Stack namespacesStack = new Stack();

    public void init() {
        this.documentReached = false;
        this.depthCounter = 0;
        this.commented = true;
        if (this.currentAttribs != null) {
            this.currentAttribs.clear();
        }
        this.holder = new InstanceHolder();
        this.method = this.holder.getMethodXML();
        this.indenter = this.holder.getIndenterEmpty();
        this.cDataSectionElements.clear();
        this.outputProperties = null;
        this.options.clear();
        this.firstElementReached = false;
        this.options.addAll(Options.DEFAULT);
        this.encoder.setOwner(this);
        this.method.setOwner(this);
        this.bMustCloseOnEnd = false;
    }

    public void init(OutputStream stream, Properties prop) throws OutputException {
        this.init();
        this.setOutputProperties(prop);
        this.setOutputStream(stream);
    }

    public CanonicalDocHandlerSerializer() {
    }

    public CanonicalDocHandlerSerializer(Writer writer, Properties outputProperties) throws OutputException {
        this();
        this.setOutputProperties(outputProperties);
        this.setWriter(writer);
    }

    public CanonicalDocHandlerSerializer(OutputStream outputStream, Properties outputProperties) throws OutputException {
        this();
        this.setOutputProperties(outputProperties);
        this.setOutputStream(outputStream);
    }

    public void retainComments(boolean $commented) {
        this.commented = $commented;
    }

    public void startDTD(String name, String publicId, String systemId) throws OutputException {
    }

    public void endDTD() throws OutputException {
    }

    public void startElementStart(CharArray uri, CharArray localName, CharArray qName) throws Exception {
        this.documentReached = true;
        ++this.depthCounter;
        if (!this.firstElementReached) {
            this.firstElementReached = true;
            this.startDocument_internal(localName.getString());
        }
        this.indenter.startElement0(uri, localName, qName);
    }

    public void addAttribute(CharArray uri, CharArray prefix, CharArray localName, CharArray qname, String type, CharArray value) throws Exception {
        if (SignatureContext.XMLNS.equals(prefix) && value.equals("http://www.w3.org/XML/1998/namespace") && SignatureContext.XML.equals(localName)) {
            return;
        }
        AttributeRepr toAdd = this.getAttribRepr(uri, localName, qname, value);
        if (this.currentAttribs == null) {
            this.currentAttribs = new SortableVector(3, 5);
        }
        this.currentAttribs.add(toAdd);
    }

    public void startElementEnd(boolean b) throws Exception {
        Hashtable currentNamespaces;
        block6: {
            boolean notCreated = true;
            Hashtable hashtable = currentNamespaces = this.namespacesStack.isEmpty() ? SignatureContext.EMPTY : (Hashtable)this.namespacesStack.peek();
            if (this.currentAttribs == null || this.currentAttribs.size() <= 0) break block6;
            this.currentAttribs.sort((Comparator)SignatureContext.ac);
            int length = this.currentAttribs.size();
            int i = 0;
            while (i < length) {
                block8: {
                    AttributeRepr a;
                    block9: {
                        block7: {
                            a = (AttributeRepr)this.currentAttribs.elementAt(i);
                            if (!SignatureContext.XMLNS.equals(a.prefix)) break block7;
                            if (a.value.equals(currentNamespaces.get(a.localName))) break block8;
                            if (notCreated) {
                                currentNamespaces = (Hashtable)currentNamespaces.clone();
                                notCreated = false;
                            }
                            currentNamespaces.put(a.localName, a.value);
                            break block9;
                        }
                        if (a.prefix != null && a.prefix.length() != 0 || !SignatureContext.XMLNS.equals(a.localName)) break block9;
                        Object o = currentNamespaces.get(SignatureContext.DEFAULT);
                        if ((o != null || a.value.length() == 0) && (o == null || a.value.equals(o))) break block8;
                        if (notCreated) {
                            currentNamespaces = (Hashtable)currentNamespaces.clone();
                            notCreated = false;
                        }
                        currentNamespaces.put(SignatureContext.DEFAULT, a.value);
                    }
                    this.indenter.attribute(this.copyCharArray(a.uri), a.localName, a.qname, a.value);
                }
                ++i;
            }
            this.currentAttribs.clear();
        }
        this.namespacesStack.push(currentNamespaces);
        this.indenter.startElement1(false);
    }

    public void endElement(CharArray uri, CharArray localName, CharArray qName, boolean b) throws Exception {
        this.namespacesStack.pop();
        --this.depthCounter;
        this.indenter.endElement(uri, localName, qName, false);
    }

    public void onPI(CharArray target, CharArray data) throws Exception {
        if (!this.firstElementReached) {
            this.firstElementReached = true;
            this.startDocument_internal("");
        }
        if (target.equals("javax.xml.transform.disable-output-escaping")) {
            this.encoder.disableOutputEscaping();
            return;
        }
        if (target.equals("javax.xml.transform.enable-output-escaping")) {
            this.encoder.enableOutputEscaping();
            return;
        }
        if (this.documentReached && this.depthCounter == 0) {
            this.method.characters(new char[]{'\n'}, 0, 1);
        }
        this.indenter.processingInstruction(target, data);
        if (!this.documentReached) {
            this.method.characters(new char[]{'\n'}, 0, 1);
        }
    }

    public void onCDSect(CharArray text) throws Exception {
        this.characters(text.getData(), text.getOffset(), text.length());
    }

    public void onDTDEntity(Entity entity) throws Exception {
    }

    public void startDTD(CharArray name, CharArray pub, CharArray sys) throws Exception {
    }

    public void onComment(CharArray text) throws Exception {
        if (this.commented) {
            if (this.documentReached && this.depthCounter == 0) {
                this.method.characters(new char[]{'\n'}, 0, 1);
            }
            super.onComment(text);
            if (!this.documentReached) {
                this.method.characters(new char[]{'\n'}, 0, 1);
            }
        }
    }

    CharArray copyCharArray(CharArray ch) {
        return ch.copy();
    }

    CharArray copyCharArray(String ch) {
        return new CharArray(ch);
    }

    AttributeRepr getAttribRepr(CharArray uri, CharArray localName, CharArray qname, CharArray value) {
        return new AttributeRepr(uri == null ? null : uri.toString(), this.copyCharArray(localName), this.copyCharArray(qname), this.copyCharArray(value));
    }

    void normalizeVector(Vector s) {
        if (s == null) {
            return;
        }
        if (s.capacity() > SignatureContext.MAX_STACK_SIZE) {
            s.setSize(SignatureContext.MAX_STACK_SIZE);
            s.trimToSize();
        }
        s.clear();
    }

    public void release() {
        this.normalizeVector(this.namespacesStack);
        this.normalizeVector(this.currentAttribs);
        this.documentReached = false;
        this.depthCounter = 0;
        this.commented = true;
        this.holder = null;
        this.method = null;
        this.indenter = null;
        this.cDataSectionElements.clear();
        this.outputProperties = null;
        this.options.clear();
    }
}

