/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.URLLoader;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.XMLParserConstants;
import com.sap.engine.lib.xml.parser.handlers.EmptyDocHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.DTMApproximator;
import com.sap.engine.lib.xsl.xpath.IntStack;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xslt.NamespaceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;

public final class DTMFactory
extends EmptyDocHandler {
    private XMLParser xmlParser;
    private DTM dtm;
    private IntStack stack = new IntStack(100);
    private NamespaceManager namespaceManager = null;
    private int startingIndex;
    private int lastElementProcessed;
    private DTMApproximator approximator = null;
    private URLLoader urlLoader = new URLLoader();
    private int APPROXIMATE_OVERLOAD = 500;
    private static final CharArray DISABLE_OUTPUT_ESCAPING_PI = new CharArray("javax.xml.transform.disable-output-escaping");
    private static final CharArray ENABLE_OUTPUT_ESCAPING_PI = new CharArray("javax.xml.transform.enable-output-escaping");
    private boolean inText = false;

    public DTMFactory() {
        try {
            this.approximator = new DTMApproximator();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(DTM dtm0, NamespaceManager namespaceManager) throws XPathException {
        this.dtm = dtm0;
        this.ensureCapacity(this.dtm, 1000);
        this.namespaceManager = namespaceManager;
        if (this.dtm.analyzerResult != null) {
            this.dtm.buffer.assertDataLen(this.dtm.analyzerResult.docdata + 100);
        }
        this.stack.clear();
        this.dtm.clear();
        this.startingIndex = 0;
    }

    public void approximateAndInitialize(DTM dtm0, NamespaceManager namespaceManager, String filename) throws XPathException {
        this.dtm = dtm0;
        this.dtm.buffer.clear();
        this.stack.clear();
        this.dtm.clear();
        this.startingIndex = 0;
        this.namespaceManager = namespaceManager;
        if (this.approximator != null) {
            int a;
            try {
                a = this.approximator.approximate(this.urlLoader.load(filename).openStream(), filename) + this.APPROXIMATE_OVERLOAD;
            }
            catch (IOException e) {
                throw new XPathException(e.toString());
            }
            this.ensureCapacity(this.dtm, a);
        }
    }

    public void initialize(DTM dtm0, NamespaceManager namespaceManager, InputStream in) throws XPathException {
        this.dtm = dtm0;
        this.dtm.clear();
        this.startingIndex = 0;
        this.namespaceManager = namespaceManager;
        try {
            this.ensureParser();
            this.xmlParser.parse(in, (DocHandler)this);
        }
        catch (Exception e) {
            throw new XPathException("Unable to create DTM", e);
        }
    }

    public void initializeDirty(DTM dtm0, NamespaceManager namespaceManager, InputStream in) throws XPathException {
        this.dtm = dtm0;
        this.startingIndex = 0;
        this.namespaceManager = namespaceManager;
        try {
            this.ensureParser();
            this.xmlParser.parse(in, (DocHandler)this);
        }
        catch (Exception e) {
            throw new XPathException("Unable to create DTM", e);
        }
    }

    public void initialize(DTM dtm0, NamespaceManager namespaceManager, String filename) throws XPathException {
        this.dtm = dtm0;
        this.dtm.clear();
        this.startingIndex = 0;
        this.namespaceManager = namespaceManager;
        try {
            int a = 100;
            if (this.approximator == null) {
                a = this.approximator.approximate(this.urlLoader.load(filename).openStream(), filename);
            }
            this.ensureCapacity(dtm0, a);
            this.ensureParser();
            this.xmlParser.parse(filename, (DocHandler)this);
        }
        catch (Exception e) {
            throw new XPathException("Unable to create DTM", e);
        }
    }

    public int appendDocument(DTM dtm0, Source source) throws XPathException {
        return this.appendDocument(dtm0, source, false);
    }

    public int appendDocument(DTM dtm0, Source source, boolean contentOnly) throws XPathException {
        this.dtm = dtm0;
        this.startingIndex = this.dtm.size;
        this.namespaceManager = new NamespaceManager();
        try {
            InputSource inputSource = new InputSource();
            inputSource.setSystemId(source.getSystemId());
            if (source instanceof StreamSource) {
                inputSource.setCharacterStream(((StreamSource)source).getReader());
                inputSource.setByteStream(((StreamSource)source).getInputStream());
                inputSource.setSystemId(source.getSystemId());
            } else if (source instanceof DOMSource) {
                TransformerFactoryImpl factory = new TransformerFactoryImpl();
                Transformer tr = ((TransformerFactory)factory).newTransformer();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                tr.transform(source, new StreamResult(out));
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                inputSource.setByteStream(in);
            }
            this.ensureParser();
            this.xmlParser.setScanContentOnly(contentOnly);
            if (contentOnly) {
                this.startDocument();
            }
            this.xmlParser.parse(inputSource, (DocHandler)this);
            if (contentOnly) {
                this.endDocument();
            }
        }
        catch (Exception e) {
            throw new XPathException("XPath : unable to create DTM", e);
        }
        return this.startingIndex;
    }

    public void startElementStart(CharArray uri, CharArray localName, CharArray qname) throws Exception {
        this.dtm.appendNode(qname, this.namespaceManager.get(uri), -1, (byte)1, null, -1, -1);
        this.dtm.indexStart[this.dtm.size - 1] = this.dtm.buffer.length();
        int x = this.dtm.size - 1;
        int b = this.stack.pop();
        int p = this.stack.top();
        if (b == -1 && p != -1) {
            this.dtm.firstChild[p] = x;
        }
        if (p != -1) {
            this.dtm.parent[x] = p;
        }
        if (b != -1) {
            this.dtm.nextSibling[b] = x;
            this.dtm.previousSibling[x] = b;
        }
        this.stack.push(x);
        this.stack.push(-1);
        this.lastElementProcessed = x;
        this.inText = false;
    }

    public void addAttribute(CharArray uri, CharArray prefix, CharArray localName, CharArray qName, String type, CharArray value) throws Exception {
        if (prefix.equals(XMLParserConstants.caXMLNS)) {
            this.dtm.appendNode(localName, CharArray.EMPTY, -1, (byte)13, value, -1, -1);
        } else if (qName.equals(XMLParserConstants.caXMLNS)) {
            this.dtm.appendNode(CharArray.EMPTY, CharArray.EMPTY, -1, (byte)13, value, -1, -1);
        } else {
            this.dtm.appendNode(qName, this.namespaceManager.get(uri), -1, (byte)2, value, -1, -1);
        }
        this.dtm.parent[this.dtm.size - 1] = this.lastElementProcessed;
        if (type != null && type.equals("ID")) {
            this.dtm.addIdAttribute(this.dtm.size - 1);
        }
        this.inText = false;
    }

    public void startElementEnd(boolean b) {
        this.inText = false;
    }

    public void endElement(CharArray uri, CharArray localName, CharArray QName2, boolean b) throws Exception {
        this.stack.pop();
        int x = this.stack.top();
        this.dtm.indexEnd[x] = this.dtm.buffer.length();
        this.inText = false;
    }

    public void startDocument() throws Exception {
        this.dtm.appendNode(CharArray.EMPTY, null, -1, (byte)9, null, -1, -1);
        this.stack.push(this.dtm.size - 1);
        this.stack.push(-1);
        this.inText = false;
    }

    public void endDocument() throws Exception {
        int x;
        this.dtm.indexStart[0] = 0;
        this.dtm.indexEnd[0] = this.dtm.buffer.length();
        this.dtm.bEndDoc = true;
        this.inText = false;
        while ((x = this.stack.pop()) == -1 || this.dtm.nodeType[x] != 9) {
        }
    }

    public void charData(CharArray carr, boolean bDisableOutputEscaping) throws Exception {
        int l0 = this.dtm.buffer.length();
        this.dtm.buffer.append(carr);
        int l1 = this.dtm.buffer.length();
        if (this.inText) {
            this.dtm.indexEnd[this.dtm.size - 1] = l1;
            return;
        }
        this.dtm.appendNode(CharArray.EMPTY, null, -1, (byte)3, null, l0, l1);
        int x = this.dtm.size - 1;
        int b = this.stack.pop();
        int p = this.stack.top();
        if (b == -1 && p != -1) {
            this.dtm.firstChild[p] = x;
        }
        if (p != -1) {
            this.dtm.parent[x] = p;
        }
        if (b != -1) {
            this.dtm.nextSibling[b] = x;
            this.dtm.previousSibling[x] = b;
        }
        this.stack.push(x);
        this.inText = true;
    }

    public void onPI(CharArray target, CharArray data) throws Exception {
        if (target.equals(DISABLE_OUTPUT_ESCAPING_PI)) {
            return;
        }
        if (target.equals(ENABLE_OUTPUT_ESCAPING_PI)) {
            return;
        }
        int l0 = this.dtm.buffer.length();
        this.dtm.buffer.append(data);
        int l1 = this.dtm.buffer.length();
        this.dtm.appendNode(target, null, -1, (byte)7, null, l0, l1);
        int x = this.dtm.size - 1;
        int b = this.stack.pop();
        int p = this.stack.top();
        if (b == -1 && p != -1) {
            this.dtm.firstChild[p] = x;
        }
        if (p != -1) {
            this.dtm.parent[x] = p;
        }
        if (b != -1) {
            this.dtm.nextSibling[b] = x;
            this.dtm.previousSibling[x] = b;
        }
        this.stack.push(x);
        this.inText = false;
    }

    public void onComment(CharArray text) throws Exception {
        this.dtm.appendNode(CharArray.EMPTY, null, -1, (byte)8, text, -1, -1);
        int x = this.dtm.size - 1;
        int b = this.stack.pop();
        int p = this.stack.top();
        if (b == -1 && p != -1) {
            this.dtm.firstChild[p] = x;
        }
        if (p != -1) {
            this.dtm.parent[x] = p;
        }
        if (b != -1) {
            this.dtm.nextSibling[b] = x;
            this.dtm.previousSibling[x] = b;
        }
        this.stack.push(x);
        this.inText = false;
    }

    public void onCDSect(CharArray text) throws Exception {
        this.charData(text, true);
    }

    private void ensureCapacity(DTM dtm, int a) {
        if (dtm.getCapacity() < a) {
            dtm.resize(a);
        }
    }

    private void ensureParser() throws Exception {
        if (this.xmlParser == null) {
            this.xmlParser = new XMLParser();
            this.xmlParser.setValidation(false);
            this.xmlParser.setNamespaces(true);
            this.xmlParser.setNamespacePrefixes(true);
        }
    }

    public void onWarning(String warning) throws Exception {
    }

    public void setDTM(DTM adtm) {
        this.dtm = adtm;
    }

    public DTM getDTM() {
        return this.dtm;
    }
}

