/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.transform.algorithms;

import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.encryption.EncryptedData;
import com.sap.engine.lib.xml.signature.transform.algorithms.DecryptTransformation;
import java.io.ByteArrayOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BinaryDecryptTransformation
extends DecryptTransformation {
    public BinaryDecryptTransformation(Object[] args) {
        super(args);
    }

    public void transform(Data data) throws SignatureException {
        Node n = data.getNode();
        Element el = n instanceof Document ? ((Document)n).getDocumentElement() : (Element)n;
        NodeList list = el.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
        ByteArrayOutputStream bos = SignatureContext.getByteArrayOutputStreamPool().getInstance();
        try {
            int i = 0;
            while (i < list.getLength()) {
                EncryptedData encData = new EncryptedData((Element)list.item(i), true);
                if (!this.skipDecryption(encData)) {
                    encData.initializeDescendants();
                    bos.write(encData.getDecrypted());
                }
                ++i;
            }
            data.setOctets(bos.toByteArray());
        }
        catch (SignatureException ex1) {
            throw ex1;
        }
        catch (Exception ex) {
            throw new SignatureException(ex);
        }
    }
}

