/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption;

import com.sap.engine.lib.xml.dom.BinaryTextImpl;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.encryption.CipherData;
import com.sap.engine.lib.xml.signature.encryption.CipherReference;
import com.sap.engine.lib.xml.signature.encryption.EncReference;
import com.sap.engine.lib.xml.signature.encryption.EncryptedData;
import com.sap.engine.lib.xml.signature.encryption.EncryptedKey;
import com.sap.engine.lib.xml.signature.encryption.EncryptionMethod;
import com.sap.engine.lib.xml.signature.encryption.XMLCryptor;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.security.GeneralSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLEncryptor
extends XMLCryptor {
    public static int MAX_STRING_SIZE = 1000000;

    public XMLEncryptor() {
        this.mode = 1;
    }

    public static Node createEncryptedKey(String recipient, String carriedKeyName, Transformation[] transforms, String uri, boolean dataReference) throws SignatureException {
        EncryptedKey ek = new EncryptedKey();
        if (recipient != null) {
            ek.setAttribute("Recipient", recipient);
        }
        if (carriedKeyName != null) {
            GenericElement ckn = new GenericElement("http://www.w3.org/2001/04/xmlenc#", "xenc:CarriedKeyName", ek);
            ckn.appendTextChild(carriedKeyName);
        }
        if (transforms != null) {
            GenericElement refList = new GenericElement("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList", ek);
            EncReference cr = new EncReference(uri, true);
            cr.setTransforms(transforms);
            cr.construct(refList);
        }
        return ek.getOwner();
    }

    public Node encrypt(Element el, String $algorithmURI, boolean contentOnly) throws SignatureException {
        return this.replaceWithEncryptedData(el, el, $algorithmURI, contentOnly);
    }

    public void encryptIndirectly(Element whereToPutData, Element parent, Element el, String $algorithmURI, boolean contentOnly, String uri, Transformation[] transforms) throws SignatureException {
        try {
            Text n;
            byte[] base64Encrypted = this.getBase64EncryptedData(el, $algorithmURI, contentOnly);
            String type = contentOnly ? "http://www.w3.org/2001/04/xmlenc#Content" : "http://www.w3.org/2001/04/xmlenc#Element";
            XMLCryptor.deleteContent(whereToPutData);
            Document doc = whereToPutData.getOwnerDocument();
            if (base64Encrypted.length > MAX_STRING_SIZE) {
                BinaryTextImpl bin = new BinaryTextImpl(doc);
                bin.setBinaryData(base64Encrypted);
                n = bin;
            } else {
                n = doc.createTextNode(new String(base64Encrypted));
            }
            whereToPutData.appendChild(n);
            EncryptedData encData = new EncryptedData(parent);
            encData.setType(type);
            encData.construct();
            EncryptionMethod m = new EncryptionMethod(encData);
            m.setAlgorithmURI($algorithmURI);
            m.construct();
            CipherData cd = new CipherData(encData);
            CipherReference cr = new CipherReference(uri);
            cr.setTransforms(transforms);
            cr.construct(cd);
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException("Error in indirect encryption", new Object[]{whereToPutData, parent, el, $algorithmURI}, e);
        }
    }

    private Node replaceWithEncryptedData(Element toReplace, Element el, String $algorithmURI, boolean contentOnly) throws SignatureException {
        try {
            byte[] base64Encrypted = this.getBase64EncryptedData(el, $algorithmURI, contentOnly);
            String type = contentOnly ? "http://www.w3.org/2001/04/xmlenc#Content" : "http://www.w3.org/2001/04/xmlenc#Element";
            Node parent = null;
            int index = 0;
            if (contentOnly) {
                parent = toReplace;
                NodeList childList = parent.getChildNodes();
                int i = childList.getLength();
                while (i > 0) {
                    parent.removeChild(childList.item(i - 1));
                    --i;
                }
            } else {
                parent = toReplace.getParentNode();
                index = XMLEncryptor.getChildIndex(toReplace);
                parent.removeChild(toReplace);
            }
            EncryptedData encData = new EncryptedData(parent, index);
            encData.setType(type);
            encData.construct();
            EncryptionMethod eM = new EncryptionMethod($algorithmURI, null, (GenericElement)encData);
            eM.construct();
            CipherData cD = new CipherData(encData);
            if (base64Encrypted.length > MAX_STRING_SIZE) {
                cD.setValue(base64Encrypted);
            } else {
                cD.setCipherValue(new String(base64Encrypted));
            }
            cD.construct();
            return encData.getDomRepresentation();
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException("Error while replacing with encrypted data", new Object[]{toReplace, el, $algorithmURI}, e);
        }
    }

    public Node getEncrypted(Element el, String $algorithmURI, boolean contentOnly) throws SignatureException {
        try {
            byte[] base64Encrypted = this.getBase64EncryptedData(el, $algorithmURI, contentOnly);
            String type = contentOnly ? "http://www.w3.org/2001/04/xmlenc#Content" : "http://www.w3.org/2001/04/xmlenc#Element";
            EncryptedData encData = new EncryptedData(el);
            encData.setType(type);
            encData.construct();
            EncryptionMethod eM = new EncryptionMethod($algorithmURI, null, (GenericElement)encData);
            eM.construct();
            CipherData cD = new CipherData(encData);
            if (base64Encrypted.length > MAX_STRING_SIZE) {
                cD.setValue(base64Encrypted);
            } else {
                cD.setCipherValue(new String(base64Encrypted));
            }
            cD.construct();
            Node eData = encData.getDomRepresentation();
            el.removeChild(eData);
            return encData.getDomRepresentation();
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException("Error while encrypting", new Object[]{el, $algorithmURI}, e);
        }
    }

    public byte[] encryptRaw(byte[] input, String $algorithmURI) throws SignatureException {
        try {
            try {
                this.createCipher($algorithmURI);
                byte[] encryptedData = this.encrypt0(input);
                this.updateParameters();
                byte[] byArray = encryptedData;
                Object var6_6 = null;
                this.releaseCipher();
                return byArray;
            }
            catch (Exception e) {
                throw new SignatureException("Error while encrypting raw: algorithm:" + $algorithmURI, new Object[]{input, $algorithmURI}, e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.releaseCipher();
            throw throwable;
        }
    }

    private byte[] getBase64EncryptedData(Element el, String $algorithmURI, boolean contentOnly) throws SignatureException, GeneralSecurityException {
        try {
            try {
                byte[] base64Encrypted;
                this.createCipher($algorithmURI);
                byte[] encryptedData = this.encrypt0(el, contentOnly);
                this.updateParameters();
                byte[] byArray = base64Encrypted = BASE64Encoder.encode(encryptedData);
                Object var8_9 = null;
                this.releaseCipher();
                return byArray;
            }
            catch (SignatureException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SignatureException("Error in geting base64 encrypted data", new Object[]{el, $algorithmURI}, e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.releaseCipher();
            throw throwable;
        }
    }

    private static int getChildIndex(Element el) {
        Node parent = el.getParentNode();
        if (parent == null) {
            return -1;
        }
        int index = 0;
        Node previous = el;
        while ((previous = previous.getPreviousSibling()) != null) {
            ++index;
        }
        return index;
    }

    public Node encrypt(byte[] octetsToEncrypt, Node parentNode, String $algorithmURI) throws SignatureException {
        try {
            byte[] base64Encrypted;
            try {
                try {
                    this.createCipher($algorithmURI);
                    this.toEncrypt = octetsToEncrypt;
                    this.encrypt0();
                    this.updateParameters();
                    base64Encrypted = BASE64Encoder.encode(this.toEncrypt);
                    this.toEncrypt = null;
                }
                catch (SignatureException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SignatureException("Error in geting base64 encrypted data", new Object[]{$algorithmURI}, e);
                }
                Object var8_6 = null;
                this.releaseCipher();
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.releaseCipher();
                throw throwable;
            }
            String type = "http://www.w3.org/2001/04/xmlenc#Content";
            EncryptedData encData = new EncryptedData(parentNode, 0);
            encData.setType(type);
            encData.construct();
            EncryptionMethod eM = new EncryptionMethod($algorithmURI, null, (GenericElement)encData);
            eM.construct();
            CipherData cD = new CipherData(encData);
            if (base64Encrypted.length > MAX_STRING_SIZE) {
                cD.setValue(base64Encrypted);
            } else {
                cD.setCipherValue(new String(base64Encrypted));
            }
            cD.construct();
            return encData.getDomRepresentation();
        }
        catch (SignatureException e1) {
            throw e1;
        }
        catch (Exception e) {
            throw new SignatureException("Error while replacing with encrypted data", new Object[]{$algorithmURI}, e);
        }
    }
}

