/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.elements;

import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.signature.transform.TransformationFactory;
import com.sap.engine.lib.xml.signature.transform.algorithms.Canonicalization;
import com.sap.engine.lib.xml.signature.transform.algorithms.ExclusiveCanonicalization;
import com.sap.engine.lib.xml.signature.transform.algorithms.XPathTransformation;
import com.sap.engine.lib.xml.util.BASE64Decoder;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Reference
extends GenericElement {
    public int state = -1;
    private String digestAlgorithmURI = null;
    private String digestValue = null;
    private String canonicalizationURI = null;
    protected TransformationFactory trFact = TransformationFactory.newInstance();
    protected Transformation[] transforms = new Transformation[0];
    private Node envelopingElement = null;
    protected String proxyHost = null;
    protected String proxyPort = null;
    protected String uri = null;
    private String idNamespaceURI = null;
    private String idLocalName = "Id";
    public byte[] transformedData = null;

    public String toString() {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this.transforms.length) {
            b.append(this.transforms[i]).append(',');
            ++i;
        }
        return b.toString();
    }

    public void setProxy(String proxyHost, String proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public void setIDAttribute(String localName, String uri) {
        this.idNamespaceURI = uri;
        this.idLocalName = localName;
    }

    public void setTransformationFactory(TransformationFactory trFact) {
        this.trFact = trFact;
    }

    public Reference() {
        super("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
    }

    public Reference(String namespaceURI, String qName) {
        super(namespaceURI, qName);
    }

    public Reference(String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        super(namespaceUri, qualifiedName, parent);
    }

    public Reference(Element domRepr, GenericElement parent) throws SignatureException {
        super(domRepr, parent);
        this.envelopingElement = parent.getDomRepresentation();
    }

    private void init() throws SignatureException {
        this.initializeDescendants();
        this.uri = this.getAttribute("URI", null, null);
        this.digestAlgorithmURI = this.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "DigestMethod").getAttribute("Algorithm", null, null);
        this.digestValue = this.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "DigestValue").getNodeValue();
        GenericElement transformsElement = this.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "Transforms");
        int xpathIndex = -1;
        try {
            if (transformsElement != null) {
                Vector v = transformsElement.getDirectChildren("http://www.w3.org/2000/09/xmldsig#", "Transform");
                this.transforms = new Transformation[v.size()];
                int i = 0;
                while (i < v.size()) {
                    this.transforms[i] = this.trFact.getInstance((GenericElement)v.get(i));
                    if (this.transforms[i] instanceof ExclusiveCanonicalization) {
                        if (xpathIndex != -1) {
                            ((XPathTransformation)this.transforms[xpathIndex]).setExclusive(true);
                        }
                    } else if (this.transforms[i] instanceof XPathTransformation) {
                        xpathIndex = i;
                    }
                    ++i;
                }
            }
        }
        catch (SignatureException e) {
            this.state = 3;
            throw e;
        }
    }

    public void setEnvelopingElement(Node envelopingElement) {
        this.envelopingElement = envelopingElement;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public void setDigestURI(String digestAlgorithmURI) {
        this.digestAlgorithmURI = digestAlgorithmURI;
    }

    public String getDigestAlgorithmURI() {
        return this.digestAlgorithmURI;
    }

    public String getCanonicalizationURI() {
        return this.canonicalizationURI;
    }

    public String getURI() {
        return this.uri;
    }

    public Transformation[] getTransformations() {
        return this.transforms;
    }

    public void setTransforms(Transformation[] transforms) {
        this.transforms = transforms;
    }

    private void updateNamespaces() {
        Hashtable table = null;
        int i = 0;
        while (i < this.transforms.length) {
            if (this.transforms[i] instanceof XPathTransformation) {
                if (table == null) {
                    table = DOM.getNamespaceMappingsInScopeSpecial(this.domRepresentation);
                }
                ((XPathTransformation)this.transforms[i]).setPrefixMappings(table);
            }
            ++i;
        }
    }

    protected Element getElementByID(String idValue) {
        Document doc = this.envelopingElement.getOwnerDocument();
        Element el = DOM.getElementByAttribute(doc, this.idLocalName, this.idNamespaceURI, idValue);
        String defaultNS = DOM.prefixToURI("xmlns", el);
        Hashtable parentNamespaces = DOM.getNamespaceMappingsInScopeSpecial(el);
        Enumeration keys = parentNamespaces.keys();
        if (defaultNS == null) {
            defaultNS = "http://www.w3.org/2000/xmlns/";
        }
        while (keys.hasMoreElements()) {
            String nextPrefix = (String)keys.nextElement();
            String nextURI = (String)parentNamespaces.get(nextPrefix);
            el.setAttributeNS(defaultNS, nextPrefix == null || nextPrefix.length() == 0 ? "xmlns" : "xmlns:" + nextPrefix, nextURI);
        }
        return el;
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] dereference(String $uri) throws SignatureException {
        if ($uri == null || $uri.equals("") || $uri.equals("#xpointer(/)")) {
            return Canonicalization.canonicalize(this.envelopingElement.getOwnerDocument(), true);
        }
        if ($uri.startsWith("#")) {
            String idReference = null;
            idReference = $uri.startsWith("#xpointer(") ? $uri.substring(14, $uri.length() - 3) : $uri.substring(1);
            Element el = this.getElementByID(idReference);
            if (el == null) {
                return new byte[0];
            }
            return Canonicalization.canonicalize(el, true);
        }
        try {
            int read;
            if (this.proxyHost != null && this.proxyPort != null) {
                SystemProperties.setProperty("http.proxyHost", this.proxyHost);
                SystemProperties.setProperty("http.proxyPort", this.proxyPort);
            }
            InputStream in = SignatureContext.getEntityResolver().resolveEntity(null, $uri).getByteStream();
            byte[] result = new byte[]{};
            byte[] barr = new byte[5000];
            while ((read = in.read(barr)) != -1) {
                void var5_8;
                byte[] temp1 = new byte[result.length + var5_8];
                System.arraycopy(result, 0, temp1, 0, result.length);
                System.arraycopy(barr, 0, temp1, result.length, (int)var5_8);
                result = temp1;
            }
            return result;
        }
        catch (Exception e) {
            this.state = 1;
            throw new SignatureException("Reference unreachable: " + $uri, new Object[]{$uri}, e);
        }
    }

    public boolean validate() throws SignatureException {
        this.init();
        this.updateNamespaces();
        byte[] shouldBe = this.getDigestValue();
        byte[] is = BASE64Decoder.decode(this.digestValue.getBytes());
        boolean result = Arrays.equals(shouldBe, is);
        this.state = result ? 0 : 2;
        return result;
    }

    protected byte[] undergoTransformations() throws SignatureException {
        Data data = new Data(this.dereference(this.uri));
        if (this.transforms != null) {
            int i = 0;
            while (i < this.transforms.length) {
                this.transforms[i].transform(data);
                if (SignatureContext.debug) {
                    try {
                        FileOutputStream fos = new FileOutputStream("c14n-" + SignatureContext.count++ + ".txt");
                        fos.write(data.getOctets());
                        fos.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return data.getOctets();
    }

    protected byte[] getDigestValue() throws SignatureException {
        byte[] data = this.undergoTransformations();
        this.transformedData = data;
        MessageDigest md = null;
        try {
            try {
                byte[] digest;
                md = SignatureContext.getCryptographicPool().getMessageDigestFromPool(this.digestAlgorithmURI);
                if (md == null) {
                    this.state = 4;
                    throw new SignatureException("Unrecognized digest algorithm namespace: " + this.digestAlgorithmURI, new Object[]{this.digestAlgorithmURI});
                }
                byte[] byArray = digest = md.digest(data);
                Object var6_7 = null;
                SignatureContext.getCryptographicPool().releaseMessageDigest(md);
                return byArray;
            }
            catch (SignatureException se) {
                throw se;
            }
            catch (Exception e) {
                throw new SignatureException("Error getting digest value", new Object[]{data}, e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            SignatureContext.getCryptographicPool().releaseMessageDigest(md);
            throw throwable;
        }
    }

    protected void construct(GenericElement $parent, String transformsURI, String transformsQName) throws SignatureException {
        if ($parent == null) {
            $parent = this.parent;
        }
        this.initDOM($parent.getOwner());
        this.setAttribute("URI", this.uri);
        $parent.appendChild(this);
        this.updateNamespaces();
        if (this.transforms.length > 0) {
            GenericElement elTransforms = new GenericElement(transformsURI, transformsQName, this);
            int i = 0;
            while (i < this.transforms.length) {
                String[] prefixes;
                GenericElement transform = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:Transform", elTransforms);
                String algURI = this.transforms[i].uri;
                transform.setAttribute("Algorithm", algURI);
                if (algURI.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
                    GenericElement xpathTrans = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:XPath", transform);
                    String query = (String)this.transforms[i].additionalArgs[0];
                    Hashtable prefixMappings = (Hashtable)this.transforms[i].additionalArgs[1];
                    if (prefixMappings != null) {
                        Enumeration e = prefixMappings.keys();
                        while (e.hasMoreElements()) {
                            String next = (String)e.nextElement();
                            xpathTrans.setAttribute("xmlns:" + next, (String)prefixMappings.get(next));
                        }
                    }
                    xpathTrans.appendTextChild(query);
                } else if (algURI.startsWith("http://www.w3.org/2001/10/xml-exc-c14n#") && this.transforms[i].additionalArgs != null && this.transforms[i].additionalArgs.length > 0 && this.transforms[i].additionalArgs[0] != null && this.transforms[i].additionalArgs[0] instanceof String[] && (prefixes = (String[])this.transforms[i].additionalArgs[0]).length > 0) {
                    StringBuffer prefixList = new StringBuffer(prefixes.length * 4);
                    int j = 0;
                    while (j < prefixes.length - 1) {
                        prefixList.append(prefixes[j]).append(' ');
                        ++j;
                    }
                    prefixList.append(prefixes[prefixes.length - 1]);
                    GenericElement inclusiveNamespaces = new GenericElement("http://www.w3.org/2001/10/xml-exc-c14n#", "ec:InclusiveNamespaces", transform);
                    inclusiveNamespaces.setAttribute("PrefixList", prefixList.toString());
                }
                ++i;
            }
        }
    }

    public void digest(GenericElement $parent) throws SignatureException {
        this.construct($parent, "http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
        GenericElement dMethod = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod", this);
        GenericElement dValue = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue", this);
        byte[] digest = this.getDigestValue();
        byte[] encodedDigest = BASE64Encoder.encode(digest);
        dMethod.setAttribute("Algorithm", this.digestAlgorithmURI);
        dValue.appendTextChild(new String(encodedDigest));
    }
}

