/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.dom;

import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.lib.xml.dom.AttrImpl;
import com.sap.engine.lib.xml.dom.Base;
import com.sap.engine.lib.xml.dom.CDATASectionImpl;
import com.sap.engine.lib.xml.dom.CommentImpl;
import com.sap.engine.lib.xml.dom.DOMImplementationImpl;
import com.sap.engine.lib.xml.dom.DocumentFragmentImpl;
import com.sap.engine.lib.xml.dom.DocumentTypeImpl;
import com.sap.engine.lib.xml.dom.ElementImpl;
import com.sap.engine.lib.xml.dom.EntityReferenceImpl;
import com.sap.engine.lib.xml.dom.NodeImpl;
import com.sap.engine.lib.xml.dom.ProcessingInstructionImpl;
import com.sap.engine.lib.xml.dom.TextImpl;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import java.net.URL;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends NodeImpl
implements Document {
    private DOMImplementationImpl implementation;
    private DocumentTypeImpl dtd;
    private int modificationCounter = 0;
    private URL location = null;
    private int namespaceAwareness = -1;
    private Hashtable hIdToElement = new Hashtable();
    private boolean needsTraversing = true;
    public CharArray normBuffer = new CharArray(1000);

    public DocumentImpl() {
        this.setOwnerDocument(null);
    }

    protected DocumentImpl init(Element root, DocumentType dtd) {
        super.init();
        if (root != null) {
            this.appendChild(root);
        }
        this.location = null;
        this.modificationCounter = 0;
        this.setDTD(dtd);
        return this;
    }

    public int getNamespaceAwareness() {
        return this.namespaceAwareness;
    }

    public void setNamespaceAwareness(int namespaceAwareness) {
        switch (namespaceAwareness) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.namespaceAwareness = namespaceAwareness;
    }

    public Attr createAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (!Symbols.isName(name)) {
            throw new DOMException(5, "'" + name + "' is not a valid name.");
        }
        return new AttrImpl(this).init(name, null);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        return new AttrImpl(this).init(namespaceURI, qualifiedName, null);
    }

    public CDATASection createCDATASection(String data) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        if (this.isHTML()) {
            throw new DOMException(9, "An HTML document cannot create CDATA sections.");
        }
        return (CDATASection)((Object)new CDATASectionImpl(this).init(data, null));
    }

    public Text createTextNode(String data) {
        if (data == null) {
            data = "";
        }
        return (Text)((Object)new TextImpl(this).init(data, null));
    }

    public Comment createComment(String data) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        return (Comment)((Object)new CommentImpl(this).init(data, null));
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public Element createElement(String tagName) {
        return new ElementImpl(this).init(null, tagName, false, null, true);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) {
        return new ElementImpl(this).init(namespaceURI, qualifiedName, true, null, true);
    }

    public EntityReference createEntityReference(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this.isHTML()) {
            throw new DOMException(9, "An HTML document cannot create entity reference nodes.");
        }
        if (!Symbols.isName(name)) {
            throw new DOMException(5, "'" + name + "' is not a valid name.");
        }
        return new EntityReferenceImpl(this).init(name, this);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        if (!Symbols.isName(target)) {
            throw new DOMException(5, "Processing instruction is not ok.");
        }
        if (this.isHTML()) {
            throw new DOMException(9, "An HTML document cannot create entity processing instruction nodes.");
        }
        return new ProcessingInstructionImpl(this).init(target, data, null);
    }

    public DocumentType getDoctype() {
        return this.dtd;
    }

    public Element getDocumentElement() {
        int i = 0;
        while (i < this.getLength()) {
            if (this.item(i).getNodeType() == 1) {
                return (Element)this.item(i);
            }
            ++i;
        }
        return null;
    }

    public Element getElementById(String s) {
        if (this.needsTraversing) {
            Element root;
            if (this.dtd != null && (root = this.getDocumentElement()) != null) {
                this.traverse(root);
            }
            this.needsTraversing = false;
        }
        return (Element)this.hIdToElement.get(s);
    }

    private void traverse(Element e) {
        NamedNodeMap map = e.getAttributes();
        String elementName = e.getNodeName();
        if (map != null) {
            int nMap = map.getLength();
            int i = 0;
            while (i < nMap) {
                Node attr = map.item(i);
                if (this.isIdAttribute(elementName, attr.getNodeName())) {
                    this.hIdToElement.put(attr.getNodeValue(), e);
                }
                ++i;
            }
        }
        NodeList children = e.getChildNodes();
        int nChildren = children.getLength();
        int i = 0;
        while (i < nChildren) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                this.traverse((Element)child);
            }
            ++i;
        }
    }

    public DOMImplementation getImplementation() {
        if (this.implementation == null) {
            this.implementation = new DOMImplementationImpl();
        }
        return this.implementation;
    }

    public Node importNode(Node importedNode, boolean deep) {
        Base newNode;
        short t = importedNode.getNodeType();
        if (t == 9 || t == 10) {
            throw new DOMException(9, "Importing document nodes or document type nodes is not allowed");
        }
        try {
            newNode = (Base)importedNode.cloneNode(deep);
        }
        catch (ClassCastException cce) {
            throw new DOMException(9, "Importing nodes from a different implementation is not allowed");
        }
        newNode.setOwner(this, deep);
        newNode.setParent(null);
        if (t == 1) {
            this.updateDTDForAllElements0((ElementImpl)newNode);
        }
        if (t == 2) {
            ((AttrImpl)newNode).specified = true;
            ((AttrImpl)newNode).overridden = (AttrImpl)newNode;
        }
        return newNode;
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeName() {
        return "#document";
    }

    public Node cloneNode(boolean deep) {
        DocumentImpl r = new DocumentImpl();
        super.transferData(this, r, deep);
        NodeList nl = r.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            ((Base)nl.item(i)).setOwner(r, true);
            ++i;
        }
        if (r.getDocumentElement() != null) {
            ((ElementImpl)r.getDocumentElement()).setOwner(r, true);
        }
        return r;
    }

    protected void modify() {
        ++this.modificationCounter;
    }

    protected int getModificationCounter() {
        return this.modificationCounter;
    }

    protected void setDTD(DocumentType dtd) {
        this.dtd = (DocumentTypeImpl)dtd;
        if (dtd != null) {
            this.dtd.setParent(this);
            this.forcedAppendChild(dtd);
        }
    }

    private boolean isHTML() {
        return false;
    }

    public String toString() {
        return Base.serializeNode(this);
    }

    public DocumentImpl setLocation(URL url) {
        this.location = url;
        return this;
    }

    public URL getLocation() {
        return this.location;
    }

    public Node appendChild(Node newChild) {
        short t = newChild.getNodeType();
        switch (t) {
            case 3: {
                if (Symbols.isWhitespace(((Text)newChild).getData())) {
                    return null;
                }
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                throw new DOMException(3, "Cannot append " + Base.nameOfNodeWithArticle(newChild) + " to a document node.");
            }
            case 10: {
                if (this.getDoctype() != null) {
                    throw new DOMException(3, "DocumentType is already present, cannot be appended as a child.");
                }
                this.setDTD((DocumentType)newChild);
                break;
            }
            case 1: {
                if (this.getDocumentElement() != null) {
                    throw new DOMException(3, "Root Element is already present, cannot be appended as a child.");
                }
                if (((Element)newChild).getOwnerDocument() != this) {
                    throw new DOMException(4, "Attempt to append a child which has been created by another Document");
                }
                super.appendChild(newChild);
                break;
            }
            case 7: 
            case 8: {
                super.appendChild(newChild);
                break;
            }
            case 11: {
                DocumentFragmentImpl df = (DocumentFragmentImpl)newChild;
                NodeList list = df.getChildNodes();
                int nList = list.getLength();
                int i = 0;
                while (i < nList) {
                    this.appendChild(list.item(i));
                    ++i;
                }
                break;
            }
        }
        return newChild;
    }

    public Node insertBefore(Node newChild, Node refChild) {
        if (newChild instanceof Element && refChild != null) {
            throw new DOMException(3, "Attempt to insert " + Base.nameOfNodeWithArticle(newChild) + " before " + Base.nameOfNodeWithArticle(refChild) + " in a Document");
        }
        return super.insertBefore(newChild, refChild);
    }

    protected void addIdAttribute(String elementName, String attributeName) {
        if (this.dtd != null) {
            this.dtd.addIdAttribute(elementName, attributeName);
        }
    }

    protected boolean isIdAttribute(String elementName, String attributeName) {
        return this.dtd == null ? false : this.dtd.isIdAttribute(elementName, attributeName);
    }

    protected void addDefaultAttribute(String elementName, String attributeName, String defaultValue) {
        if (this.dtd != null) {
            this.dtd.addDefaultAttribute(elementName, attributeName, defaultValue);
        }
    }

    protected String getAttributeDefault(String elementName, String attributeName) {
        return this.dtd == null ? null : this.dtd.getAttributeDefault(elementName, attributeName);
    }

    protected String[][] getNamesOfDefaultAttributes(String elementName) {
        return this.dtd == null ? null : this.dtd.getDefaultAttributes(elementName);
    }

    protected void updateDTDForAllElements() {
        ElementImpl e = (ElementImpl)this.getDocumentElement();
        if (e != null) {
            this.updateDTDForAllElements0(e);
        }
    }

    private void updateDTDForAllElements0(ElementImpl e) {
        e.updateDefaultAttributesFromDTD(this.dtd);
        NodeList children = e.getChildNodes();
        if (children != null) {
            int nChildren = children.getLength();
            int i = 0;
            while (i < nChildren) {
                Node child = children.item(i);
                if (child instanceof ElementImpl) {
                    this.updateDTDForAllElements0((ElementImpl)child);
                }
                ++i;
            }
        }
    }

    public Node adoptNode(Node n) {
        return null;
    }

    public String getEncoding() {
        return "";
    }

    public boolean getStandalone() {
        return true;
    }

    public boolean getStrictErrorChecking() {
        return false;
    }

    public String getVersion() {
        return "";
    }

    public void setEncoding(String enc) {
    }

    public void setStandalone(boolean b) {
    }

    public void setStrictErrorChecking(boolean b) {
    }

    public void setVersion(String s) {
    }
}

