/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.dom;

import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.lib.xml.dom.Base;
import com.sap.engine.lib.xml.dom.DocumentImpl;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DOM {
    private static final boolean USE_URIS_IN_CURLY_BRACKETS_INSTEAD_OF_PREFIXES = false;
    public static final int NSA_UNKNOWN = -1;
    public static final int NSA_FALSE = 0;
    public static final int NSA_TRUE = 1;
    static /* synthetic */ Class class$javax$xml$parsers$DocumentBuilderFactory;
    static /* synthetic */ Class class$com$sap$engine$lib$jaxp$DocumentBuilderFactoryImpl;
    static /* synthetic */ Class class$javax$xml$parsers$SAXParserFactory;
    static /* synthetic */ Class class$com$sap$engine$lib$jaxp$SAXParserFactoryImpl;
    static /* synthetic */ Class class$javax$xml$transform$TransformerFactory;
    static /* synthetic */ Class class$com$sap$engine$lib$jaxp$TransformerFactoryImpl;

    private DOM() {
    }

    public static String toXPath(Node node) {
        return DOM.toXPath(new StringBuffer(), node).toString();
    }

    public static String toXPath(NodeList list) {
        return DOM.toXPath(new StringBuffer("{ "), list, ", ").append(" }").toString();
    }

    public static String toXPathWithLocation(Node node) {
        return DOM.toXPathWithLocation(new StringBuffer(), node).toString();
    }

    public static StringBuffer toXPathWithLocation(StringBuffer buffer, Node node) {
        DocumentImpl document;
        if (node instanceof Base && (document = (DocumentImpl)node.getOwnerDocument()) != null) {
            buffer.append("document(\"").append(document.getLocation().toExternalForm()).append("\")");
        }
        DOM.toXPath(buffer, node);
        return buffer;
    }

    public static StringBuffer toXPath(StringBuffer buffer, NodeList list, String separator) {
        int nList;
        if (list == null) {
            return buffer;
        }
        if (separator == null) {
            separator = ", ";
        }
        if ((nList = list.getLength()) == 0) {
            return buffer;
        }
        DOM.toXPath(buffer, list.item(0));
        int i = 1;
        while (i < nList) {
            buffer.append(separator);
            DOM.toXPath(buffer, list.item(i));
            ++i;
        }
        return buffer;
    }

    public static StringBuffer toXPath(StringBuffer buffer, Node node) {
        if (node == null) {
            return buffer;
        }
        if (node.getNodeType() == 9) {
            return buffer.append('/');
        }
        return DOM.toXPath0(buffer, node);
    }

    private static StringBuffer toXPath0(StringBuffer buffer, Node node) {
        if (node == null) {
            return buffer;
        }
        short t = node.getNodeType();
        switch (t) {
            case 1: {
                DOM.toXPath0(buffer, node.getParentNode());
                buffer.append('/');
                DOM.appendQName(buffer, node);
                break;
            }
            case 2: {
                DOM.toXPath0(buffer, ((Attr)node).getOwnerElement());
                buffer.append("/@");
                DOM.appendQName(buffer, node);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                DOM.toXPath0(buffer, node.getParentNode());
                buffer.append("/text()");
                break;
            }
            case 8: {
                DOM.toXPath0(buffer, node.getParentNode());
                buffer.append("/comment()");
                break;
            }
            case 7: {
                DOM.toXPath0(buffer, node.getParentNode());
                ProcessingInstruction pi = (ProcessingInstruction)node;
                String target = pi.getTarget();
                if (target != null) {
                    buffer.append("/processing-instruction('").append(target).append("')");
                    break;
                }
                buffer.append("/processing-instruction()");
                break;
            }
        }
        int cntLeft = 0;
        Node x = node.getPreviousSibling();
        while (x != null) {
            if (DOM.areEquivalent(node, x)) {
                ++cntLeft;
            }
            x = x.getPreviousSibling();
        }
        int cntRight = 0;
        Node x2 = node.getNextSibling();
        while (x2 != null) {
            if (DOM.areEquivalent(node, x2)) {
                ++cntRight;
            }
            x2 = x2.getNextSibling();
        }
        int cnt = cntLeft + 1 + cntRight;
        if (cnt > 1) {
            buffer.append('[').append(cntLeft + 1).append(']');
        }
        return buffer;
    }

    public static boolean areEquivalent(Node a, Node b) {
        short ta = a.getNodeType();
        if (b.getNodeType() != ta) {
            return false;
        }
        switch (ta) {
            case 1: {
                return DOM.compare(a, b);
            }
            case 2: {
                if (DOM.compare(a, b)) {
                    return a.getNodeValue().equals(b.getNodeValue());
                }
                return false;
            }
            case 7: {
                String da = ((ProcessingInstruction)a).getData();
                String db = ((ProcessingInstruction)a).getData();
                return da.equals(db);
            }
            case 3: 
            case 8: {
                return true;
            }
        }
        return true;
    }

    private static boolean compare(Node srcNode, Node dstNode) {
        String aUri = srcNode.getNamespaceURI();
        aUri = aUri == null ? "" : aUri;
        String aLocal = srcNode.getLocalName();
        String bUri = dstNode.getNamespaceURI();
        bUri = bUri == null ? "" : bUri;
        String bLocal = dstNode.getLocalName();
        return aUri.equals(bUri) && aLocal.equals(bLocal);
    }

    private static StringBuffer appendQName(StringBuffer buffer, Node node) {
        return buffer.append(node.getNodeName());
    }

    public static Node toNode(String xpath, Node scope) {
        String nodeTest;
        String step;
        if (xpath == null) {
            return null;
        }
        if (scope == null) {
            return null;
        }
        if ((xpath = xpath.trim()).equals("/") || xpath.equals("")) {
            Node r = scope.getNodeType() == 9 ? scope : scope.getOwnerDocument();
            return r;
        }
        int indexOfSlash = xpath.lastIndexOf(47);
        if (indexOfSlash == -1) {
            step = xpath;
        } else {
            scope = DOM.toNode(xpath.substring(0, indexOfSlash), scope);
            if (scope == null) {
                return null;
            }
            step = xpath.substring(indexOfSlash + 1, xpath.length()).trim();
        }
        int indexOfBracket = step.lastIndexOf(91);
        int predicate = 1;
        if (indexOfBracket != -1) {
            int indexOfClosingBracket = step.indexOf(93, indexOfBracket + 1);
            if (indexOfClosingBracket != -1) {
                String s = step.substring(indexOfBracket + 1, indexOfClosingBracket).trim();
                try {
                    predicate = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            nodeTest = step.substring(0, indexOfBracket).trim();
        } else {
            nodeTest = step;
        }
        if (nodeTest.charAt(0) == '@') {
            if (scope.getNodeType() != 1) {
                return null;
            }
            nodeTest = nodeTest.substring(1);
            String uri = DOM.qnameToURI(nodeTest, scope);
            String local = DOM.qnameToLocalName(nodeTest);
            if (uri.equals(DOM.prefixToURI("", scope))) {
                uri = null;
            }
            uri = uri != null && uri.length() == 0 ? null : uri;
            Attr a = ((Element)scope).getAttributeNodeNS(uri, local);
            return a;
        }
        NodeList children = scope.getChildNodes();
        if (children == null) {
            return null;
        }
        int nChildren = children.getLength();
        if (nChildren == 0) {
            return null;
        }
        if (nodeTest.equals("text()")) {
            int cnt = 0;
            int i = 0;
            while (i < nChildren) {
                if (children.item(i).getNodeType() == 3 && ++cnt == predicate) {
                    return children.item(i);
                }
                ++i;
            }
            return null;
        }
        if (nodeTest.equals("comment()")) {
            int cnt = 0;
            int i = 0;
            while (i < nChildren) {
                if (children.item(i).getNodeType() == 8 && ++cnt == predicate) {
                    return children.item(i);
                }
                ++i;
            }
            return null;
        }
        if (nodeTest.startsWith("processing-instruction(") || nodeTest.startsWith("pi(")) {
            String piName;
            int indexOfOpeningBracket = nodeTest.indexOf(40);
            int indexOfClosingBracket = nodeTest.lastIndexOf(41);
            if (indexOfClosingBracket == -1) {
                indexOfClosingBracket = nodeTest.length();
            }
            if ((piName = nodeTest.substring(indexOfOpeningBracket + 1, indexOfClosingBracket).trim()).equals("")) {
                piName = null;
            } else {
                char ch = piName.charAt(0);
                if (ch == '\'' || ch == '\"') {
                    piName = piName.substring(1);
                }
                if (piName.length() > 0 && ((ch = piName.charAt(piName.length() - 1)) == '\'' || ch == '\"')) {
                    piName = piName.substring(0, piName.length() - 1);
                }
            }
            int cnt = 0;
            int i = 0;
            while (i < nChildren) {
                if (children.item(i).getNodeType() == 7) {
                    ProcessingInstruction x = (ProcessingInstruction)children.item(i);
                    if ((piName == null || piName.equals(x.getTarget())) && ++cnt == predicate) {
                        return x;
                    }
                }
                ++i;
            }
            return null;
        }
        String uri = DOM.qnameToURI(nodeTest, scope);
        String local = DOM.qnameToLocalName(nodeTest);
        uri = uri == null ? "" : uri;
        int cnt = 0;
        int i = 0;
        while (i < nChildren) {
            if (children.item(i).getNodeType() == 1) {
                Element x = (Element)children.item(i);
                String xUri = x.getNamespaceURI();
                xUri = xUri == null ? "" : xUri;
                String xLocal = x.getLocalName();
                if (uri.equals(xUri) && local.equals(xLocal) && ++cnt == predicate) {
                    return x;
                }
            }
            ++i;
        }
        return null;
    }

    public static String prefixToURI(String prefix, Node scope) {
        if (prefix == null) {
            prefix = "";
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        boolean isDefaultNSReached = false;
        while (scope instanceof Element) {
            NamedNodeMap attrs = scope.getAttributes();
            int nAttrs = attrs.getLength();
            int i = 0;
            while (i < nAttrs) {
                Node attr = attrs.item(i);
                String qname = attr.getNodeName();
                String value = attr.getNodeValue();
                if (!isDefaultNSReached && qname.equals("xmlns")) {
                    isDefaultNSReached = true;
                    if (value.length() != 0 && prefix == "") {
                        return value;
                    }
                } else if (qname.startsWith("xmlns:")) {
                    String tempprefix = qname.substring(6);
                    if (prefix.equals(tempprefix)) {
                        return value;
                    }
                } else if (attr.getNamespaceURI() != null && prefix.equals(attr.getPrefix())) {
                    return attr.getNamespaceURI();
                }
                ++i;
            }
            if (scope.getNamespaceURI() != null && prefix.equals(scope.getPrefix())) {
                return scope.getNamespaceURI();
            }
            scope = scope.getParentNode();
        }
        if (prefix.length() == 0) {
            return "";
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Attr prefixToAttr(String prefix, Node scope) {
        if (prefix != null && prefix.length() != 0) ** GOTO lbl28
        while (scope != null) {
            map = scope.getAttributes();
            if (map != null) {
                nMap = map.getLength();
                i = 0;
                while (i < nMap) {
                    a = (Attr)map.item(i);
                    if (a.getNodeName().equals("xmlns")) {
                        return a;
                    }
                    ++i;
                }
            }
            scope = scope.getParentNode();
        }
        return null;
lbl-1000:
        // 1 sources

        {
            map = scope.getAttributes();
            if (map != null) {
                nMap = map.getLength();
                i = 0;
                while (i < nMap) {
                    a = (Attr)map.item(i);
                    aPrefix = a.getPrefix();
                    if (aPrefix != null && aPrefix.equals("xmlns") && a.getLocalName().equals(prefix)) {
                        return a;
                    }
                    ++i;
                }
            }
            scope = scope.getParentNode();
lbl28:
            // 2 sources

            ** while (scope != null)
        }
lbl29:
        // 1 sources

        return null;
    }

    public static String qnameToURI(String qname, Node scope) {
        if (qname.charAt(0) == '{') {
            int index = qname.indexOf(125);
            return qname.substring(1, index);
        }
        return DOM.prefixToURI(DOM.qnameToPrefix(qname), scope);
    }

    public static String qnameToLocalName(String qname) {
        int p = qname.lastIndexOf(58);
        if (p == -1) {
            return qname;
        }
        return qname.substring(p + 1);
    }

    public static String qnameToPrefix(String qname) {
        int p = qname.lastIndexOf(58);
        if (p == -1) {
            return "";
        }
        return qname.substring(qname.startsWith("@") ? 1 : 0, p);
    }

    public static Element[] getChildElementsAsArray(Node x) {
        if (x == null) {
            return new Element[0];
        }
        NodeList children = x.getChildNodes();
        if (children == null) {
            return new Element[0];
        }
        int nChildren = children.getLength();
        Element[] r0 = new Element[nChildren];
        int nr0 = 0;
        int i = 0;
        while (i < nChildren) {
            Node y = children.item(i);
            if (y.getNodeType() == 1) {
                r0[nr0] = (Element)y;
                ++nr0;
            }
            ++i;
        }
        if (nr0 == nChildren) {
            return r0;
        }
        Element[] r = new Element[nr0];
        System.arraycopy(r0, 0, r, 0, nr0);
        return r;
    }

    public static Node[] toNodeArray(NodeList list) {
        if (list == null) {
            return new Node[0];
        }
        int nList = list.getLength();
        Node[] r = new Node[nList];
        int i = 0;
        while (i < nList) {
            r[i] = list.item(i);
            ++i;
        }
        return r;
    }

    public static Element[] toElementArray(NodeList list) {
        if (list == null) {
            return new Element[0];
        }
        int nList = list.getLength();
        Element[] r = new Element[nList];
        int i = 0;
        while (i < nList) {
            r[i] = (Element)list.item(i);
            ++i;
        }
        return r;
    }

    public static URL getLocation(Node node) {
        Document d;
        if (node == null) {
            return null;
        }
        Document document = d = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        if (!(d instanceof DocumentImpl)) {
            return null;
        }
        return ((DocumentImpl)d).getLocation();
    }

    public static Node parse(String location) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(location);
    }

    public static Node parse(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(in);
    }

    public static Node parseXMLFromAString(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(new InputSource(new StringReader(xml)));
    }

    public static Hashtable getNamespaceMappingsInScope(Node node) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        boolean isDefaultNSReached = false;
        while (node instanceof Element) {
            String prefix;
            NamedNodeMap attrs = node.getAttributes();
            int nAttrs = attrs.getLength();
            int i = 0;
            while (i < nAttrs) {
                String prefix2;
                Node attr = attrs.item(i);
                String qname = attr.getNodeName();
                String value = attr.getNodeValue();
                if (!isDefaultNSReached && qname.equals("xmlns")) {
                    isDefaultNSReached = true;
                    if (value.length() != 0) {
                        h.put("", value);
                    }
                } else if (qname.startsWith("xmlns:")) {
                    prefix2 = qname.substring(6);
                    if (!h.containsKey(prefix2)) {
                        h.put(prefix2, value);
                    }
                } else if (attr.getNamespaceURI() != null && (prefix2 = attr.getPrefix()) != null && prefix2.length() != 0 && !h.containsKey(prefix2)) {
                    h.put(prefix2, attr.getNamespaceURI());
                }
                ++i;
            }
            if (node.getNamespaceURI() != null && (prefix = node.getPrefix()) != null && prefix.length() != 0 && !h.containsKey(prefix)) {
                h.put(prefix, node.getNamespaceURI());
            }
            node = node.getParentNode();
        }
        return h;
    }

    public static Hashtable getNamespaceMappingsInScopeSpecial(Node node) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        boolean isDefaultNSReached = false;
        while (node instanceof Element) {
            NamedNodeMap attrs = node.getAttributes();
            int nAttrs = attrs.getLength();
            int i = 0;
            while (i < nAttrs) {
                String prefix;
                Node attr = attrs.item(i);
                String qname = attr.getNodeName();
                String value = attr.getNodeValue();
                if (!isDefaultNSReached && qname.equals("xmlns")) {
                    isDefaultNSReached = true;
                    if (value.length() != 0) {
                        h.put("", value);
                    }
                } else if (qname.startsWith("xmlns:") && !h.containsKey(prefix = qname.substring(6))) {
                    h.put(prefix, value);
                }
                ++i;
            }
            String prefix = node.getPrefix();
            if (prefix != null && !h.containsKey(prefix)) {
                h.put(prefix, node.getNamespaceURI());
            }
            node = node.getParentNode();
        }
        return h;
    }

    public static Element getElementByAttribute(Node n, String localName, String uri, String value) {
        NodeList nl = n.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node temp = nl.item(i);
            if (temp instanceof Element && DOM.hasAttributeFlat((Element)temp, localName, uri, value)) {
                return (Element)temp;
            }
            Element eTemp = DOM.getElementByAttribute(temp, localName, uri, value);
            if (eTemp != null) {
                return eTemp;
            }
            ++i;
        }
        return null;
    }

    private static boolean hasAttributeFlat(Element el, String localName, String uri, String value) {
        String val = el.getAttributeNS(uri, localName);
        return value.equals(val);
    }

    public static int getNamespaceAwareness(Node node) {
        if (node == null) {
            return -1;
        }
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        return document instanceof DocumentImpl ? ((DocumentImpl)document).getNamespaceAwareness() : -1;
    }

    public static void setInQMyJAXP() {
        SystemProperties.setProperty((class$javax$xml$parsers$DocumentBuilderFactory == null ? (class$javax$xml$parsers$DocumentBuilderFactory = DOM.class$("javax.xml.parsers.DocumentBuilderFactory")) : class$javax$xml$parsers$DocumentBuilderFactory).getName(), (class$com$sap$engine$lib$jaxp$DocumentBuilderFactoryImpl == null ? (class$com$sap$engine$lib$jaxp$DocumentBuilderFactoryImpl = DOM.class$("com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl")) : class$com$sap$engine$lib$jaxp$DocumentBuilderFactoryImpl).getName());
        SystemProperties.setProperty((class$javax$xml$parsers$SAXParserFactory == null ? (class$javax$xml$parsers$SAXParserFactory = DOM.class$("javax.xml.parsers.SAXParserFactory")) : class$javax$xml$parsers$SAXParserFactory).getName(), (class$com$sap$engine$lib$jaxp$SAXParserFactoryImpl == null ? (class$com$sap$engine$lib$jaxp$SAXParserFactoryImpl = DOM.class$("com.sap.engine.lib.jaxp.SAXParserFactoryImpl")) : class$com$sap$engine$lib$jaxp$SAXParserFactoryImpl).getName());
        SystemProperties.setProperty((class$javax$xml$transform$TransformerFactory == null ? (class$javax$xml$transform$TransformerFactory = DOM.class$("javax.xml.transform.TransformerFactory")) : class$javax$xml$transform$TransformerFactory).getName(), (class$com$sap$engine$lib$jaxp$TransformerFactoryImpl == null ? (class$com$sap$engine$lib$jaxp$TransformerFactoryImpl = DOM.class$("com.sap.engine.lib.jaxp.TransformerFactoryImpl")) : class$com$sap$engine$lib$jaxp$TransformerFactoryImpl).getName());
    }

    public static void dumpToStream(Node n, OutputStream out) throws FileNotFoundException, TransformerConfigurationException, TransformerException {
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("omit-xml-declaration", "yes");
        tr.setOutputProperty("indent", "no");
        StreamResult result = new StreamResult(out);
        DOMSource source = new DOMSource(n);
        tr.transform(source, result);
    }

    public static Node readFileAsDOM(String xmlFile) throws IOException, FileNotFoundException, ParserConfigurationException, SAXException {
        FileInputStream in = new FileInputStream(xmlFile);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(in);
        return document;
    }

    public static void dumpToFile(Node n, String fileName) throws FileNotFoundException, TransformerConfigurationException, TransformerException {
        FileOutputStream out = new FileOutputStream(fileName);
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("omit-xml-declaration", "yes");
        tr.setOutputProperty("indent", "no");
        StreamResult result = new StreamResult(out);
        DOMSource source = new DOMSource(n);
        tr.transform(source, result);
    }

    public static Node readStreamAsDOM(InputStream in) throws IOException, FileNotFoundException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(in);
        return document;
    }

    public static void main(String[] args) throws Exception {
        String XML = "<a xmlns:p='ppp' xmlns='eee' xmlns:w='www'><b xmlns='' xmlns:p='ppp1' xmlns:q='qqq'/></a>";
        Node node = DOM.parseXMLFromAString(XML);
        node = node.getFirstChild().getFirstChild();
        Hashtable h = DOM.getNamespaceMappingsInScope(node);
        System.out.println(h);
    }

    public static String getNodeValue(Node node) {
        boolean hasChildren = false;
        String value = null;
        if (node instanceof Attr) {
            value = node.getNodeValue().trim();
        } else if (node instanceof Element) {
            NodeList childNodes = node.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                short nodeType = childNode.getNodeType();
                if (nodeType == 3) {
                    value = childNode.getNodeValue().trim();
                    if (!value.equals("")) {
                        return value;
                    }
                } else if (nodeType == 1) {
                    hasChildren = true;
                }
                ++i;
            }
        }
        return hasChildren ? null : value;
    }

    public static Node getParent(Node node) {
        return node instanceof Attr ? ((Attr)node).getOwnerElement() : node.getParentNode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

