/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.AttributeDeclaration;
import com.sap.engine.lib.schema.components.AttributeGroupDefinition;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.ModelGroupDefinition;
import com.sap.engine.lib.schema.components.NotationDeclaration;
import com.sap.engine.lib.schema.components.QualifiedBase;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.impl.SchemaStructuresFactory;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.BuiltInTypesCollector;
import com.sap.engine.lib.schema.components.impl.structures.IdentityConstraintDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.QualifiedBaseImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.QualifiedBasesHashSet;
import com.sap.engine.lib.schema.util.Tools;
import java.util.Hashtable;
import java.util.Vector;

public final class SchemaImpl
extends BaseImpl
implements Schema {
    protected static BuiltInTypesCollector builtInTypesCollector;
    protected QualifiedBasesHashSet typeDefsCollector = new QualifiedBasesHashSet();
    protected QualifiedBasesHashSet elemDeclrsCollector = new QualifiedBasesHashSet();
    protected QualifiedBasesHashSet attribDeclrsCollector = new QualifiedBasesHashSet();
    protected QualifiedBasesHashSet attribGroupDefsCollector = new QualifiedBasesHashSet();
    protected QualifiedBasesHashSet modelGroupDefsCollector = new QualifiedBasesHashSet();
    protected QualifiedBasesHashSet notationDeclrsCollector = new QualifiedBasesHashSet();
    protected QualifiedBasesHashSet identConstrDefsCollector = new QualifiedBasesHashSet();
    protected Vector allComponentsCollector = new Vector();

    public void getTopLevelComponents(Vector componentsCollector) {
        this.getTopLevelTypeDefinitions(componentsCollector);
        this.getTopLevelElementDeclarations(componentsCollector);
        this.getTopLevelAttributeDeclarations(componentsCollector);
        this.getTopLevelAttributeGroupDefinitions(componentsCollector);
        this.getTopLevelModelGroupDefinitions(componentsCollector);
        this.getTopLevelNotationDeclarations(componentsCollector);
        this.getIdentityConstraintDefinitions(componentsCollector);
    }

    public void getIdentityConstraintDefinitions(Vector collector) {
        collector.addAll(this.identConstrDefsCollector.qualifiedBases());
    }

    public void getTopLevelTypeDefinitions(Vector collector) {
        collector.addAll(this.typeDefsCollector.qualifiedBases());
    }

    public void getTopLevelAttributeDeclarations(Vector collector) {
        collector.addAll(this.attribDeclrsCollector.qualifiedBases());
    }

    public void getTopLevelElementDeclarations(Vector collector) {
        collector.addAll(this.elemDeclrsCollector.qualifiedBases());
    }

    public void getTopLevelAttributeGroupDefinitions(Vector collector) {
        collector.addAll(this.attribGroupDefsCollector.qualifiedBases());
    }

    public void getTopLevelModelGroupDefinitions(Vector collector) {
        collector.addAll(this.modelGroupDefsCollector.qualifiedBases());
    }

    public void getTopLevelNotationDeclarations(Vector collector) {
        collector.addAll(this.notationDeclrsCollector.qualifiedBases());
    }

    public IdentityConstraintDefinition[] getIdentityConstraintDefinitionsArray() {
        Object[] result = new IdentityConstraintDefinition[this.identConstrDefsCollector.size()];
        this.identConstrDefsCollector.qualifiedBases().copyInto(result);
        return result;
    }

    public TypeDefinitionBase[] getTopLevelTypeDefinitionsArray() {
        Object[] result = new TypeDefinitionBase[this.typeDefsCollector.size()];
        this.typeDefsCollector.qualifiedBases().copyInto(result);
        return result;
    }

    public AttributeDeclaration[] getTopLevelAttributeDeclarationsArray() {
        Object[] result = new AttributeDeclaration[this.attribDeclrsCollector.size()];
        this.attribDeclrsCollector.qualifiedBases().copyInto(result);
        return result;
    }

    public ElementDeclaration[] getTopLevelElementDeclarationsArray() {
        Object[] result = new ElementDeclaration[this.elemDeclrsCollector.size()];
        this.elemDeclrsCollector.qualifiedBases().copyInto(result);
        return result;
    }

    public AttributeGroupDefinition[] getTopLevelAttributeGroupDefinitionsArray() {
        Object[] result = new AttributeGroupDefinition[this.attribGroupDefsCollector.size()];
        this.attribGroupDefsCollector.qualifiedBases().copyInto(result);
        return result;
    }

    public ModelGroupDefinition[] getTopLevelModelGroupDefinitionsArray() {
        Object[] result = new ModelGroupDefinition[this.modelGroupDefsCollector.size()];
        this.modelGroupDefsCollector.qualifiedBases().copyInto(result);
        return result;
    }

    public NotationDeclaration[] getTopLevelNotationDeclarationsArray() {
        Object[] result = new NotationDeclaration[this.notationDeclrsCollector.size()];
        this.notationDeclrsCollector.qualifiedBases().copyInto(result);
        return result;
    }

    public Base[] getAllComponentsAsArray() {
        Object[] result = new Base[this.allComponentsCollector.size()];
        this.allComponentsCollector.copyInto(result);
        return result;
    }

    public void getAllComponents(Vector collector) {
        collector.addAll(this.allComponentsCollector);
    }

    public int getTypeOfComponent() {
        return 0;
    }

    public IdentityConstraintDefinition getIdentityConstraintDefinition(String uri, String name) {
        return (IdentityConstraintDefinition)((Object)this.identConstrDefsCollector.get(Tools.generateKey(uri, name)));
    }

    public TypeDefinitionBase getTopLevelTypeDefinition(String uri, String name) {
        TypeDefinitionBase typeDefBase = null;
        if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
            typeDefBase = (TypeDefinitionBase)builtInTypesCollector.get(Tools.generateKey(uri, name));
        }
        if (typeDefBase == null) {
            typeDefBase = (TypeDefinitionBase)((Object)this.typeDefsCollector.get(Tools.generateKey(uri, name)));
        }
        return typeDefBase;
    }

    public AttributeDeclaration getTopLevelAttributeDeclaration(String uri, String name) {
        return (AttributeDeclaration)((Object)this.attribDeclrsCollector.get(Tools.generateKey(uri, name)));
    }

    public ElementDeclaration getTopLevelElementDeclaration(String uri, String name) {
        return (ElementDeclaration)((Object)this.elemDeclrsCollector.get(Tools.generateKey(uri, name)));
    }

    public AttributeGroupDefinition getTopLevelAttributeGroupDefinition(String uri, String name) {
        return (AttributeGroupDefinition)((Object)this.attribGroupDefsCollector.get(Tools.generateKey(uri, name)));
    }

    public ModelGroupDefinition getTopLevelModelGroupDefinition(String uri, String name) {
        return (ModelGroupDefinition)((Object)this.modelGroupDefsCollector.get(Tools.generateKey(uri, name)));
    }

    public NotationDeclaration getTopLevelNotationDeclaration(String uri, String name) {
        return (NotationDeclaration)((Object)this.notationDeclrsCollector.get(Tools.generateKey(uri, name)));
    }

    public QualifiedBase getTopLevelComponent(String uri, String name, int type) {
        switch (type) {
            case 4: {
                return this.getTopLevelAttributeDeclaration(uri, name);
            }
            case 5: {
                return this.getTopLevelAttributeGroupDefinition(uri, name);
            }
            case 3: {
                return this.getTopLevelElementDeclaration(uri, name);
            }
            case 8: {
                return this.getTopLevelModelGroupDefinition(uri, name);
            }
            case 14: {
                return this.getTopLevelNotationDeclaration(uri, name);
            }
            case 16: {
                return this.getTopLevelTypeDefinition(uri, name);
            }
            case 1: {
                return this.getTopLevelTypeDefinition(uri, name);
            }
            case 2: {
                return this.getTopLevelTypeDefinition(uri, name);
            }
            case 13: {
                return this.getIdentityConstraintDefinition(uri, name);
            }
        }
        throw new IllegalArgumentException("Type with id " + type + " is unknown.");
    }

    public void addTopLevelComponent(QualifiedBaseImpl qualifiedBase) {
        int type = qualifiedBase.getTypeOfComponent();
        switch (type) {
            case 4: {
                this.addTopLevelComponent(qualifiedBase, this.attribDeclrsCollector);
                break;
            }
            case 5: {
                this.addTopLevelComponent(qualifiedBase, this.attribGroupDefsCollector);
                break;
            }
            case 3: {
                this.addTopLevelComponent(qualifiedBase, this.elemDeclrsCollector);
                break;
            }
            case 8: {
                this.addTopLevelComponent(qualifiedBase, this.modelGroupDefsCollector);
                break;
            }
            case 14: {
                this.addTopLevelComponent(qualifiedBase, this.notationDeclrsCollector);
                break;
            }
            case 16: {
                this.addTopLevelComponent(qualifiedBase, this.typeDefsCollector);
                break;
            }
            case 1: {
                this.addTopLevelComponent(qualifiedBase, this.typeDefsCollector);
                break;
            }
            case 2: {
                this.addTopLevelComponent(qualifiedBase, this.typeDefsCollector);
                break;
            }
            case 13: {
                this.addTopLevelComponent(qualifiedBase, this.identConstrDefsCollector);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type with id " + type + " is unknown.");
            }
        }
    }

    public boolean match(Base schemaImpl) {
        if (!super.match(schemaImpl)) {
            return false;
        }
        SchemaImpl targetSchema = (SchemaImpl)schemaImpl;
        return Tools.compareOrderedSetsOfBases(this.typeDefsCollector.qualifiedBases(), targetSchema.typeDefsCollector.qualifiedBases()) && Tools.compareOrderedSetsOfBases(this.elemDeclrsCollector.qualifiedBases(), targetSchema.elemDeclrsCollector.qualifiedBases()) && Tools.compareOrderedSetsOfBases(this.attribDeclrsCollector.qualifiedBases(), targetSchema.attribDeclrsCollector.qualifiedBases()) && Tools.compareOrderedSetsOfBases(this.attribGroupDefsCollector.qualifiedBases(), targetSchema.attribGroupDefsCollector.qualifiedBases()) && Tools.compareOrderedSetsOfBases(this.modelGroupDefsCollector.qualifiedBases(), targetSchema.modelGroupDefsCollector.qualifiedBases()) && Tools.compareOrderedSetsOfBases(this.notationDeclrsCollector.qualifiedBases(), targetSchema.notationDeclrsCollector.qualifiedBases()) && Tools.compareOrderedSetsOfBases(this.identConstrDefsCollector.qualifiedBases(), targetSchema.identConstrDefsCollector.qualifiedBases());
    }

    public void load() throws SchemaComponentException {
        super.load();
        this.loadComponents(this.typeDefsCollector);
        this.loadComponents(this.elemDeclrsCollector);
        this.loadComponents(this.attribDeclrsCollector);
        this.loadComponents(this.attribGroupDefsCollector);
        this.loadComponents(this.modelGroupDefsCollector);
        this.loadComponents(this.notationDeclrsCollector);
        this.loadComponents(this.identConstrDefsCollector);
    }

    protected void addTopLevelComponent(QualifiedBaseImpl qualifiedBase, QualifiedBasesHashSet collector) {
        String key = qualifiedBase.getQualifiedKey();
        if (!collector.containsKey(key)) {
            collector.put(key, qualifiedBase);
        }
    }

    private void loadComponents(QualifiedBasesHashSet collector) throws SchemaComponentException {
        Vector qBasesCollector = collector.qualifiedBases();
        int size = qBasesCollector.size();
        int i = 0;
        while (i < size) {
            BaseImpl base = (BaseImpl)qBasesCollector.get(i);
            SchemaStructuresFactory.loadBase(base);
            ++i;
        }
    }

    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        SchemaImpl result = (SchemaImpl)super.initializeBase(base, clonedCollector);
        Tools.cloneVectorWithBases(this.typeDefsCollector.qualifiedBases(), result.typeDefsCollector.qualifiedBases(), clonedCollector);
        Tools.cloneVectorWithBases(this.elemDeclrsCollector.qualifiedBases(), result.elemDeclrsCollector.qualifiedBases(), clonedCollector);
        Tools.cloneVectorWithBases(this.attribDeclrsCollector.qualifiedBases(), result.attribDeclrsCollector.qualifiedBases(), clonedCollector);
        Tools.cloneVectorWithBases(this.attribGroupDefsCollector.qualifiedBases(), result.attribGroupDefsCollector.qualifiedBases(), clonedCollector);
        Tools.cloneVectorWithBases(this.modelGroupDefsCollector.qualifiedBases(), result.modelGroupDefsCollector.qualifiedBases(), clonedCollector);
        Tools.cloneVectorWithBases(this.notationDeclrsCollector.qualifiedBases(), result.notationDeclrsCollector.qualifiedBases(), clonedCollector);
        Tools.cloneVectorWithBases(this.identConstrDefsCollector.qualifiedBases(), result.identConstrDefsCollector.qualifiedBases(), clonedCollector);
        return result;
    }

    public static TypeDefinitionBase getBuiltInTypeDefnition(String typeName) {
        return (TypeDefinitionBase)builtInTypesCollector.get(Tools.generateKey("http://www.w3.org/2001/XMLSchema", typeName));
    }

    protected void addIdentityConstraintDefinition(IdentityConstraintDefinitionImpl identityConstraintDefinition) throws SchemaComponentException {
        String qualifiedKey = identityConstraintDefinition.getQualifiedKey();
        if (this.identConstrDefsCollector.containsKey(qualifiedKey)) {
            throw new SchemaComponentException("[location : '" + identityConstraintDefinition.baseInfo.getLocation() + "'] ERROR : Identity constraint definition with {" + identityConstraintDefinition.getTargetNamespace() + "}:" + identityConstraintDefinition.getName() + " is already defined.");
        }
        this.identConstrDefsCollector.put(qualifiedKey, identityConstraintDefinition);
    }

    static {
        if (builtInTypesCollector == null) {
            builtInTypesCollector = new BuiltInTypesCollector();
        }
    }
}

