/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.parser.handlers;

import com.inqmy.lib.xml.parser.handlers.EmptyDocHandler;
import com.inqmy.lib.xml.parser.helpers.Attribute;
import com.inqmy.lib.xml.parser.helpers.CharArray;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class CannonicalDocHandler
extends EmptyDocHandler {
    public RandomAccessFile out = null;

    public CannonicalDocHandler(String filename) throws FileNotFoundException {
        File fp = new File(filename);
        fp.delete();
        this.out = new RandomAccessFile(filename, "rw");
    }

    public String makeDataChar(String str) {
        String ret = "";
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            switch (ch) {
                case '&': {
                    ret = ret + "&amp;";
                    break;
                }
                case '<': {
                    ret = ret + "&lt;";
                    break;
                }
                case '>': {
                    ret = ret + "&gt;";
                    break;
                }
                case '\"': {
                    ret = ret + "&quot;";
                    break;
                }
                case '\t': {
                    ret = ret + "&#9;";
                    break;
                }
                case '\n': {
                    ret = ret + "&#10;";
                    break;
                }
                case '\r': {
                    ret = ret + "&#13;";
                    break;
                }
                default: {
                    ret = ret + ch;
                }
            }
            ++i;
        }
        return ret;
    }

    public void callEmptyElementTag(CharArray sName, Vector attList) throws Exception {
        this.startElement(sName, attList);
        this.endElement(sName);
    }

    public void startElement(CharArray sName, Vector attList) throws Exception {
        this.out.writeBytes("<" + sName);
        int i = 0;
        while (i < attList.size()) {
            Attribute at = (Attribute)attList.get(i);
            this.out.writeBytes(" " + at.getQNameStr() + "=\"" + this.makeDataChar(at.getValueStr()) + "\"");
            ++i;
        }
        this.out.writeBytes(">");
    }

    public void endElement(CharArray sName) throws Exception {
        this.out.writeBytes("</" + sName + ">");
    }

    public void endDocument() throws Exception {
        this.out.close();
    }

    public void charData(CharArray data) throws Exception {
        this.out.writeBytes(this.makeDataChar(data.toString()));
    }

    public void onPI(CharArray target, CharArray data) throws Exception {
        this.out.writeBytes("<?" + target + " " + data + "?>");
    }

    public void onCDSect(CharArray text) throws Exception {
        this.charData(text);
    }
}

