/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.dom;

import com.inqmy.lib.xml.dom.Base;
import com.inqmy.lib.xml.dom.NodeImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class CharacterDataImpl
extends Base
implements CharacterData {
    protected NodeImpl parent;
    protected String data;

    public CharacterDataImpl() {
    }

    protected CharacterDataImpl(Document owner) {
        this.setOwnerDocument(owner);
    }

    protected void clear() {
        this.parent = null;
        this.data = null;
    }

    protected final CharacterDataImpl init(String data, NodeImpl parent) {
        this.data = data;
        this.parent = parent;
        return this;
    }

    public final void appendData(String arg) {
        this.data = this.data + arg;
    }

    public final void deleteData(int offset, int count) {
        if (offset < 0 || count < 0 || offset >= this.data.length()) {
            throw new DOMException(1, "Cannot delete data, index out of bounds.");
        }
        this.data = offset + count >= this.data.length() ? this.data.substring(0, offset) : this.data.substring(0, offset) + this.data.substring(offset + count);
    }

    public final String getData() {
        return this.data;
    }

    public final int getLength() {
        return this.data.length();
    }

    public final void insertData(int offset, String arg) {
        if (offset < 0 || offset > this.data.length()) {
            throw new DOMException(1, "Cannot insert data, index out of bounds.");
        }
        this.data = this.data.substring(0, offset) + arg + this.data.substring(offset);
    }

    public final void replaceData(int offset, int count, String arg) {
        if (offset < 0 || count < 0 || offset >= this.data.length()) {
            throw new DOMException(1, "Cannot replace data, index out of bounds.");
        }
        this.data = offset + count >= this.data.length() ? this.data.substring(0, offset) + arg : this.data.substring(0, offset) + arg + this.data.substring(offset + count);
    }

    public final void setData(String data) {
        this.data = data;
    }

    public final String substringData(int offset, int count) {
        if (offset < 0 || count < 0 || offset >= this.data.length()) {
            throw new DOMException(1, "Cannot take substring, index out of bounds.");
        }
        if (offset + count >= this.data.length()) {
            return this.data.substring(offset);
        }
        return this.data.substring(offset, offset + count);
    }

    protected final void setParent(NodeImpl parent) {
        this.parent = parent;
    }

    public final String getNodeValue() {
        return this.data;
    }

    public final Node getParentNode() {
        return this.parent;
    }

    public final void setNodeValue(String value) {
        this.data = value;
    }

    public void normalize() {
        if (this.getNodeType() != 1 && this.getNodeType() != 9) {
            return;
        }
        NodeList nd = this.getChildNodes();
        int i = 0;
        while (i < nd.getLength()) {
            if (i < nd.getLength() - 1) {
                if (nd.item(i).getNodeType() == 3 && nd.item(i + 1).getNodeType() == 3) {
                    ((Text)nd.item(i)).appendData(((Text)nd.item(i + 1)).getData());
                    this.removeChild(nd.item(i + 1));
                    continue;
                }
                ((Base)nd.item(i)).normalize();
                ++i;
                continue;
            }
            ((Base)nd.item(i)).normalize();
            ++i;
        }
    }
}

