/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.gui.filechooser;

import com.inqmy.lib.schema.gui.filechooser.FileSystemViewTreeModel;
import com.inqmy.lib.schema.gui.filechooser.FileViewTreeCellRenderer;
import com.inqmy.lib.schema.gui.filechooser.XFileView;
import com.inqmy.lib.schema.gui.sapstyle.SAPStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.TreePath;

public final class XFileChooser {
    private static final ImageIcon ICON_REFRESH = SAPStyle.getIcon("s_b_refr");
    private static final ImageIcon ICON_NEW_DIR = SAPStyle.getIcon("S_FOLDER");
    private static final ImageIcon ICON_PLUS = SAPStyle.getIcon("IMAGE11");
    private static final ImageIcon ICON_MINUS = SAPStyle.getIcon("IMAGE12");
    private static final ResourceBundle bundle = ResourceBundle.getBundle((class$com$inqmy$lib$schema$gui$filechooser$XFileChooser == null ? (class$com$inqmy$lib$schema$gui$filechooser$XFileChooser = XFileChooser.class$("com.inqmy.lib.schema.gui.filechooser.XFileChooser")) : class$com$inqmy$lib$schema$gui$filechooser$XFileChooser).getPackage().getName().replace('.', '/') + "/res");
    private static final String S_OK = bundle.getString("ok");
    private static final String S_CANCEL = bundle.getString("cancel");
    private static final String S_REFRESH = bundle.getString("refresh");
    private static final String S_NEW_DIR = bundle.getString("new_dir");
    private static final String S_UNABLE_TO_CREATE = bundle.getString("unable_to_create");
    public static final FileFilter DIR_FILTER = new FileFilter(){

        public boolean accept(File f) {
            return f != null && f.isDirectory();
        }

        public String getDescription() {
            return null;
        }
    };
    private JFrame ownerFrame;
    private JDialog dialog;
    private JPanel panel;
    private JScrollPane treeScrollPane;
    private JTree tree;
    private FileSystemView fileSystemView = FileSystemView.getFileSystemView();
    private FileView fileView = new XFileView();
    private FileFilter fileFilter;
    private Action actionOk;
    private Action actionCancel;
    private Action actionRefresh;
    private Action actionNewDir;
    private int result = -1;
    static /* synthetic */ Class class$com$inqmy$lib$schema$gui$filechooser$XFileChooser;

    public XFileChooser(JFrame frame) {
        this.ownerFrame = frame;
        this.init();
    }

    public File[] showDialog(Component parent, FileFilter fileFilter, boolean allowMultipleSelection, String title) {
        this.dialog.setTitle(title);
        this.dialog.setLocationRelativeTo(parent);
        this.fileFilter = fileFilter;
        this.tree.getSelectionModel().setSelectionMode(allowMultipleSelection ? 4 : 1);
        this.actionRefresh.actionPerformed(null);
        ((Component)this.dialog).setVisible(true);
        if (this.result != 0) {
            return null;
        }
        return this.getSelectedFiles();
    }

    private void init() {
        final FileSystemViewTreeModel fileSystemViewTreeModel = new FileSystemViewTreeModel(this, this.fileSystemView);
        this.actionOk = new AbstractAction(S_OK){

            public void actionPerformed(ActionEvent e) {
                XFileChooser.this.result = 0;
                ((Component)XFileChooser.this.dialog).setVisible(false);
            }
        };
        this.actionCancel = new AbstractAction(S_CANCEL){

            public void actionPerformed(ActionEvent e) {
                XFileChooser.this.result = 1;
                ((Component)XFileChooser.this.dialog).setVisible(false);
            }
        };
        this.actionRefresh = new AbstractAction(S_REFRESH, ICON_REFRESH){

            public void actionPerformed(ActionEvent e) {
                fileSystemViewTreeModel.clearCache();
                XFileChooser.this.tree.updateUI();
            }
        };
        this.actionRefresh.putValue("ShortDescription", S_REFRESH);
        this.actionNewDir = new AbstractAction(S_NEW_DIR, ICON_NEW_DIR){

            public void actionPerformed(ActionEvent e) {
                String s = SAPStyle.showInputDialog(XFileChooser.this.dialog, S_NEW_DIR + ":");
                if (s == null) {
                    return;
                }
                TreePath selectionPath = XFileChooser.this.tree.getSelectionPath();
                if (selectionPath == null) {
                    return;
                }
                Object parentDir = selectionPath.getLastPathComponent();
                if (parentDir == null || parentDir == FileSystemViewTreeModel.ROOT || !((File)parentDir).isDirectory()) {
                    return;
                }
                File dir = XFileChooser.this.fileSystemView.createFileObject((File)parentDir, s);
                if (dir == null) {
                    SAPStyle.showError(XFileChooser.this.dialog, S_UNABLE_TO_CREATE + ' ' + dir);
                    return;
                }
                boolean b = dir.mkdir();
                if (!b) {
                    SAPStyle.showError(XFileChooser.this.dialog, S_UNABLE_TO_CREATE + ' ' + dir);
                    return;
                }
                File parent = dir.getParentFile();
                if (parent != null) {
                    fileSystemViewTreeModel.removeFromCache(parent);
                }
                XFileChooser.this.tree.setSelectionPath(XFileChooser.this.createTreePath(dir));
                XFileChooser.this.tree.updateUI();
            }
        };
        this.actionNewDir.putValue("ShortDescription", S_NEW_DIR);
        this.panel = new JPanel(new BorderLayout());
        JPanel panelTop = new JPanel(new FlowLayout(0));
        JToolBar toolBar = new JToolBar();
        toolBar.add(this.actionNewDir);
        toolBar.add(this.actionRefresh);
        toolBar.setFloatable(false);
        panelTop.add(toolBar);
        this.panel.add((Component)panelTop, "North");
        this.tree = new JTree(fileSystemViewTreeModel){

            public void updateUI() {
            }
        };
        this.tree.setUI(new MetalTreeUI(){

            public Icon getExpandedIcon() {
                return ICON_MINUS;
            }

            public Icon getCollapsedIcon() {
                return ICON_PLUS;
            }
        });
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setBackground(SAPStyle.WHITE);
        this.tree.setScrollsOnExpand(false);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    int row = XFileChooser.this.tree.getRowForLocation(e.getX(), e.getY());
                    if (row == -1) {
                        return;
                    }
                    File file = (File)XFileChooser.this.tree.getPathForRow(row).getLastPathComponent();
                    if (!file.isDirectory() && XFileChooser.this.actionOk.isEnabled()) {
                        XFileChooser.this.actionOk.actionPerformed(null);
                    }
                }
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreePath[] paths = XFileChooser.this.tree.getSelectionPaths();
                boolean isOkEnabled = false;
                if (paths != null) {
                    int i = 0;
                    while (i < paths.length) {
                        File file = (File)paths[i].getLastPathComponent();
                        if (XFileChooser.this.isAcceptableFile(file, false)) {
                            isOkEnabled = true;
                            break;
                        }
                        ++i;
                    }
                }
                XFileChooser.this.actionOk.setEnabled(isOkEnabled);
                XFileChooser.this.actionNewDir.setEnabled(paths != null && paths.length > 0 && ((File)paths[0].getLastPathComponent()).isDirectory());
            }
        });
        this.tree.setScrollsOnExpand(false);
        FileViewTreeCellRenderer renderer = new FileViewTreeCellRenderer(this, this.fileView);
        this.tree.setCellRenderer(renderer);
        this.treeScrollPane = new JScrollPane(this.tree);
        this.treeScrollPane.setPreferredSize(new Dimension(350, 500));
        this.panel.add((Component)this.treeScrollPane, "Center");
        JPanel panelControls = new JPanel(new FlowLayout(2));
        JPanel panelControls0 = new JPanel(new GridLayout(1, 2, 5, 5));
        panelControls0.add(new JButton(this.actionOk));
        panelControls0.add(new JButton(this.actionCancel));
        panelControls.add(panelControls0);
        this.panel.add((Component)panelControls, "South");
        this.dialog = new JDialog(this.ownerFrame);
        this.dialog.setModal(true);
        this.dialog.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                XFileChooser.this.tree.requestFocus();
                XFileChooser.this.tree.setSelectionRow(0);
            }
        });
        this.dialog.setContentPane(this.panel);
        this.dialog.pack();
        int when = 0;
        this.tree.registerKeyboardAction(this.actionOk, KeyStroke.getKeyStroke(10, 2), when);
        this.tree.registerKeyboardAction(this.actionCancel, KeyStroke.getKeyStroke(new Character('\u001b'), 0), when);
        this.tree.registerKeyboardAction(this.actionRefresh, KeyStroke.getKeyStroke(116, 0), when);
        this.tree.registerKeyboardAction(this.actionNewDir, KeyStroke.getKeyStroke(78, 2), when);
    }

    private File[] getSelectedFiles() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null) {
            return new File[0];
        }
        File[] files = new File[paths.length];
        int i = 0;
        while (i < paths.length) {
            files[i] = (File)paths[i].getLastPathComponent();
            ++i;
        }
        return this.extractAcceptableFiles(files, false);
    }

    File[] extractAcceptableFiles(File[] a, boolean includeDirectories) {
        if (a == null) {
            return new File[0];
        }
        int n = 0;
        int i = 0;
        while (i < a.length) {
            if (this.isAcceptableFile(a[i], includeDirectories)) {
                a[n++] = a[i];
            }
            ++i;
        }
        if (n == a.length) {
            return a;
        }
        File[] r = new File[n];
        System.arraycopy(a, 0, r, 0, n);
        return r;
    }

    private boolean isAcceptableFile(File file, boolean includeDirectories) {
        if (file == null) {
            return false;
        }
        if (includeDirectories && (file.getParentFile() == null || file.isDirectory())) {
            return true;
        }
        return this.fileFilter == null || this.fileFilter.accept(file);
    }

    private TreePath createTreePath(Object x) {
        if (x == FileSystemViewTreeModel.ROOT) {
            return new TreePath(x);
        }
        Vector<Object> v = new Vector<Object>();
        File file = (File)x;
        while (file != null) {
            v.insertElementAt(file, 0);
            file = file.getParentFile();
        }
        v.insertElementAt(FileSystemViewTreeModel.ROOT, 0);
        return new TreePath(v.toArray());
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame();
        ((Frame)frame).setIconImage(SAPStyle.SAP_LOGO.getImage());
        XFileChooser chooser = new XFileChooser(frame);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        ((Component)frame).setVisible(true);
        File[] files = chooser.showDialog(null, null, true, "Test");
        if (files == null) {
            System.out.println("files = null");
        } else {
            System.out.println("files = {");
            int i = 0;
            while (i < files.length) {
                System.out.println("  " + files[i].getAbsolutePath());
                ++i;
            }
            System.out.println("}");
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

