/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.generator;

import com.inqmy.lib.schema.SchemaException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public final class URLQueue {
    private String[] aLocation = new String[10];
    private String[] aNS = new String[10];
    private URL[] aResolved = new URL[10];
    private int[] aParent = new int[10];
    private int n = 0;
    private int current = 0;

    public void clear() {
        this.n = 0;
        this.current = 0;
    }

    public void push(String location, String ns, int parent) {
        this.ensure(this.n + 1);
        this.aLocation[this.n] = location;
        this.aNS[this.n] = ns;
        this.aParent[this.n] = parent;
        this.aResolved[this.n] = parent < 0 ? URLQueue.resolve(null, location) : URLQueue.resolve(this.aResolved[parent], location);
        ++this.n;
    }

    public String peekLocation() {
        return this.aLocation[this.current];
    }

    public String peekNS() {
        return this.aNS[this.current];
    }

    public InputStream peekInputStream() {
        try {
            return this.aResolved[this.current].openStream();
        }
        catch (IOException e) {
            throw new SchemaException(e);
        }
    }

    public int peekIndex() {
        return this.current;
    }

    public boolean peekIsDuplicate() {
        int i = 0;
        while (i < this.current) {
            if (this.aNS[i].equals(this.aNS[this.current]) && this.aResolved[i].equals(this.aResolved[this.current])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void pop() {
        ++this.current;
    }

    public boolean isEmpty() {
        return this.current >= this.n;
    }

    private void ensure(int c) {
        if (this.n < c) {
            String[] x = this.aLocation;
            this.aLocation = new String[2 * x.length];
            System.arraycopy(x, 0, this.aLocation, 0, x.length);
            String[] y = this.aNS;
            this.aNS = new String[2 * x.length];
            System.arraycopy(x, 0, this.aNS, 0, x.length);
            URL[] t = this.aResolved;
            this.aResolved = new URL[2 * x.length];
            System.arraycopy(t, 0, this.aResolved, 0, t.length);
            int[] z = this.aParent;
            this.aParent = new int[2 * x.length];
            System.arraycopy(z, 0, this.aParent, 0, z.length);
        }
    }

    private static URL resolve(URL base, String s) {
        URL r = null;
        try {
            r = new URL(base, s);
        }
        catch (MalformedURLException malformedurlexception) {
            try {
                r = new URL(base, new File(s).toURL().toExternalForm());
            }
            catch (MalformedURLException malformedurlexception1) {
                throw new SchemaException("Unable to resolve url: '" + s + "'.");
            }
        }
        return r;
    }
}

