/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.generator;

import com.inqmy.lib.schema.Schema;
import com.inqmy.lib.schema.SchemaException;
import com.inqmy.lib.schema.generator.Constants;
import com.inqmy.lib.schema.generator.TreeWalker;
import com.inqmy.lib.schema.generator.URLQueue;
import com.inqmy.lib.schema.util.ListTokenizer;
import com.inqmy.lib.schema.util.NumberParser;
import com.inqmy.lib.schema.util.Tools;
import com.inqmy.lib.xml.parser.DocHandler;
import com.inqmy.lib.xml.parser.XMLParser;
import com.inqmy.lib.xml.parser.handlers.CompactHandler;
import com.inqmy.lib.xml.parser.handlers.NormalizeDocHandler;
import com.inqmy.lib.xml.parser.handlers.SimpleAttr;
import com.inqmy.lib.xml.parser.helpers.CharArray;
import java.io.InputStream;

public final class SchemaCompiler
extends CompactHandler {
    private static final char[] INITIAL = new char[]{'\uf0b1', '\ua666', '\u0000', '\u0000'};
    private static final CharArray CA_SOAPARRAY = new CharArray("http://schemas.xmlsoap.org/soap/encoding/");
    private Schema owner = null;
    protected static boolean usePreloadedSchemas = true;
    protected static boolean useAutomaticSoapArrayImport = true;
    private boolean bSoapArrayWasImported;
    private char[] stack = new char[1000];
    private boolean[] mark = new boolean[1000];
    private int nStack;
    private int root;
    private String currentNS;
    private ListTokenizer tokenizer = new ListTokenizer();
    private CharArray ca0 = new CharArray();
    private CharArray ca1 = new CharArray();
    private NumberParser np = new NumberParser();
    private boolean isInAnnotation;
    private TreeWalker walker;
    private URLQueue queue = new URLQueue();
    private XMLParser parser;
    private boolean isInExternalSubset;
    private NormalizeDocHandler ndh = new NormalizeDocHandler();
    private int outerName = -1;
    private int header;
    private boolean firstQualifiedElementReached = false;
    private boolean startRootCalled = false;

    public SchemaCompiler(Schema s) {
        this.owner = s;
    }

    public void update() {
        this.walker = this.owner.getWalker();
        this.parser = this.owner.getParser();
    }

    public void startRoot() {
        this.bSoapArrayWasImported = false;
        this.nStack = 0;
        this.pushMark();
        this.push('\u0004');
        this.owner.clearCode();
        this.owner.appendToCode(INITIAL, 0, INITIAL.length);
        this.isInAnnotation = false;
        this.currentNS = "";
        this.queue.clear();
        this.isInExternalSubset = false;
        this.startRootCalled = true;
    }

    public boolean isClosed() {
        return !this.startRootCalled;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startPrefixMapping(String s, String s1) {
    }

    public void endPrefixMapping(String s) {
    }

    public void startElement(CharArray curi, CharArray localName, SimpleAttr[] attrs, int n) {
        if (curi == null) {
            curi = CharArray.EMPTY;
        }
        String uri = curi.toString();
        SchemaCompiler _tmp = this;
        if (!TreeWalker.isSchemaQualified(uri)) {
            if (!this.firstQualifiedElementReached) {
                this.firstQualifiedElementReached = true;
                this.owner.setSchemaNamespaceUsed(uri);
            }
            if (this.isInAnnotation) {
                return;
            }
            this.owner.getErrorHandler().error(-1, "Element " + Tools.formatQName(uri, localName) + " has a non-schema namespace.");
        }
        this.pushMark();
        this.header = -1;
        int i = 0;
        while (i < Constants.E_CODES.length) {
            if (localName.equals(Constants.E_NAMES[i])) {
                this.header = Constants.E_CODES[i];
                break;
            }
            ++i;
        }
        if (this.header == -1) {
            this.owner.getErrorHandler().error(-1, "Schema element not recognized, " + Tools.formatQName(uri, localName) + '.');
            return;
        }
        this.push((char)this.header);
        if (this.header == 15 || this.header == 14) {
            if (this.outerName != -1) {
                this.push('\u00fb');
                this.push((char)this.outerName);
            }
        } else if (this.header == 10) {
            this.currentNS = this.findValueOf("targetNamespace", attrs, n);
            if (this.currentNS == null) {
                this.currentNS = this.queue.peekNS();
            }
            if (this.currentNS == null) {
                this.currentNS = "";
            }
            if (!this.isInExternalSubset) {
                this.queue.push(".", this.currentNS, -1);
            }
            this.startSchema();
        } else if (this.header == 130) {
            String location = this.findValueOf("schemaLocation", attrs, n);
            if (location != null) {
                this.queue.push(location, this.currentNS, this.queue.peekIndex());
            } else {
                this.owner.getErrorHandler().warning(-1, "'xs:include' without a 'schemaLocation'");
            }
        } else if (this.header == 131) {
            String location = this.findValueOf("schemaLocation", attrs, n);
            String target = this.findValueOf("targetNamespace", attrs, n);
            if (location != null) {
                this.queue.push(location, target, this.queue.peekIndex());
            } else {
                this.owner.getErrorHandler().warning(-1, "'xs:include' without a 'schemaLocation'");
            }
        }
        if (this.header == 70) {
            this.isInAnnotation = true;
        }
        this.processAttributes(attrs, n);
    }

    public void endElement(CharArray curi, CharArray localName) {
        SchemaCompiler _tmp = this;
        String uri = curi.toString();
        if (!TreeWalker.isSchemaQualified(uri)) {
            if (this.isInAnnotation) {
                return;
            }
            this.owner.getErrorHandler().error(-1, "Element " + Tools.formatQName(uri, localName) + " has a non-schema namespace.");
        }
        this.push('\u0104');
        this.push('\u0001');
        this.push('\u0001');
        if (localName.equals("schema")) {
            this.transferSchema();
            if (!this.isInExternalSubset) {
                this.isInExternalSubset = true;
                this.parser = this.owner.getParser();
                while (true) {
                    this.queue.pop();
                    if (this.queue.isEmpty()) break;
                    if (this.queue.peekIsDuplicate()) continue;
                    this.ndh.setCompactHandler(this);
                    try {
                        this.parser.parse(this.queue.peekInputStream(), (DocHandler)this.ndh);
                    }
                    catch (SchemaException e1) {
                        throw e1;
                    }
                    catch (Exception e2) {
                        throw new SchemaException(e2);
                    }
                }
                this.isInExternalSubset = false;
            }
            return;
        }
        this.transfer();
        if (localName.equals("annotation")) {
            this.isInAnnotation = false;
        }
    }

    public void charData(CharArray a) {
        if (a.isWhitespace()) {
            return;
        }
        if (this.isInAnnotation) {
            this.push('\u00fa');
            this.push((char)this.owner.addStringToCode(a));
        } else {
            String sa = a.getString().trim();
            if (sa.length() > 20) {
                sa = sa.substring(0, 20);
            }
            this.owner.getErrorHandler().error(-1, "Non-whitespace characters are only allowed in xs:annotations and their descendants.  '" + sa + "'");
        }
    }

    public void endRoot() {
        if (useAutomaticSoapArrayImport && !this.bSoapArrayWasImported && this.owner.findStringInCode(CA_SOAPARRAY)) {
            InputStream preloaded = ClassLoader.getSystemResourceAsStream("com/inqmy/lib/schema/generator/preloaded/soaparray.xsd");
            if (preloaded == null) {
                throw new SchemaException("Preloaded soaparray.xsd not found!");
            }
            NormalizeDocHandler ndh = new NormalizeDocHandler();
            ndh.setCompactHandler(this);
            try {
                this.parser.parse(preloaded, (DocHandler)ndh);
            }
            catch (Exception e) {
                throw new SchemaException(e);
            }
        }
        this.push('\u0001');
        this.transfer();
        this.owner.getCode()[2] = this.stack[this.nStack - 1];
        this.owner.updateAll();
        this.fixParents();
        this.startRootCalled = false;
    }

    private void startSchema() {
        if (this.currentNS != null && this.currentNS.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            this.bSoapArrayWasImported = true;
        }
    }

    private void endSchema() {
    }

    protected void push(char c) {
        if (this.nStack >= this.stack.length) {
            char[] stackOld = this.stack;
            boolean[] markOld = this.mark;
            this.stack = new char[this.stack.length * 2];
            this.mark = new boolean[this.mark.length * 2];
            System.arraycopy(stackOld, 0, this.stack, 0, stackOld.length);
            System.arraycopy(markOld, 0, this.mark, 0, markOld.length);
        }
        this.stack[this.nStack] = c;
        this.mark[this.nStack] = false;
        ++this.nStack;
    }

    protected void pushMark() {
        this.push('\u0000');
        this.mark[this.nStack - 1] = true;
    }

    protected void transfer() {
        int p = this.nStack - 1;
        while (!this.mark[p]) {
            --p;
        }
        char x = (char)this.owner.getCodeSize();
        this.owner.appendToCode(this.stack, p + 1, this.nStack);
        this.stack[p] = 200;
        this.stack[p + 1] = x;
        this.mark[p + 1] = false;
        this.mark[p] = false;
        this.nStack = p + 2;
    }

    protected void transferSchema() {
        int ns = this.owner.addStringToCode(this.ca0.set(this.currentNS));
        int p = this.nStack - 1;
        while (!this.mark[p]) {
            --p;
        }
        char x = (char)this.owner.getCodeSize();
        this.owner.appendToCode(this.stack, p + 1, this.nStack);
        this.stack[p] = (char)ns;
        this.stack[p + 1] = x;
        this.mark[p + 1] = false;
        this.mark[p] = false;
        this.nStack = p + 2;
    }

    private void processName(CharArray name, CharArray u, CharArray l) {
        name.parseNS(u, l);
        try {
            u.set(this.getPrefixURI(u));
        }
        catch (Exception e) {
            throw new SchemaException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processAttributes(SimpleAttr[] attrs, int n) {
        bits = '\u0000';
        bitsModified = false;
        if (this.header == 11 || this.header == 12) {
            this.outerName = -1;
        }
        i = 0;
        while (i < n) {
            name = this.ca0;
            value = this.ca1;
            name.set(attrs[i].localName);
            value.set(attrs[i].value);
            if (attrs[i].uri == null) ** GOTO lbl-1000
            if (attrs[i].uri.equals("http://schemas.xmlsoap.org/wsdl/")) {
                if (name.equals("arrayType")) {
                    v = attrs[i].value;
                    pBracket = v.indexOf(91);
                    if (pBracket == -1) {
                        throw new SchemaException("Incorrect format of wsdl:arrayType; '[' must be present.");
                    }
                    q = v.substring(0, pBracket);
                    d = v.substring(pBracket);
                    dimensions = 0;
                    ld = d.length();
                    bracketLevel = false;
                    j = 0;
                    while (j < ld) {
                        ch = d.charAt(j);
                        if (ch != ' ') {
                            if (ch == '[') {
                                if (bracketLevel) {
                                    throw new SchemaException("Incorrect format of wsdl:arrayType; nested square brackets are not allowed.");
                                }
                                ++dimensions;
                                bracketLevel = true;
                            } else if (ch == ']') {
                                if (!bracketLevel) {
                                    throw new SchemaException("Incorrect format of wsdl:arrayType; ']' without a '['.");
                                }
                                bracketLevel = false;
                            } else if (ch == ',') {
                                if (!bracketLevel) {
                                    throw new SchemaException("Incorrect format of wsdl:arrayType; ',' is allowed only within '[' and ']'.");
                                }
                                ++dimensions;
                            } else {
                                throw new SchemaException("Incorrect format of wsdl:arrayType; Illegal character in wsdl:arrayType dimensions descriptor, '" + ch + "'.");
                            }
                        }
                        ++j;
                    }
                    if (bracketLevel) {
                        throw new SchemaException("Incorrect format of wsdl:arrayType; '[' not closed.");
                    }
                    this.processName(this.ca1.set(q), this.ca0, this.ca1);
                    indexOfQ = this.owner.addQName(this.ca0, this.ca1);
                    this.push('\u00fe');
                    this.push((char)indexOfQ);
                    this.push('\u00ff');
                    this.push((char)dimensions);
                }
            } else if (attrs[i].uri.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                if (name.equals("itemType") || name.equals("arrayType")) {
                    v = attrs[i].value;
                    this.processName(this.ca1.set(v), this.ca0, this.ca1);
                    indexOfQ = this.owner.addQName(this.ca0, this.ca1);
                    this.push('\u00fe');
                    this.push((char)indexOfQ);
                } else if (name.equals("arraySize")) {
                    v = attrs[i].value;
                    lv = v.length();
                    dimensions = 0;
                    j = 0;
                    while (j < lv) {
                        ch = v.charAt(j);
                        if (ch == ' ') {
                            ++j;
                            continue;
                        }
                        if (ch >= '0' && ch <= '9') {
                            while (ch >= '0' && ch <= '9') {
                                if (++j >= lv) break;
                                ch = v.charAt(j);
                            }
                            ++dimensions;
                            continue;
                        }
                        if (ch == '*') {
                            if (dimensions > 0) {
                                throw new SchemaException("Illegal format of soapenc:arraySize; '*' is allowed only as first dimension.");
                            }
                            ++dimensions;
                            ++j;
                            continue;
                        }
                        throw new SchemaException("Illegal format of soapenc:arraySize; character not allowed, '" + ch + "'.");
                    }
                    if (dimensions == 0) {
                        throw new SchemaException("Illegal format of soapenc:arraySize; there must be at least one dimension.");
                    }
                    this.push('\u00ff');
                    this.push((char)dimensions);
                }
            } else if (attrs[i].uri == null || attrs[i].uri.length() == 0) {
                if (name.equals("abstract")) {
                    this.push('\u00e2');
                    v = this.np.parseBoolean(value);
                    this.push(v != false ? '\u0001' : '\u0000');
                    if (!this.np.ok()) {
                        this.owner.getErrorHandler().error(-1, "Attribute 'abstract' should be a boolean.");
                    }
                } else if (name.equals("mixed")) {
                    this.push('\u00e1');
                    v = this.np.parseBoolean(value);
                    this.push(v != false ? '\u0001' : '\u0000');
                    if (!this.np.ok()) {
                        this.owner.getErrorHandler().error(-1, "Attribute 'mixed' should be a boolean.");
                    }
                } else if (name.equals("nillable") || name.equals("nullable")) {
                    v = this.np.parseBoolean(value);
                    this.push('\u00e0');
                    this.push(v != false ? '\u0001' : '\u0000');
                    if (!this.np.ok()) {
                        this.owner.getErrorHandler().error(-1, "Attribute 'nillable' should be a boolean.");
                    }
                } else if (name.equals("form")) {
                    bitsModified = true;
                    if (value.equals("qualified")) {
                        bits = (char)(bits | 2);
                    } else if (value.equals("unqualified")) {
                        bits = (char)(bits & 65533);
                    } else {
                        this.owner.getErrorHandler().error(-1, "Attribute 'form' must be either 'qualified' or 'unqualified'.");
                    }
                } else if (name.equals("use")) {
                    bitsModified = true;
                    if (!value.equals("optional")) {
                        if (value.equals("prohibited")) {
                            bits = (char)(bits + 16384);
                        } else if (value.equals("required")) {
                            bits = (char)(bits + 8192);
                        } else {
                            this.owner.getErrorHandler().error(-1, "Attribute 'use' must be either 'optional' or 'prohibited' or 'required'.");
                        }
                    }
                } else if (name.equals("block")) {
                    bitsModified = true;
                    if (value.equals("#all")) {
                        bits = (char)(bits | 2048);
                        bits = (char)(bits | 1024);
                        bits = (char)(bits | 4096);
                    } else {
                        this.tokenizer.init(value, this.ca0);
                        while (this.tokenizer.hasMore()) {
                            if (this.ca0.equals("extension")) {
                                bits = (char)(bits | 2048);
                            } else if (this.ca0.equals("restriction")) {
                                bits = (char)(bits | 1024);
                            } else if (this.ca0.equals("substitution")) {
                                bits = (char)(bits | 4096);
                            } else {
                                this.owner.getErrorHandler().error(-1, "Attribute 'block' must be either '#all' or a list of 'extension', 'restriction', and 'substitution'.");
                            }
                            this.tokenizer.next();
                        }
                    }
                } else if (name.equals("final")) {
                    bitsModified = true;
                    if (value.equals("#all")) {
                        bits = (char)(bits | 128);
                        bits = (char)(bits | 64);
                        bits = (char)(bits | 256);
                        bits = (char)(bits | 512);
                        this.push('\u00fc');
                        this.push('\u0001');
                    } else {
                        this.tokenizer.init(value, this.ca0);
                        while (this.tokenizer.hasMore()) {
                            if (this.ca0.equals("extension")) {
                                bits = (char)(bits | 128);
                                this.push('\u00fc');
                                this.push('\u0001');
                            } else if (this.ca0.equals("restriction")) {
                                bits = (char)(bits | 64);
                                this.push('\u00fc');
                                this.push('\u0001');
                            } else if (this.ca0.equals("list")) {
                                bits = (char)(bits | 256);
                                this.push('\u00fc');
                                this.push('\u0001');
                            } else if (this.ca0.equals("union")) {
                                bits = (char)(bits | 512);
                                this.push('\u00fc');
                                this.push('\u0001');
                            } else {
                                throw new SchemaException("Attribute 'final' must be either '#all' or a list of 'extension', 'restriction', 'list', and 'union'.");
                            }
                            this.tokenizer.next();
                        }
                    }
                } else if (name.equals("name")) {
                    this.push('\u00cb');
                    this.outerName = this.owner.addStringToCode(value);
                    this.push((char)this.outerName);
                } else if (name.equals("id")) {
                    this.push('\u00ca');
                    this.push((char)this.owner.addStringToCode(value));
                } else if (name.equals("value")) {
                    this.push('\u00d3');
                    this.push((char)this.owner.addStringToCode(value));
                } else if (name.equals("processContents")) {
                    this.push('\u00d8');
                    this.push((char)this.owner.addStringToCode(value));
                } else if (name.equals("memberTypes")) {
                    this.push('\u00d7');
                    this.push((char)this.owner.addStringToCode(value));
                } else if (name.equals("namespace")) {
                    this.push('\u00da');
                    this.push((char)this.owner.addStringToCode(value));
                } else if (name.equals("version")) {
                    this.push('\u00d6');
                    this.push((char)this.owner.addStringToCode(value));
                } else if (name.equals("public")) {
                    this.push('\u00dc');
                    this.push((char)this.owner.addStringToCode(value));
                } else if (name.equals("system")) {
                    this.push('\u00dd');
                    this.push((char)this.owner.addStringToCode(value));
                } else if (name.equals("elementFormDefault")) {
                    this.push('\u00de');
                    this.push((char)this.owner.addStringToCode(value));
                } else if (name.equals("attributeFormDefault")) {
                    this.push('\u00e4');
                    this.push((char)this.owner.addStringToCode(value));
                } else if (name.equals("blockDefault")) {
                    this.push('\u00df');
                    this.push((char)this.owner.addStringToCode(value));
                } else if (name.equals("default")) {
                    this.push('\u00d0');
                    this.push((char)this.owner.addStringToCode(value));
                } else if (name.equals("xpath")) {
                    this.push('\u00d2');
                    this.push((char)this.owner.addStringToCode(value));
                } else if (name.equals("targetNamespace")) {
                    this.push('\u00d4');
                    this.push((char)this.owner.addStringToCode(value));
                } else if (name.equals("source")) {
                    this.push('\u00db');
                    this.push((char)this.owner.addStringToCode(value));
                } else if (name.equals("fixed")) {
                    this.push('\u00d1');
                    this.push((char)this.owner.addStringToCode(value));
                } else if (name.equals("ref")) {
                    this.push('\u00d5');
                    this.processName(value, this.ca0, this.ca1);
                    this.push((char)this.owner.addQName(this.ca0, this.ca1));
                } else if (name.equals("base")) {
                    this.push('\u00cf');
                    this.processName(value, this.ca0, this.ca1);
                    this.push((char)this.owner.addQName(this.ca0, this.ca1));
                } else if (name.equals("itemType")) {
                    this.push('\u00d9');
                    this.processName(value, this.ca0, this.ca1);
                    this.push((char)this.owner.addQName(this.ca0, this.ca1));
                } else if (name.equals("type")) {
                    this.push('\u00cc');
                    this.processName(value, this.ca0, this.ca1);
                    this.push((char)this.owner.addQName(this.ca0, this.ca1));
                } else if (name.equals("minOccurs")) {
                    this.push('\u00cd');
                    v = (char)this.np.parseInteger(value);
                    if (!this.np.ok()) {
                        this.owner.getErrorHandler().error(-1, "Attribute 'minoccurs' must be an int.");
                    }
                    this.push(v);
                } else if (name.equals("maxOccurs")) {
                    this.push('\u00ce');
                    if (value.equals("unbounded")) {
                        v = '\u7fff';
                    } else {
                        v = (char)this.np.parseInteger(value);
                        if (!this.np.ok()) {
                            this.owner.getErrorHandler().error(-1, "Attribute 'maxoccurs' must either be an int or 'unbounded'.");
                        }
                    }
                    this.push(v);
                } else if (!name.equals("schemaLocation")) {
                    this.owner.getErrorHandler().warning(-1, "Non-schema attributes are ignored, '" + name + "'");
                }
                if (bitsModified) {
                    this.push('\u00c9');
                    this.push(bits);
                }
            }
            ++i;
        }
    }

    private String findValueOf(String attrName, SimpleAttr[] attrs, int nAttrs) {
        int i = 0;
        while (i < nAttrs) {
            if (attrs[i].localName.equals(attrName)) {
                return attrs[i].value;
            }
            ++i;
        }
        return null;
    }

    private void fixParents() {
        char[] code = this.owner.getCode();
        char indexOfRoot = code[2];
        int y = indexOfRoot + '\u0001';
        while (code[y] != '\u0001') {
            this.fixParents(code[y + 1], 0, code);
            y += 2;
        }
    }

    private void fixParents(int p, int pp, char[] code) {
        int y = p + 1;
        while (code[y] != '\u0001') {
            if (code[y] == '\u00c8') {
                this.fixParents(code[y + 1], p, code);
            } else if (code[y] == '\u0104') {
                code[y + 1] = (char)pp;
            }
            y += 2;
        }
    }
}

