/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.generator;

import com.inqmy.lib.schema.Schema;
import java.io.File;
import java.io.FileInputStream;

public final class CommandLine {
    private static void printUsage() {
        System.out.println("InQMy Schema-to-Java generator, nick_nickolov@yahoo.com");
        System.out.println();
        System.out.println("Usage: gen <schema_file> [<output_directory> [<output_package>]]");
        System.out.println();
        System.out.println("        If you do not specify the output directory, it defaults to 'generated'.");
        System.out.println("        So does the package name.");
        System.out.println("        Option -d forces decompilation for debugging on the standard output");
    }

    public static void main(String[] args) throws Exception {
        String packageName;
        File dir;
        int l = args.length;
        if (l == 0 || l > 3) {
            CommandLine.printUsage();
            return;
        }
        boolean bDecompile = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-d")) {
                System.arraycopy(args, i + 1, args, i, --l - i);
                bDecompile = true;
                break;
            }
            ++i;
        }
        String a0 = args[0];
        if (!new File(args[0]).exists()) {
            args[0] = a0 + ".schema";
        }
        if (!new File(args[0]).exists()) {
            args[0] = a0 + ".xsd";
        }
        if (!new File(args[0]).exists()) {
            throw new Exception("File not found: '" + args[0] + "'");
        }
        if (l == 1) {
            dir = new File(new File(args[0]).getParentFile(), "gen");
            packageName = "gen";
        } else if (l == 2) {
            dir = new File(args[1]);
            packageName = null;
        } else {
            dir = new File(args[1]);
            packageName = args[2];
        }
        dir.mkdirs();
        Schema schema = new Schema();
        schema.loadRaw(new FileInputStream(args[0]));
        if (bDecompile) {
            schema.decompile();
        }
        schema.generateAll(dir, packageName);
    }
}

