/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.builtin;

import com.inqmy.lib.schema.SchemaException;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public final class Base64 {
    private static final char[] INT_TO_BASE64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int[] BASE64_TO_INT = new int[256];
    private static final boolean USE_BEAUTIFYING = true;
    private static final int GROUPS_PER_LINE = 14;
    private static final boolean USE_LINE_BREAKS = true;
    private static final char GROUP_SEPARATOR = '-';
    private static final boolean USE_GROUP_SEPARATOR = true;

    private Base64() {
    }

    private static void beautify(StringBuffer buffer, int nGroups) {
        if (nGroups >= 14) {
            buffer.append('\r');
            buffer.append('\n');
        } else {
            buffer.append('-');
        }
    }

    public static String encode(byte[] a, int start, int end) {
        int b1;
        int b0;
        if (a == null || start > end || start < 0 || end > a.length) {
            throw new IllegalArgumentException();
        }
        StringBuffer buffer = new StringBuffer();
        int end1 = start + (end - start) / 3 * 3;
        int i = start;
        int nGroups = 0;
        while (i < end1) {
            b0 = a[i++] & 0xFF;
            b1 = a[i++] & 0xFF;
            int b2 = a[i++] & 0xFF;
            int p0 = b0 >> 2;
            int p1 = (b0 & 3) << 4 | b1 >> 4;
            int p2 = (b1 & 0xF) << 2 | b2 >> 6;
            int p3 = b2 & 0x3F;
            buffer.append(INT_TO_BASE64[p0]);
            buffer.append(INT_TO_BASE64[p1]);
            buffer.append(INT_TO_BASE64[p2]);
            buffer.append(INT_TO_BASE64[p3]);
            Base64.beautify(buffer, ++nGroups);
            nGroups %= 14;
        }
        switch (end - end1) {
            case 0: {
                break;
            }
            case 1: {
                b0 = a[i++] & 0xFF;
                int p0 = b0 >> 2;
                int p1 = (b0 & 3) << 4;
                buffer.append(INT_TO_BASE64[p0]);
                buffer.append(INT_TO_BASE64[p1]);
                buffer.append('=');
                buffer.append('=');
                break;
            }
            case 2: {
                b0 = a[i++] & 0xFF;
                b1 = a[i++] & 0xFF;
                int p0 = b0 >> 2;
                int p1 = (b0 & 3) << 4 | b1 >> 4;
                int p2 = (b1 & 0xF) << 2;
                buffer.append(INT_TO_BASE64[p0]);
                buffer.append(INT_TO_BASE64[p1]);
                buffer.append(INT_TO_BASE64[p2]);
                buffer.append('=');
                break;
            }
        }
        return buffer.toString();
    }

    public static String encode(byte[] a) {
        return Base64.encode(a, 0, a.length);
    }

    public static byte[] decode(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int ls = s.length();
        int index = 0;
        int x = 0;
        int modulus = 0;
        int expectedPadding = -1;
        while (true) {
            int value;
            if (index >= ls) {
                if (modulus != 0) {
                    throw new SchemaException("Error parsing base64: padding expected");
                }
                return out.toByteArray();
            }
            char ch = s.charAt(index);
            ++index;
            if (expectedPadding != -1) {
                if (ch != '=') {
                    throw new SchemaException("Error parsing base64: padding expected");
                }
                if (--expectedPadding != 0) continue;
                return out.toByteArray();
            }
            if (ch == '=') {
                if (modulus == 0) {
                    return out.toByteArray();
                }
                if (modulus == 1) {
                    throw new SchemaException("Error parsing base64: padding character found at an inappropriate position");
                }
                if (modulus == 2) {
                    if ((x & 0xF) != 0) {
                        throw new SchemaException("Error parsing base64: excessive bits are not zero");
                    }
                    out.write(x >> 4);
                    expectedPadding = 1;
                    continue;
                }
                if ((x & 3) != 0) {
                    throw new SchemaException("Error parsing base64: excessive bits are not zero");
                }
                out.write(x >> 10);
                out.write(x >> 2 & 0xFF);
                return out.toByteArray();
            }
            if (ch < '\u0000' || ch >= '\u0100' || (value = BASE64_TO_INT[ch]) == -1) continue;
            x <<= 6;
            x |= value;
            if (++modulus != 4) continue;
            out.write(x >> 16);
            out.write(x >> 8 & 0xFF);
            out.write(x & 0xFF);
            modulus = 0;
            x = 0;
        }
    }

    public static void main(String[] args) throws Exception {
        byte[] a = new byte[41];
        int i = 0;
        while (i < a.length) {
            a[i] = (byte)Math.floor(Math.random() * 256.0);
            ++i;
        }
        System.out.println(Base64.encode(a));
        byte[] b = Base64.decode(Base64.encode(a));
        System.out.println(Base64.encode(b));
    }

    static {
        Arrays.fill(BASE64_TO_INT, -1);
        int i = 0;
        while (i < INT_TO_BASE64.length) {
            Base64.BASE64_TO_INT[Base64.INT_TO_BASE64[i]] = i;
            ++i;
        }
    }
}

