/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.license;

import com.tssap.selena.license.ILicenseSupplier;
import com.tssap.selena.license.ILicenseSupplierUI;
import com.tssap.selena.license.Messages;
import com.tssap.selena.license.UnaryOperation;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CommonLicense
extends AbstractUIPlugin {
    private static CommonLicense plugin;
    private static final String SUPPLIER_EXTENSION_POINT_ID = "licenseSuppliers";
    private static final String SUPPLIER_EXTENSION_TAG = "supplier";
    private static final String SUPPLIER_EXTENSION_UI_TAG = "supplierUI";
    private static HashMap mySuppliersMap;
    private static ILicenseSupplier myCurrentSupplier;
    private static boolean parsed;

    public CommonLicense(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static CommonLicense getDefault() {
        return plugin;
    }

    public static boolean isFeatureAvailable(String domain, String feature, UnaryOperation function) {
        if (!parsed) {
            CommonLicense.parseSuppliers();
        }
        if (mySuppliersMap.size() > 1 && CommonLicense.checkFeature(domain, feature, function, true)) {
            return true;
        }
        return CommonLicense.checkFeature(domain, feature, function, false);
    }

    private static final boolean checkFeature(String domain, String feature, UnaryOperation function, boolean silent) {
        Iterator suppliers = mySuppliersMap.keySet().iterator();
        while (suppliers.hasNext()) {
            String code;
            ILicenseSupplier next = (ILicenseSupplier)suppliers.next();
            String result = next.checkFeatureAvailable(domain, feature, code = CommonLicense.generateCode(), silent);
            if (result == null || !result.equals(function.execute(code))) continue;
            myCurrentSupplier = next;
            return true;
        }
        return false;
    }

    public static void showLimitedMessage(String feature) {
        CommonLicense.getSupplierUI().showLimitedMessage(feature);
    }

    public static void createLimitedPane(Composite parent, String feature) {
        CommonLicense.getSupplierUI().createLimitedPane(parent, feature);
    }

    private static void parseSuppliers() {
        IExtensionPoint supplierExtPoint = CommonLicense.getDefault().getDescriptor().getExtensionPoint(SUPPLIER_EXTENSION_POINT_ID);
        IExtension[] extensions = supplierExtPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            ILicenseSupplier nextSupplier = null;
            ILicenseSupplierUI nextUI = null;
            int j = 0;
            while (j < elements.length) {
                block11: {
                    IConfigurationElement configElement;
                    block10: {
                        configElement = elements[j];
                        if (SUPPLIER_EXTENSION_TAG.equals(configElement.getName())) {
                            try {
                                Object supplier = configElement.createExecutableExtension("class");
                                if (!(supplier instanceof ILicenseSupplier)) break block10;
                                nextSupplier = (ILicenseSupplier)supplier;
                            }
                            catch (Throwable e) {
                                break block11;
                            }
                        }
                    }
                    if (SUPPLIER_EXTENSION_UI_TAG.equals(configElement.getName())) {
                        try {
                            Object supplierUI = configElement.createExecutableExtension("class");
                            if (supplierUI instanceof ILicenseSupplierUI) {
                                nextUI = (ILicenseSupplierUI)supplierUI;
                            }
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                }
                ++j;
            }
            if (nextSupplier != null) {
                mySuppliersMap.put(nextSupplier, nextUI);
            }
            ++i;
        }
        parsed = true;
    }

    private static ILicenseSupplierUI getSupplierUI() {
        ILicenseSupplierUI ui = null;
        if (myCurrentSupplier != null) {
            ui = (ILicenseSupplierUI)mySuppliersMap.get(myCurrentSupplier);
        }
        if (ui == null) {
            ui = CommonLicense.getDefault().new DefaultLicenseSupplierUI();
        }
        return ui;
    }

    private static String generateCode() {
        return "random string";
    }

    static {
        mySuppliersMap = new HashMap();
        myCurrentSupplier = null;
        parsed = false;
    }

    private class DefaultLicenseSupplierUI
    implements ILicenseSupplierUI {
        private DefaultLicenseSupplierUI() {
        }

        public void showLimitedMessage(String feature) {
            MessageDialog dlg = new MessageDialog(Display.getCurrent().getActiveShell(), Messages.getString("License_9"), null, this.getMessage(feature), 1, new String[]{Messages.getString("OK_10")}, 0);
            dlg.open();
        }

        public void createLimitedPane(Composite parent, String feature) {
            Label label = new Label(parent, 0x1000000);
            label.setText(this.getMessage(feature));
        }

        private String getMessage(String feature) {
            if ("XJ".equals(feature)) {
                feature = "";
            }
            return MessageFormat.format(Messages.getString("Feature_not_available"), feature);
        }
    }
}

