/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.viewmanagement.preferences;

import com.togethersoft.selena.viewmanagement.preferences.Messages;
import com.togethersoft.selena.viewmanagement.preferences.UpdatablePreferencePage;
import com.tssap.selena.model.preferences.PreferencesPlugin;
import com.tssap.selena.ui.prefpages.ExtendedBooleanFieldEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ViewManagementPreferencePage
extends UpdatablePreferencePage
implements IWorkbenchPreferencePage {
    public static final String P_ALL_PACKAGES = "AllPackages";
    public static final String P_ALL_CLASSES = "AllClasses";
    public static final String P_ALL_INTERFACES = "AllInterfaces";
    public static final String P_NON_PUBLIC_CLASSES = "NonPublicClasses";
    public static final String P_ALL_ATTRIBUTES = "AllAttributes";
    public static final String P_ALL_OPERATIONS = "AllOperations";
    public static final String P_ALL_MEMBERS = "AllMembers";
    public static final String P_ALL_NON_PUBLIC_MEMBERS = "AllNonPublicMembers";
    public static final String P_ASSOCIATIONS = "Associations";
    public static final String P_INHERITANCES = "Inheritances";
    public static final String P_DEPENDENCIES = "Dependencies";
    public static final String P_PATTERN_NODES = "Pattern nodes";
    public static final String P_NOTES = "Notes";
    public static final String P_HIDDEN_BY_TAG = "HiddenByTag";
    public static final String P_PATTERN_PARTICIPANTS = "Pattern participants";
    public static final String P_PATTERN_LINKS = "Pattern links";
    private BooleanFieldEditor allClasses;
    private BooleanFieldEditor allPackages;
    private BooleanFieldEditor allInterfaces;
    private ExtendedBooleanFieldEditor allNonPublicClasses;
    private ExtendedBooleanFieldEditor allMembers;
    private ExtendedBooleanFieldEditor allAttributes;
    private ExtendedBooleanFieldEditor allOperations;
    private ExtendedBooleanFieldEditor allNonPublicMembers;
    private ExtendedBooleanFieldEditor associations;
    private ExtendedBooleanFieldEditor inheritance;
    private ExtendedBooleanFieldEditor dependencies;
    private ExtendedBooleanFieldEditor patternNodes;
    private ExtendedBooleanFieldEditor patternParticipants;
    private ExtendedBooleanFieldEditor patternLinks;
    private ExtendedBooleanFieldEditor notes;

    public ViewManagementPreferencePage() {
        super(1);
        this.setPreferenceStore(PreferencesPlugin.getPreferenceStore((String)"workspace", null));
        this.setDescription(Messages.getString("ViewManagementPreferencePage.description"));
        this.initDefaults();
    }

    protected void initDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        if (iPreferenceStore != null) {
            iPreferenceStore.setDefault(P_ALL_PACKAGES, true);
            iPreferenceStore.setDefault(P_ALL_CLASSES, true);
            iPreferenceStore.setDefault(P_ALL_INTERFACES, true);
            iPreferenceStore.setDefault(P_NON_PUBLIC_CLASSES, true);
            iPreferenceStore.setDefault(P_ALL_ATTRIBUTES, true);
            iPreferenceStore.setDefault(P_ALL_OPERATIONS, true);
            iPreferenceStore.setDefault(P_ALL_MEMBERS, true);
            iPreferenceStore.setDefault(P_ALL_NON_PUBLIC_MEMBERS, true);
            iPreferenceStore.setDefault(P_ASSOCIATIONS, true);
            iPreferenceStore.setDefault(P_INHERITANCES, true);
            iPreferenceStore.setDefault(P_DEPENDENCIES, true);
            iPreferenceStore.setDefault(P_PATTERN_NODES, true);
            iPreferenceStore.setDefault(P_NOTES, true);
            iPreferenceStore.setDefault(P_HIDDEN_BY_TAG, false);
            iPreferenceStore.setDefault(P_PATTERN_PARTICIPANTS, true);
            iPreferenceStore.setDefault(P_PATTERN_LINKS, true);
        }
    }

    private Composite createGroup(Composite composite, String string) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        group.setText(string);
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        return composite2;
    }

    private void setCompositeLayout(Composite composite, int n) {
        GridLayout gridLayout = new GridLayout(n, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
    }

    public void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        Composite composite2 = this.createGroup(composite, Messages.getString("ViewManagementPreferencePage.Elements"));
        this.allPackages = new BooleanFieldEditor(P_ALL_PACKAGES, Messages.getString("ViewManagementPreferencePage.All_Packages"), composite2);
        this.addField((FieldEditor)this.allPackages);
        this.notes = new ExtendedBooleanFieldEditor(P_NOTES, Messages.getString("ViewManagementPreferencePage.Notes"), composite2);
        this.addField((FieldEditor)this.notes);
        this.allInterfaces = new BooleanFieldEditor(P_ALL_INTERFACES, Messages.getString("ViewManagementPreferencePage.All_Interfaces"), composite2);
        this.addField((FieldEditor)this.allInterfaces);
        BooleanFieldEditor booleanFieldEditor = new BooleanFieldEditor(P_HIDDEN_BY_TAG, Messages.getString("ViewManagementPreferencePage.Hidden_elements"), composite2);
        this.addField((FieldEditor)booleanFieldEditor);
        this.allClasses = new BooleanFieldEditor(P_ALL_CLASSES, Messages.getString("ViewManagementPreferencePage.All_Classes"), composite2);
        this.addField((FieldEditor)this.allClasses);
        this.allNonPublicClasses = new ExtendedBooleanFieldEditor(P_NON_PUBLIC_CLASSES, Messages.getString("ViewManagementPreferencePage.All_Non-public_classes"), composite2);
        this.addField((FieldEditor)this.allNonPublicClasses);
        this.setCompositeLayout(composite2, 2);
        Composite composite3 = this.createGroup(composite, Messages.getString("ViewManagementPreferencePage.Members"));
        this.allMembers = new ExtendedBooleanFieldEditor(P_ALL_MEMBERS, Messages.getString("ViewManagementPreferencePage.All_Members"), composite3);
        this.addField((FieldEditor)this.allMembers);
        this.allAttributes = new ExtendedBooleanFieldEditor(P_ALL_ATTRIBUTES, Messages.getString("ViewManagementPreferencePage.All_Attributes"), composite3);
        this.addField((FieldEditor)this.allAttributes);
        this.allOperations = new ExtendedBooleanFieldEditor(P_ALL_OPERATIONS, Messages.getString("ViewManagementPreferencePage.All_Operations"), composite3);
        this.addField((FieldEditor)this.allOperations);
        this.allNonPublicMembers = new ExtendedBooleanFieldEditor(P_ALL_NON_PUBLIC_MEMBERS, Messages.getString("ViewManagementPreferencePage.All_Non-public_Members"), composite3);
        this.addField((FieldEditor)this.allNonPublicMembers);
        this.setCompositeLayout(composite3, 2);
        Composite composite4 = this.createGroup(composite, Messages.getString("ViewManagementPreferencePage.Links"));
        this.associations = new ExtendedBooleanFieldEditor(P_ASSOCIATIONS, Messages.getString("ViewManagementPreferencePage.Associations"), composite4);
        this.addField((FieldEditor)this.associations);
        this.inheritance = new ExtendedBooleanFieldEditor(P_INHERITANCES, Messages.getString("ViewManagementPreferencePage.Inheritance"), composite4);
        this.addField((FieldEditor)this.inheritance);
        this.dependencies = new ExtendedBooleanFieldEditor(P_DEPENDENCIES, Messages.getString("ViewManagementPreferencePage.Dependencies"), composite4);
        this.addField((FieldEditor)this.dependencies);
        this.setCompositeLayout(composite4, 3);
        Composite composite5 = this.createGroup(composite, Messages.getString("ViewManagementPreferencePage.Patterns"));
        this.patternNodes = new ExtendedBooleanFieldEditor(P_PATTERN_NODES, Messages.getString("ViewManagementPreferencePage.Pattern_nodes"), composite5);
        this.addField((FieldEditor)this.patternNodes);
        this.patternParticipants = new ExtendedBooleanFieldEditor(P_PATTERN_PARTICIPANTS, Messages.getString("ViewManagementPreferencePage.Pattern_participants"), composite5);
        this.addField((FieldEditor)this.patternParticipants);
        this.patternLinks = new ExtendedBooleanFieldEditor(P_PATTERN_LINKS, Messages.getString("ViewManagementPreferencePage.Pattern_links"), composite5);
        this.addField((FieldEditor)this.patternLinks);
        this.setCompositeLayout(composite5, 2);
    }

    public void init(IWorkbench iWorkbench) {
    }

    public boolean performOk() {
        boolean bl = super.performOk();
        this.update();
        return bl;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getSource().equals(this.allMembers)) {
            this.updateMemberEditors();
        } else if (propertyChangeEvent.getSource().equals(this.patternParticipants)) {
            this.updatePatternsEditors();
        } else if (propertyChangeEvent.getSource().equals(this.allInterfaces)) {
            this.updateClassEditors();
            this.updateMemberEditors();
            this.updateLinksEditors();
            this.updatePatternsEditors();
        } else if (propertyChangeEvent.getSource().equals(this.allClasses)) {
            this.updateClassEditors();
            this.updateMemberEditors();
            this.updateLinksEditors();
            this.updatePatternsEditors();
        }
        this.setOptionsChanged(true);
        this.checkForErrors();
    }

    protected void initialize() {
        super.initialize();
        this.updateClassEditors();
        this.updateMemberEditors();
        this.updateLinksEditors();
        this.updatePatternsEditors();
        this.setOptionsChanged(false);
    }

    private void updateClassEditors() {
        boolean bl = this.allClasses.getBooleanValue() || this.allInterfaces.getBooleanValue();
        this.allNonPublicClasses.setEnabled(bl);
    }

    private void updateMemberEditors() {
        boolean bl = this.allClasses.getBooleanValue() || this.allInterfaces.getBooleanValue();
        this.allMembers.setEnabled(bl);
        boolean bl2 = this.allMembers.getBooleanValue();
        this.allAttributes.setEnabled(bl2);
        this.allOperations.setEnabled(bl2);
        this.allNonPublicMembers.setEnabled(bl2);
    }

    private void updateLinksEditors() {
        boolean bl = this.allClasses.getBooleanValue() || this.allInterfaces.getBooleanValue();
        this.associations.setEnabled(bl);
        this.inheritance.setEnabled(bl);
        this.dependencies.setEnabled(bl);
    }

    private void updatePatternsEditors() {
        boolean bl = this.allClasses.getBooleanValue() || this.allInterfaces.getBooleanValue();
        this.patternParticipants.setEnabled(bl);
        this.patternLinks.setEnabled(this.patternParticipants.getBooleanValue());
    }

    private void checkForErrors() {
        boolean bl;
        boolean bl2 = bl = this.allClasses.getBooleanValue() || this.allPackages.getBooleanValue() || this.allInterfaces.getBooleanValue() || this.patternNodes.getBooleanValue() || this.notes.getBooleanValue();
        if (bl) {
            this.setErrorMessage(null);
            this.setValid(true);
        } else {
            this.setErrorMessage(Messages.getString("ViewManagementPreferencePage.EmptyDiagramError"));
            this.setValid(false);
        }
    }

    public void performDefaults() {
        super.performDefaults();
        this.initialize();
    }
}

