/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.wsdlImpl.extensions.soap;

import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.wsdlImpl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.soap.SOAPBinding;
import org.w3c.dom.Element;

public class SOAPBindingSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public void marshall(Class parentType, javax.wsdl.QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        SOAPBinding soapBinding = (SOAPBinding)extension;
        if (soapBinding != null) {
            String tagName = DOMUtils.getQualifiedValue((String)"http://schemas.xmlsoap.org/wsdl/soap/", (String)"binding", (Definition)def);
            pw.print("    <" + tagName);
            DOMUtils.printAttribute((String)"style", (String)soapBinding.getStyle(), (PrintWriter)pw);
            DOMUtils.printAttribute((String)"transport", (String)soapBinding.getTransportURI(), (PrintWriter)pw);
            Boolean required = soapBinding.getRequired();
            if (required != null) {
                DOMUtils.printQualifiedAttribute((QName)ISOAPParamConstants.Q_ATTR_REQUIRED, (String)required.toString(), (Definition)def, (PrintWriter)pw);
            }
            pw.println("/>");
        }
    }

    public ExtensibilityElement unmarshall(Class parentType, javax.wsdl.QName elementType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        SOAPBinding soapBinding = (SOAPBinding)extReg.createExtension(parentType, elementType);
        String transportURI = DOMUtils.getAttribute((Element)el, (String)"transport");
        String style = DOMUtils.getAttribute((Element)el, (String)"style");
        String requiredStr = DOMUtils.getAttributeNS((Element)el, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"required");
        if (transportURI != null) {
            soapBinding.setTransportURI(transportURI);
        }
        if (style != null) {
            soapBinding.setStyle(style);
        }
        if (requiredStr != null) {
            soapBinding.setRequired(Boolean.valueOf(requiredStr));
        }
        return soapBinding;
    }
}

