/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.wsdl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.wsdl.Definition;

public class NameSpaces
extends HashMap {
    private HashMap mm_namespacePrefixMap = null;
    private HashMap mm_namespaceMapPrefix = null;
    private int mm_prefixCount = 0;
    private String mm_protocol = "http";

    public NameSpaces() {
        this.mm_namespacePrefixMap = new HashMap();
        this.mm_namespaceMapPrefix = new HashMap();
    }

    public NameSpaces(String protocol) {
        this.mm_protocol = protocol;
        this.mm_namespacePrefixMap = new HashMap();
    }

    public String getCreate(String key, String protocol) {
        Object value = super.get(key);
        if (value == null) {
            value = NameSpaces.createNamespaceFromPackageName(key, protocol);
            this.put(key, value, null);
        }
        return (String)value;
    }

    public String getCreate(String key) {
        Object value = super.get(key);
        if (value == null) {
            value = NameSpaces.createNamespaceFromPackageName(key, this.mm_protocol);
            this.put(key, value, null);
        }
        return (String)value;
    }

    public String getCreate(String key, String prefix, String protocol) {
        Object value = super.get(key);
        if (value == null) {
            value = NameSpaces.createNamespaceFromPackageName(key, protocol == null ? this.mm_protocol : protocol);
            this.put(key, value, prefix);
        }
        return (String)value;
    }

    public String getCreatePrefix(String namespace) {
        if (this.mm_namespacePrefixMap.get(namespace) == null) {
            this.mm_namespacePrefixMap.put(namespace, "tns" + this.mm_prefixCount);
            if (this.mm_namespaceMapPrefix.get("tns" + this.mm_prefixCount) == null) {
                this.mm_namespaceMapPrefix.put("tns" + this.mm_prefixCount, namespace);
            }
            ++this.mm_prefixCount;
        }
        return (String)this.mm_namespacePrefixMap.get(namespace);
    }

    public String getPrefix(String namespace) {
        if (namespace == null) {
            return null;
        }
        return (String)this.mm_namespacePrefixMap.get(namespace);
    }

    public String getNameSpace(String prefix) {
        if (prefix == null) {
            return null;
        }
        return (String)this.mm_namespaceMapPrefix.get(prefix);
    }

    public String getCreatePrefix(String namespace, Definition def) {
        if (def == null) {
            if (this.mm_namespacePrefixMap.get(namespace) == null) {
                int i = (int)(Math.random() * 10000.0);
                this.mm_namespacePrefixMap.put(namespace, "tns__" + i);
            }
        } else {
            int i = 0;
            while (i < 255) {
                if (def.getNamespace("tns" + i) == null) {
                    this.mm_prefixCount = i;
                    this.mm_namespacePrefixMap.put(namespace, "tns" + this.mm_prefixCount++);
                    break;
                }
                ++i;
            }
        }
        return (String)this.mm_namespacePrefixMap.get(namespace);
    }

    public static String createNamespace(String clsName, String protocol) {
        if (clsName.lastIndexOf(46) == -1) {
            return protocol + "://" + "DefaultNamespace";
        }
        String packageName = clsName.substring(0, clsName.lastIndexOf(46));
        return NameSpaces.createNamespaceFromPackageName(packageName, protocol);
    }

    public Object put(Object key, Object value, String prefix) {
        if (prefix != null) {
            this.mm_namespacePrefixMap.put(value, prefix);
        } else {
            this.getCreatePrefix((String)value);
        }
        return super.put(key, value);
    }

    public void putAll(Map map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            String namespace = (String)map.get(key);
            this.put(key, namespace, null);
        }
    }

    public void putAllPrefix(Map map) {
        Iterator i = this.mm_namespacePrefixMap.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            String prefix = (String)map.get(key);
            this.put(key, prefix);
        }
    }

    public void putPrefix(String namespace, String prefix) {
        this.mm_namespacePrefixMap.put(namespace, prefix);
        this.mm_namespaceMapPrefix.put(prefix, namespace);
    }

    private static String createNamespaceFromPackageName(String packageName, String protocol) {
        if (packageName.equals("") || packageName == null) {
            return protocol + "://" + "DefaultNamespace";
        }
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String[] words = new String[st.countTokens()];
        int i = 0;
        while (i < words.length) {
            words[i] = st.nextToken();
            ++i;
        }
        StringBuffer sb = new StringBuffer(80);
        int i2 = words.length - 1;
        while (i2 >= 0) {
            String word = words[i2];
            if (i2 != words.length - 1) {
                sb.append('.');
            }
            sb.append(word);
            --i2;
        }
        return protocol + "://" + sb.toString();
    }

    public Map getNamespacePrefixMap() {
        return this.mm_namespacePrefixMap;
    }
}

