/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.wsdl;

import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;
import com.sapportals.portal.prt.service.soap.mapping.InitMapping;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import com.sapportals.portal.prt.service.soap.util.XMLAttributeHandler;
import com.sapportals.portal.prt.service.soap.util.XMLValueEncoder;
import com.sapportals.portal.prt.service.soap.webserviceconfig.IPortalSOAPConfig;
import com.sapportals.portal.prt.service.soap.webserviceconfig.PortalSOAPConfigFactory;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebService;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceMethod;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceParameter;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceSerializer;
import com.sapportals.portal.prt.service.soap.wsdl.ComplexType;
import com.sapportals.portal.prt.service.soap.wsdl.CustomException;
import com.sapportals.portal.prt.service.soap.wsdl.CustomSerializer;
import com.sapportals.portal.prt.service.soap.wsdl.InformationReport;
import com.sapportals.portal.prt.service.soap.wsdl.JavaToWsdl;
import com.sapportals.portal.prt.service.soap.wsdl.NameSpaces;
import com.sapportals.portal.prt.service.soap.wsdl.ObjectSchema;
import com.sapportals.portal.prt.service.soap.wsdl.WSDLConstants;
import com.sapportals.portal.prt.service.soap.wsdl.WsdlNode;
import com.sapportals.portal.prt.service.soap.wsdlImpl.util.xml.DOMUtils;
import com.sapportals.portal.prt.service.soap.wsdlImpl.xml.WSDLReaderImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.QName;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GenerateServiceFromWsdl
implements WSDLConstants {
    private Vector mm_complexTypeCurrentProcessing = new Vector();
    public static Vector REPORT_GENERATION = new Vector();
    private IPortalSOAPConfig mm_soapconfig = null;
    private IPortalWebService mm_webserviceconfig = null;
    private InputStream mm_inWsdl = null;
    private String mm_nameInterface = null;
    private String mm_namePackage = null;
    private String mm_pathPackage = null;
    private String mm_nameService = null;
    private PrintWriter mm_out = null;
    private String mm_path = null;
    private boolean mm_serverSideMode = false;
    private String mm_urlwsdl = null;
    private HashMap mm_complexTypes = new HashMap();
    private HashMap mm_customExceptions = new HashMap();
    private Vector mm_methodsAllowedMethods = null;
    private Definition mm_def = null;
    private String mm_projectName = "Default";
    private String mm_alias = null;
    private File mm_soapconfigfile = null;
    private String mm_WSDLFilename = null;
    static /* synthetic */ Class class$javax$wsdl$Port;
    static /* synthetic */ Class class$javax$wsdl$extensions$UnknownExtensibilityElement;

    public GenerateServiceFromWsdl(String path, String urlwsdl) throws Exception {
        this.mm_urlwsdl = urlwsdl;
        this.mm_path = path;
        InitMapping.getInstanceInit(this.getClass().getResourceAsStream("/types/soapTypes.xml"));
        try {
            this.initStreams();
            this.mm_def = new WSDLReaderImpl(null).readWSDL(this.mm_urlwsdl, this.mm_inWsdl);
        }
        catch (Exception ex) {
            this.mm_def = null;
            throw ex;
        }
    }

    public String[] getAllWSDLDocumentURIinclude() {
        Vector<URL> uris = new Vector<URL>();
        URL contextURL = null;
        if (this.mm_def != null) {
            try {
                contextURL = ToolKit.getURL(null, this.mm_def.getDocumentBaseURI());
                uris.add(contextURL);
            }
            catch (MalformedURLException e) {
                contextURL = null;
            }
        } else {
            return null;
        }
        this.getAllURIsfromDefinition(contextURL, uris, this.mm_def);
        String[] aUris = new String[uris.size()];
        int i = 0;
        while (i < uris.size()) {
            aUris[i] = ((URL)uris.get(i)).toString();
            ++i;
        }
        return aUris;
    }

    private void getAllURIsfromDefinition(URL contextURL, Vector uris, Definition def) {
        if (def == null) {
            return;
        }
        Map imports = def.getImports();
        if (imports == null) {
            return;
        }
        Iterator iter = imports.keySet().iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            Vector listImp = (Vector)def.getImports((String)item);
            int i = 0;
            while (i < listImp.size()) {
                Import imp = (Import)listImp.get(i);
                if (imp != null && !uris.contains(imp.getLocationURI())) {
                    try {
                        URL uri = ToolKit.getURL(contextURL, imp.getLocationURI());
                        uris.add(uri);
                        this.getAllURIsfromDefinition(uri, uris, imp.getDefinition());
                    }
                    catch (MalformedURLException e) {
                        REPORT_GENERATION.add(new InformationReport("The URL import include in the wsdl " + contextURL + " is mal formed!", e, 1));
                    }
                }
                ++i;
            }
        }
    }

    public String getWSDLFilename() {
        if (this.mm_WSDLFilename != null) {
            if (this.mm_WSDLFilename.lastIndexOf("/") >= 0) {
                String filename = this.mm_WSDLFilename.substring(this.mm_WSDLFilename.lastIndexOf("/") + 1, this.mm_WSDLFilename.length());
                return filename;
            }
            return null;
        }
        return null;
    }

    public void setWSDLFilename(String filename) {
        this.mm_WSDLFilename = filename;
    }

    public String getPluginWSDLFilename() {
        return this.mm_WSDLFilename;
    }

    public String[] getOperations() {
        if (this.mm_def != null) {
            Vector<String> nameMethods = new Vector<String>();
            Map services = this.mm_def.getServices();
            Iterator iterServices = services.keySet().iterator();
            while (iterServices.hasNext()) {
                Object nameservice = iterServices.next();
                Service service = (Service)services.get(nameservice);
                Map ports = service.getPorts();
                Iterator iterPorts = ports.keySet().iterator();
                while (iterPorts.hasNext()) {
                    Object nameport = iterPorts.next();
                    Port port = (Port)ports.get(nameport);
                    Iterator iterextElments = port.getBinding().getExtensibilityElements().iterator();
                    while (iterextElments.hasNext()) {
                        PortType pt;
                        ExtensibilityElement elem = (ExtensibilityElement)iterextElments.next();
                        if (!"binding".equalsIgnoreCase(elem.getElementType().getLocalPart()) || !"http://schemas.xmlsoap.org/wsdl/soap/".equals(elem.getElementType().getNamespaceURI()) || (pt = port.getBinding().getPortType()) == null) continue;
                        List listoperations = pt.getOperations();
                        Object[] arrayOperations = listoperations.toArray();
                        int i = 0;
                        while (i < arrayOperations.length) {
                            Operation operation = (Operation)arrayOperations[i];
                            nameMethods.add(port.getName() + " / " + operation.getName());
                            ++i;
                        }
                    }
                }
            }
            String[] methods = new String[nameMethods.size()];
            int i = 0;
            while (i < nameMethods.size()) {
                methods[i] = (String)nameMethods.get(i);
                ++i;
            }
            return methods;
        }
        REPORT_GENERATION.add(new InformationReport("No operations found in the wsdl " + this.mm_urlwsdl + " !", null, 1));
        return null;
    }

    public static void main(String[] args) {
        try {
            String outpath = "C:/tmp/tla";
            String url = "file:///c:/Service11.wsdl";
            GenerateServiceFromWsdl gproxy = new GenerateServiceFromWsdl(outpath, url);
            String[] uris = gproxy.getAllWSDLDocumentURIinclude();
            if (uris != null) {
                int i = 0;
                while (i < uris.length) {
                    System.out.println("> " + uris[i]);
                    ++i;
                }
            }
            File f = new File(outpath + "/soapconfig_.xml");
            gproxy.setSoapconfigfile(f);
            gproxy.writeService(null, "com.sap.test.Config", "Alias1", false);
            FileOutputStream fio = new FileOutputStream(f);
            gproxy.getSoapconfig().save((OutputStream)fio);
            fio.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean existsNameService() {
        if (this.mm_def == null) {
            return false;
        }
        return this.mm_def.getQName() != null;
    }

    public void writeService() throws Exception {
        this.writeService(false);
    }

    public void writeService(boolean templatemode) throws Exception {
        this.writeService(null, templatemode);
    }

    public void writeService(Vector methods, boolean templatemode) throws Exception {
        this.writeService(methods, null, templatemode);
    }

    public void writeService(Vector methods) throws Exception {
        this.writeService(methods, null, false);
    }

    public HashMap getComplexTypes() {
        return this.mm_complexTypes;
    }

    public void writeService(Vector methods, String NameServiceOveride) throws Exception {
        this.writeService(methods, NameServiceOveride, false);
    }

    public void writeService(Vector methods, String NameServiceOveride, boolean templatemode) throws Exception {
        this.writeService(methods, NameServiceOveride, null, templatemode);
    }

    public void writeConfigSerializers(Hashtable cslist) {
        if (this.mm_webserviceconfig != null && cslist != null) {
            Iterator iter = cslist.values().iterator();
            while (iter.hasNext()) {
                CustomSerializer cs = (CustomSerializer)iter.next();
                IPortalWebServiceSerializer ser = this.mm_webserviceconfig.createPortalWebServiceSerializer(cs.getNameSerializer());
                ser.setJavatype(cs.getJavaType().getName());
                ser.setLocalpart(cs.getLocalpart());
                ser.setNamespace(cs.getNameSpace());
                ser.setSerializer(cs.getLocalpartSerWithPackage());
            }
        } else {
            REPORT_GENERATION.add(new InformationReport("Impossible to write the Webservice Serializers because the soapconfig.xml is not found!", null, 1));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeService(Vector methods, String NameServiceOveride, String alias, boolean serverSideMode) throws Exception {
        this.mm_serverSideMode = serverSideMode;
        this.mm_alias = alias;
        this.mm_methodsAllowedMethods = methods;
        try {
            try {
                File srcapi;
                if (this.mm_def == null) {
                    REPORT_GENERATION.add(new InformationReport("Cannot be read the WSDL Definition '" + this.mm_urlwsdl + "!", null, 1));
                    throw new Exception("Cannot read the wsdl file!");
                }
                this.initSOAPConfigFile(this.mm_soapconfigfile);
                if (this.mm_def.getQName() != null && NameServiceOveride == null) {
                    int i = this.mm_def.getQName().getLocalPart().indexOf(":");
                    this.mm_nameService = i >= 0 ? this.mm_def.getQName().getLocalPart().substring(i + 1) : this.mm_def.getQName().getLocalPart();
                    i = this.mm_nameService.lastIndexOf(".");
                    if (i >= 0) {
                        this.mm_nameService = this.mm_nameService.substring(i + 1);
                    }
                } else if (NameServiceOveride != null) {
                    this.mm_nameService = ToolKit.toUpperFirstChar(NameServiceOveride);
                } else {
                    REPORT_GENERATION.add(new InformationReport("The alias name is empty, the plugin use the default value!", null, 0));
                    this.mm_nameService = "DefaultService";
                }
                this.mm_nameService = ToolKit.normalizeJavaName(this.mm_nameService);
                this.mm_nameInterface = "I" + ToolKit.toUpperFirstChar(this.mm_nameService);
                if (this.mm_namePackage == null) {
                    this.mm_namePackage = "com.sap.portal.prt.webservice." + this.mm_nameService;
                    this.mm_pathPackage = "com/sap/portal/prt/webservice/" + this.mm_nameService;
                }
                if (!(srcapi = new File(this.mm_path + File.separator + "src.api" + File.separator + this.mm_pathPackage)).exists()) {
                    srcapi.mkdirs();
                }
                this.mm_out = new PrintWriter(new FileWriter(srcapi.getPath() + File.separator + this.mm_nameInterface + ".java"));
                this.writeInterfaceOfService(this.mm_nameInterface, this.mm_namePackage, alias != null ? alias : this.mm_nameService, this.mm_out);
                this.mm_out.close();
                File srccore = new File(this.mm_path + File.separator + "src.core" + File.separator + this.mm_pathPackage);
                if (!srccore.exists()) {
                    srccore.mkdirs();
                }
                this.mm_out = new PrintWriter(new FileWriter(srccore.getPath() + File.separator + this.mm_nameService + ".java"));
                if (this.mm_namePackage != null && this.mm_namePackage.length() > 0) {
                    this.mm_out.println("package " + this.mm_namePackage + ";");
                }
                this.writeImport(this.mm_out);
                this.writeClass(this.mm_out);
                this.writeConstants(this.mm_out);
                this.writeFields(this.mm_out, this.mm_def);
                this.writeTemplatePRTService(this.mm_out);
                this.writeMethods(this.mm_out, this.mm_def, false);
                this.mm_out.println("}");
            }
            catch (Exception ex) {
                REPORT_GENERATION.add(new InformationReport("Error during the generation of Java files !", ex, 1));
                if (this.mm_out != null) {
                    this.mm_out.close();
                }
                if (this.mm_inWsdl == null) throw ex;
                this.mm_inWsdl.close();
                throw ex;
            }
            Object var8_9 = null;
            if (this.mm_out != null) {
                this.mm_out.close();
            }
            if (this.mm_inWsdl == null) return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (this.mm_out != null) {
                this.mm_out.close();
            }
            if (this.mm_inWsdl == null) throw throwable;
            this.mm_inWsdl.close();
            throw throwable;
        }
        this.mm_inWsdl.close();
    }

    public ObjectSchema getTypeJava(String prefix, String nameType) throws Exception {
        if (this.mm_def != null) {
            QName qn = new QName(ToolKit.getNameSpaceInWSDLWithImportInclude(this.mm_def, prefix != null ? prefix : ""), nameType);
            return this.getTypeJava(qn, this.mm_def);
        }
        REPORT_GENERATION.add(new InformationReport("the Defintion of the wsdl " + this.mm_urlwsdl + " is empty!", null, 1));
        return null;
    }

    public ObjectSchema getTypeJava(String prefix, String nameType, NameSpaces nsobj, boolean mm_writeAuth) throws Exception {
        if (this.mm_def != null) {
            QName qn = null;
            if (nsobj.getNameSpace(prefix) != null) {
                qn = new QName(nsobj.getNameSpace(prefix), nameType);
            } else if (this.mm_def.getNamespace(prefix) != null) {
                qn = new QName(this.mm_def.getNamespace(prefix), nameType);
            } else if (ToolKit.getNameSpaceInWSDLWithImportInclude(this.mm_def, prefix) != null) {
                qn = new QName(ToolKit.getNameSpaceInWSDLWithImportInclude(this.mm_def, prefix), nameType);
            } else {
                return null;
            }
            return this.getTypeJava(qn, this.mm_def, mm_writeAuth);
        }
        REPORT_GENERATION.add(new InformationReport("the Defintion of the wsdl " + this.mm_urlwsdl + " is empty!", null, 1));
        return null;
    }

    public static boolean isArrayList(Node xmldef) {
        if (xmldef == null) {
            return false;
        }
        NamedNodeMap attrs = xmldef.getAttributes();
        Node arrayattr = attrs.getNamedItem("maxOccurs");
        if (arrayattr != null) {
            String value_maxOccurs = arrayattr.getNodeValue();
            if (value_maxOccurs.equals("unbounded")) {
                return true;
            }
            try {
                int max_int = Integer.parseInt(value_maxOccurs);
                if (max_int > 1) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                REPORT_GENERATION.add(new InformationReport("Illegal value in the tag maxoccurs !", e, 1));
            }
        }
        return false;
    }

    public static boolean isArrayRPC(Node xmldef) {
        if (xmldef == null) {
            return false;
        }
        if (xmldef.hasChildNodes()) {
            NodeList nodes = xmldef.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 1 && ((Element)node).getLocalName().indexOf("complexContent") != -1 && node.hasChildNodes()) {
                    NodeList subnodes = node.getChildNodes();
                    int j = 0;
                    while (j < subnodes.getLength()) {
                        NamedNodeMap attrs;
                        Node arrayattr;
                        Node subnode = subnodes.item(j);
                        if (subnode.getNodeType() == 1 && ((Element)subnode).getLocalName().indexOf("restriction") != -1 && (arrayattr = (attrs = subnode.getAttributes()).getNamedItem("base")) != null && arrayattr.getNodeValue().indexOf("Array") != -1) {
                            return true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static String typeArray2D(Node xmldef_) {
        if (xmldef_ == null) {
            return null;
        }
        if (!(xmldef_ instanceof Element)) {
            return null;
        }
        Element xmldef = (Element)xmldef_;
        NodeList listattr = xmldef.getElementsByTagName("element");
        if (listattr.getLength() != 2) {
            return null;
        }
        Element el = null;
        el = (Element)listattr.item(0);
        if (el.getElementsByTagName("element").getLength() == 1) {
            if (!el.getElementsByTagName("element").item(0).equals((Element)listattr.item(1))) {
                return null;
            }
        } else {
            return null;
        }
        if (el == null) {
            return null;
        }
        String value_maxOccurs = DOMUtils.getAttribute((Element)el, (String)"maxOccurs");
        if (value_maxOccurs != null) {
            Element el2;
            String value_maxOccurs2;
            boolean firstDimension = false;
            if (value_maxOccurs.equals("unbounded")) {
                firstDimension = true;
            } else {
                try {
                    int max_int = Integer.parseInt(value_maxOccurs);
                    if (max_int > 1) {
                        firstDimension = true;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (firstDimension && (value_maxOccurs2 = DOMUtils.getAttribute((Element)(el2 = (Element)listattr.item(1)), (String)"maxOccurs")) != null) {
                boolean twoDimension = false;
                if (value_maxOccurs2.equals("unbounded")) {
                    twoDimension = true;
                } else {
                    try {
                        int max_int = Integer.parseInt(value_maxOccurs2);
                        if (max_int > 1) {
                            twoDimension = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (twoDimension) {
                    String type = DOMUtils.getAttribute((Element)el2, (String)"type");
                    if (type.length() <= 1) {
                        return null;
                    }
                    return type;
                }
            }
        }
        return null;
    }

    public ObjectSchema getTypeJava(QName qwsdlorig, Definition wsdldoc) throws Exception {
        ObjectSchema o = this.getTypeJava(qwsdlorig, wsdldoc, true);
        return o;
    }

    public ObjectSchema getTypeJava(QName qwsdlorig, Definition wsdldoc, boolean writeEnable) throws Exception {
        Types types = wsdldoc.getTypes();
        QName qwsdl = qwsdlorig;
        if (qwsdl.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
            qwsdl.setNamespaceURI("http://www.w3.org/2001/XMLSchema");
        }
        SOAPRegistry namep = SOAPRegistry.getInstance();
        if ("http://schemas.xmlsoap.org/soap/encoding/".equals(qwsdl.getNamespaceURI())) {
            qwsdl.setNamespaceURI("http://www.w3.org/2001/XMLSchema");
        }
        com.sapportals.portal.prt.service.soap.util.QName qname = new com.sapportals.portal.prt.service.soap.util.QName(qwsdl.getNamespaceURI(), qwsdl.getLocalPart());
        Element schema = null;
        WsdlNode wsdlNode = this.foundComplexTypeFromName(qwsdl.getLocalPart(), wsdldoc);
        if (wsdlNode != null) {
            schema = wsdlNode.getNode();
        }
        ObjectSchema objSch = null;
        boolean arrayType = GenerateServiceFromWsdl.isArrayList(schema);
        boolean bl = arrayType = GenerateServiceFromWsdl.typeArray2D(schema) != null;
        if (qname.getLocalPart().indexOf("Array") >= 0) {
            Node firstChild = schema.getFirstChild();
            if (firstChild != null) {
                if (firstChild.getNodeName() != null && firstChild.getNodeName().equals("complexContent")) {
                    arrayType = true;
                } else if (firstChild.getLocalName() != null && firstChild.getNodeName().equals("sequence")) {
                    arrayType = true;
                }
            }
            if (!arrayType) {
                arrayType = GenerateServiceFromWsdl.isArrayRPC(schema);
            }
        }
        if (qname.getLocalPart().startsWith("ArrayOf") || arrayType) {
            objSch = this.getTypeJavaArray(qwsdl, wsdldoc, writeEnable);
            return objSch;
        }
        Class type = null;
        int i = 0;
        while (i < ISOAPParamConstants.NS_URIS_SCHEMAS.length && type == null) {
            type = namep.getJavaType(qname, ISOAPParamConstants.NS_URIS_SCHEMAS[i]);
            ++i;
        }
        if (type != null) {
            objSch = new ObjectSchema(XMLValueEncoder.cleanNameClass(type, (boolean)false), false, new com.sapportals.portal.prt.service.soap.util.QName(qwsdlorig), null);
            if (!ToolKit.isSimpleSoapEncodingType(type)) {
                objSch = new ObjectSchema(XMLValueEncoder.cleanNameClass((Class)type, (boolean)false), true, new com.sapportals.portal.prt.service.soap.util.QName(qwsdlorig), null);
            }
        }
        if (objSch != null) {
            return objSch;
        }
        if (types != null) {
            if (objSch == null) {
                Object ct = this.mm_complexTypes.get(qwsdl);
                if (ct != null) {
                    ComplexType compType = (ComplexType)ct;
                    if (compType.isSimpleTypeMode()) {
                        return new ObjectSchema(compType.getSimpleType(), true, new com.sapportals.portal.prt.service.soap.util.QName(qwsdlorig), null);
                    }
                    return new ObjectSchema(compType.getFullyClassName(), true, new com.sapportals.portal.prt.service.soap.util.QName(qwsdlorig), null);
                }
                String typeJavaName = null;
                typeJavaName = this.mm_complexTypeCurrentProcessing.contains(qwsdl.getNamespaceURI() + '|' + qwsdl.getLocalPart()) ? this.mm_namePackage + "." + ToolKit.toUpperFirstChar(qwsdl.getLocalPart()) : this.createCustomType(qwsdl, types, null, false, writeEnable);
                if (typeJavaName == null) {
                    throw new Exception("The type '" + qname.getLocalPart() + "' on the namespace '" + qname.getNamespaceURI() + "' is not supported !\n" + (schema != null ? schema.toString() : ""));
                }
                objSch = new ObjectSchema(typeJavaName, true, new com.sapportals.portal.prt.service.soap.util.QName(qwsdlorig), null);
            }
            return objSch;
        }
        Map imports = wsdldoc.getImports();
        Iterator iter = imports.keySet().iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            Vector listImp = (Vector)wsdldoc.getImports((String)item);
            i = 0;
            while (i < listImp.size()) {
                ObjectSchema ret;
                Import imp = (Import)listImp.get(i);
                if (imp.getDefinition() != null && (ret = this.getTypeJava(qwsdl, imp.getDefinition())) != null) {
                    return ret;
                }
                ++i;
            }
        }
        REPORT_GENERATION.add(new InformationReport("The XML type " + qwsdlorig.getLocalPart() + " have no equivalent java type !", null, 1));
        return null;
    }

    public String createCustomType(QName nameType, Node typeXML, boolean processFault) throws Exception {
        if (this.mm_def != null) {
            Types types = this.mm_def.getTypes();
            QName qn = nameType;
            String type = null;
            if (this.mm_def.getTypes() != null) {
                type = this.createCustomType(qn, types, typeXML, processFault, true);
            }
            if (type == null) {
                Vector typesAll = new Vector();
                this.getAllTypesInWSDL(this.mm_def, typesAll);
                int i = 0;
                while (i < typesAll.size()) {
                    Types typeImport = (Types)typesAll.get(i);
                    type = this.createCustomType(qn, typeImport, typeXML, processFault, true);
                    if (type != null) {
                        return type;
                    }
                    ++i;
                }
            }
            return type;
        }
        REPORT_GENERATION.add(new InformationReport("the Defintion of the wsdl " + this.mm_urlwsdl + " is empty!", null, 1));
        return null;
    }

    public String createCustomType(String nameType, boolean processFault) throws Exception {
        return this.createCustomType(new QName("", nameType), null, processFault);
    }

    public static String checkNameParams(String nameparam) {
        int i = 0;
        while (i < WSDLConstants.JAVA_KEYWORD.length) {
            if (WSDLConstants.JAVA_KEYWORD[i].equals(nameparam)) {
                REPORT_GENERATION.add(new InformationReport("The parameter " + nameparam + " will normalized (use java convention naming)!", null, 0));
                return "_" + nameparam;
            }
            ++i;
        }
        return nameparam;
    }

    private void getAllTypesInWSDL(Definition wsdl, Vector types) {
        if (wsdl.getTypes() != null) {
            types.add(wsdl.getTypes());
        }
        Iterator iter = wsdl.getImports().keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Vector impWsdls = (Vector)wsdl.getImports().get(key);
            int i = 0;
            while (i < impWsdls.size()) {
                Import wsdlimport = (Import)impWsdls.get(i);
                if (wsdlimport.getDefinition() != null) {
                    this.getAllTypesInWSDL(wsdlimport.getDefinition(), types);
                }
                ++i;
            }
        }
    }

    public Node foundNodeInSchema(String typeName) {
        if (this.mm_def != null && this.mm_def.getTypes() != null) {
            Element schema = null;
            WsdlNode wsdlNode = this.foundComplexTypeFromName(typeName, this.mm_def);
            if (wsdlNode != null) {
                schema = wsdlNode.getNode();
            }
            return schema;
        }
        REPORT_GENERATION.add(new InformationReport("the Defintion of the wsdl " + this.mm_urlwsdl + " is empty!", null, 1));
        return null;
    }

    private Node foundComplexNodeDesc(Node itemComplexType, String typeName) {
        String valueAttr;
        NamedNodeMap nameAttributes;
        Node name;
        if ((itemComplexType.getNodeName().indexOf("complexType") >= 0 || itemComplexType.getNodeName().indexOf("simpleType") >= 0) && (name = (nameAttributes = itemComplexType.getAttributes()).getNamedItem("name")) != null && (valueAttr = name.getNodeValue()).equalsIgnoreCase(typeName)) {
            return itemComplexType;
        }
        if (itemComplexType.getNodeName().indexOf("element") >= 0) {
            String valueAttr2;
            nameAttributes = itemComplexType.getAttributes();
            name = nameAttributes.getNamedItem("name");
            Node typeElement = nameAttributes.getNamedItem("type");
            String nameElement = null;
            if (name != null && (valueAttr2 = name.getNodeValue()).equalsIgnoreCase(typeName)) {
                nameElement = valueAttr2;
            }
            NodeList complextypes = itemComplexType.getChildNodes();
            int i = 0;
            while (i < complextypes.getLength()) {
                String valueAttr3;
                NamedNodeMap nameAttributesChild;
                Node nameChild;
                Node n = complextypes.item(i);
                if (n.getNodeName().indexOf("complexType") >= 0 && ((nameChild = (nameAttributesChild = n.getAttributes()).getNamedItem("name")) != null ? (valueAttr3 = nameChild.getNodeValue()).equalsIgnoreCase(typeName) : nameElement != null && nameElement.equals(typeName))) {
                    return n;
                }
                if (n.getNodeName().indexOf("simpleType") >= 0 && ((nameChild = (nameAttributesChild = n.getAttributes()).getNamedItem("name")) != null ? (valueAttr3 = nameChild.getNodeValue()).equalsIgnoreCase(typeName) : nameElement != null && nameElement.equals(typeName))) {
                    return n;
                }
                ++i;
            }
            if (typeElement != null && nameElement != null && this.mm_def != null) {
                Types typesWsdl = this.mm_def.getTypes();
                String typeWithPrefix = typeElement.getNodeValue();
                String typeWithOutPrefix = typeWithPrefix.substring(typeWithPrefix.indexOf(":") + 1);
                Element complextypeNode = null;
                WsdlNode wsdlNode = this.foundComplexTypeFromName(typeWithOutPrefix, this.mm_def);
                if (wsdlNode != null) {
                    complextypeNode = wsdlNode.getNode();
                }
                return complextypeNode;
            }
        }
        return null;
    }

    private WsdlNode foundComplexTypeFromName(String nameType, Definition wsdl) {
        Types typesWsdl = wsdl.getTypes();
        if (typesWsdl != null) {
            List l = typesWsdl.getExtensibilityElements();
            int i = 0;
            while (i < l.size()) {
                Element schema = ((UnknownExtensibilityElement)l.get(i)).getElement();
                String prefix = schema.getPrefix();
                if (schema.getNodeName().indexOf("schema") >= 0) {
                    NodeList list = schema.getElementsByTagName("complexType");
                    if (list.getLength() <= 0) {
                        list = schema.getElementsByTagName(prefix + ":" + "complexType");
                    }
                    int j = 0;
                    while (j < list.getLength()) {
                        Element node = (Element)list.item(j);
                        String name = DOMUtils.getAttribute((Element)node, (String)"name");
                        if (name != null && name.equals(nameType)) {
                            return new WsdlNode(schema, node);
                        }
                        ++j;
                    }
                    list = schema.getElementsByTagName("simpleType");
                    if (list.getLength() <= 0) {
                        list = schema.getElementsByTagName(prefix + ":" + "simpleType");
                    }
                    int j2 = 0;
                    while (j2 < list.getLength()) {
                        Element node = (Element)list.item(j2);
                        String name = DOMUtils.getAttribute((Element)node, (String)"name");
                        if (name != null && name.equals(nameType)) {
                            return new WsdlNode(schema, node);
                        }
                        ++j2;
                    }
                }
                ++i;
            }
        }
        Map imports = wsdl.getImports();
        Iterator iter = imports.keySet().iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            Vector listImp = (Vector)wsdl.getImports((String)item);
            int i = 0;
            while (i < listImp.size()) {
                WsdlNode ret;
                Import imp = (Import)listImp.get(i);
                if (imp.getDefinition() != null && (ret = this.foundComplexTypeFromName(nameType, imp.getDefinition())) != null && ret.getNode() != null) {
                    return ret;
                }
                ++i;
            }
        }
        return null;
    }

    public Node foundNodeInTypesFromName(String name_node) {
        if (this.mm_def != null) {
            return this.foundNodeInTypesFromName(name_node, this.mm_def);
        }
        return null;
    }

    private Node foundNodeInTypesFromName(String name_node_orig, Definition wsdl) {
        int i;
        Types typesWsdl;
        if (wsdl != null && (typesWsdl = wsdl.getTypes()) != null) {
            String name_node = name_node_orig;
            String prefix = null;
            if (name_node_orig.indexOf(":") != -1) {
                prefix = name_node_orig.substring(0, name_node_orig.indexOf(":"));
                name_node = name_node_orig.substring(name_node_orig.indexOf(":") + 1);
            }
            List l = typesWsdl.getExtensibilityElements();
            i = 0;
            while (i < l.size()) {
                Element schema = ((UnknownExtensibilityElement)l.get(i)).getElement();
                boolean process = true;
                if (prefix != null) {
                    String ns;
                    String tns = DOMUtils.getAttribute((Element)schema, (String)"targetNamespace");
                    process = tns != null ? ((ns = ToolKit.getNameSpaceInWSDLWithImportInclude(wsdl, prefix)) != null ? ns.equals(tns) : false) : false;
                }
                if (process) {
                    NodeList listElements = schema.getChildNodes();
                    int j = 0;
                    while (j < listElements.getLength()) {
                        Element node;
                        String name;
                        Node object = listElements.item(j);
                        if (object.getNodeType() == 1 && (name = DOMUtils.getAttribute((Element)(node = (Element)listElements.item(j)), (String)"name")) != null && name.equals(name_node)) {
                            return node;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        Map imports = wsdl.getImports();
        Iterator iter = imports.keySet().iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            Vector listImp = (Vector)wsdl.getImports((String)item);
            i = 0;
            while (i < listImp.size()) {
                WsdlNode ret;
                Import imp = (Import)listImp.get(i);
                if (imp.getDefinition() != null && (ret = this.foundComplexTypeFromName(name_node_orig, imp.getDefinition())) != null && ret.getNode() != null) {
                    return ret.getNode();
                }
                ++i;
            }
        }
        return null;
    }

    private String createCustomType(QName qwsdl, Types types, Node typeXML, boolean processFault, boolean writeEnable) throws Exception {
        List listSchemas = types.getExtensibilityElements();
        Iterator iter = listSchemas.iterator();
        boolean found = false;
        Node type = null;
        if (typeXML != null) {
            type = typeXML;
            found = true;
        }
        Element schema_parent = null;
        if (type == null) {
            block0: while (iter.hasNext() && !found) {
                UnknownExtensibilityElement item = (UnknownExtensibilityElement)iter.next();
                if (!item.getElementType().getLocalPart().equalsIgnoreCase("schema")) continue;
                NodeList complextypes = item.getElement().getChildNodes();
                int countComplexTypeNodes = 0;
                while (!found && countComplexTypeNodes < complextypes.getLength()) {
                    Node itemchild = this.foundComplexNodeDesc(complextypes.item(countComplexTypeNodes), qwsdl.getLocalPart());
                    if (itemchild != null) {
                        schema_parent = item.getElement();
                        found = true;
                        type = itemchild;
                        continue block0;
                    }
                    ++countComplexTypeNodes;
                }
            }
        }
        if (found && type != null) {
            String filename = this.mm_path + File.separator + "src.api" + File.separator + this.mm_pathPackage + File.separator + ToolKit.toUpperFirstChar(ToolKit.normalizeJavaName(qwsdl.getLocalPart())) + ".java";
            Element complexNode = (Element)type.getParentNode();
            NamedNodeMap listattrs = complexNode.getAttributes();
            NameSpaces nsobj = this.initializeNameSpaces(listattrs);
            if (nsobj != null && schema_parent != null && schema_parent.hasAttributes()) {
                this.addNameSpaces(nsobj, schema_parent.getAttributes());
            }
            if (processFault) {
                CustomException exceptionGenerated = new CustomException(qwsdl, type, this.mm_namePackage, filename, this, nsobj);
                exceptionGenerated.writeClass();
                this.mm_customExceptions.put(qwsdl, exceptionGenerated);
                if (exceptionGenerated.isSimpleTypeMode()) {
                    return exceptionGenerated.getSimpleType();
                }
                return exceptionGenerated.getPackagename() + "." + ToolKit.toUpperFirstChar(exceptionGenerated.getClassName());
            }
            this.mm_complexTypeCurrentProcessing.add(qwsdl.getNamespaceURI() + "|" + qwsdl.getLocalPart());
            ComplexType comtype = new ComplexType(qwsdl, type, this.mm_namePackage, filename, this, nsobj, writeEnable);
            if (writeEnable) {
                comtype.writeClass();
            }
            this.mm_complexTypes.put(qwsdl, comtype);
            this.mm_complexTypeCurrentProcessing.remove(qwsdl.getNamespaceURI() + "|" + qwsdl.getLocalPart());
            if (comtype.isSimpleTypeMode()) {
                return comtype.getSimpleType();
            }
            return comtype.getPackagename() + "." + ToolKit.toUpperFirstChar(comtype.getClassName());
        }
        REPORT_GENERATION.add(new InformationReport("Nothing Java file generated for the type " + qwsdl.getLocalPart() + " because the XML Schema is not found in the wsdl.", null, 1));
        return null;
    }

    private NameSpaces initializeNameSpaces(NamedNodeMap listattrs) {
        NameSpaces nsobj = new NameSpaces();
        int i = 0;
        while (i < listattrs.getLength()) {
            Attr attr = (Attr)listattrs.item(i);
            if (attr.getPrefix() != null && attr.getPrefix().equals("xmlns")) {
                nsobj.putPrefix(attr.getNodeValue(), attr.getLocalName());
            }
            ++i;
        }
        return nsobj;
    }

    private void addNameSpaces(NameSpaces nsobj, NamedNodeMap listattrs) {
        int i = 0;
        while (i < listattrs.getLength()) {
            Attr attr = (Attr)listattrs.item(i);
            if (attr.getPrefix() != null && attr.getPrefix().equals("xmlns")) {
                nsobj.putPrefix(attr.getNodeValue(), attr.getLocalName());
            }
            ++i;
        }
    }

    public QName getTypeFromElement(QName elementName, Definition wsdldoc) {
        Types types = wsdldoc.getTypes();
        if (types != null) {
            List l = types.getExtensibilityElements();
            int i = 0;
            while (i < l.size()) {
                Element schema = ((UnknownExtensibilityElement)l.get(i)).getElement();
                if (schema.getNodeName().indexOf("schema") >= 0) {
                    String prefix = schema.getPrefix();
                    NodeList list = schema.getElementsByTagName("element");
                    if (list.getLength() <= 0) {
                        list = schema.getElementsByTagName(prefix + ":" + "element");
                    }
                    int j = 0;
                    while (j < list.getLength()) {
                        Element node = (Element)list.item(j);
                        String name = DOMUtils.getAttribute((Element)node, (String)"name");
                        if (name != null && name.indexOf(elementName.getLocalPart()) >= 0) {
                            String type = node.getAttribute("type");
                            if (type != null && type.length() > 0) {
                                if (type.indexOf(":") >= 0) {
                                    prefix = type.substring(0, type.indexOf(":"));
                                    String namespace = this.getNamespaceFromPrefix(prefix, node);
                                    if (namespace == null) {
                                        namespace = this.getNamespaceFromPrefix(prefix, schema);
                                    }
                                    if (this.mm_def != null && namespace == null) {
                                        namespace = ToolKit.getNameSpaceInWSDLWithImportInclude(this.mm_def, prefix);
                                    }
                                    return new QName(namespace, type.substring(type.indexOf(":") + 1));
                                }
                                return new QName(wsdldoc.getTargetNamespace(), type);
                            }
                            if (node.hasChildNodes() && node.getElementsByTagName(prefix + "complexType") != null) {
                                return elementName;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        Map imports = wsdldoc.getImports();
        Iterator iter = imports.keySet().iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            Vector listImp = (Vector)wsdldoc.getImports((String)item);
            int i = 0;
            while (i < listImp.size()) {
                QName ret;
                Import imp = (Import)listImp.get(i);
                if (imp.getDefinition() != null && (ret = this.getTypeFromElement(elementName, imp.getDefinition())) != null) {
                    return ret;
                }
                ++i;
            }
        }
        REPORT_GENERATION.add(new InformationReport("The element " + elementName.getLocalPart() + "not found in the XSD Schema from the wsdl file!", null, 1));
        return null;
    }

    private boolean isNillableTypeFromElement(QName elementName, Definition wsdldoc) {
        Types types = wsdldoc.getTypes();
        if (types != null) {
            List l = types.getExtensibilityElements();
            int i = 0;
            while (i < l.size()) {
                Element schema = ((UnknownExtensibilityElement)l.get(i)).getElement();
                if (schema.getNodeName().indexOf("schema") >= 0) {
                    String prefix = schema.getPrefix();
                    NodeList list = schema.getElementsByTagName("element");
                    if (list.getLength() <= 0) {
                        list = schema.getElementsByTagName(prefix + ":" + "element");
                    }
                    int j = 0;
                    while (j < list.getLength()) {
                        Element node = (Element)list.item(j);
                        String name = DOMUtils.getAttribute((Element)node, (String)"name");
                        if (name != null && name.indexOf(elementName.getLocalPart()) >= 0) {
                            String nillable = node.getAttribute("nillable");
                            if (nillable == null) {
                                return false;
                            }
                            return nillable.equals("true") || nillable.equals("1");
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        Map imports = wsdldoc.getImports();
        Iterator iter = imports.keySet().iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            Vector listImp = (Vector)wsdldoc.getImports((String)item);
            int i = 0;
            while (i < listImp.size()) {
                Import imp = (Import)listImp.get(i);
                if (imp.getDefinition() != null) {
                    boolean ret = this.isNillableTypeFromElement(elementName, imp.getDefinition());
                    return ret;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isNillableTypeFromType(QName elementType, Definition wsdldoc) {
        Types types = wsdldoc.getTypes();
        if (types != null) {
            List l = types.getExtensibilityElements();
            int i = 0;
            while (i < l.size()) {
                Element schema = ((UnknownExtensibilityElement)l.get(i)).getElement();
                if (schema.getNodeName().indexOf("schema") >= 0) {
                    String prefix = schema.getPrefix();
                    NodeList list = schema.getElementsByTagName("complexType");
                    if (list.getLength() <= 0) {
                        list = schema.getElementsByTagName(prefix + ":" + "complexType");
                    }
                    int j = 0;
                    while (j < list.getLength()) {
                        Element node = (Element)list.item(j);
                        String name = DOMUtils.getAttribute((Element)node, (String)"name");
                        if (name != null && name.indexOf(elementType.getLocalPart()) >= 0) {
                            NodeList listchilds = node.getElementsByTagName("complexContent");
                            if (listchilds.getLength() <= 0) {
                                listchilds = node.getElementsByTagName(prefix + ":" + "complexContent");
                            }
                            if (listchilds.getLength() > 0) {
                                listchilds = node.getElementsByTagName("restriction");
                                if (listchilds.getLength() <= 0) {
                                    listchilds = node.getElementsByTagName(prefix + ":" + "restriction");
                                }
                                int k = 0;
                                while (k < listchilds.getLength()) {
                                    Element nodeAttribute = (Element)listchilds.item(k);
                                    int index = 0;
                                    while (index < nodeAttribute.getChildNodes().getLength()) {
                                        if (nodeAttribute.getChildNodes().item(index).getNodeType() == 1) {
                                            String nillable = ((Element)nodeAttribute.getChildNodes().item(index)).getAttribute("nillable");
                                            if (nillable == null) {
                                                return false;
                                            }
                                            return nillable.equals("true") || nillable.equals("1");
                                        }
                                        ++index;
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        Map imports = wsdldoc.getImports();
        Iterator iter = imports.keySet().iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            Vector listImp = (Vector)wsdldoc.getImports((String)item);
            int i = 0;
            while (i < listImp.size()) {
                Import imp = (Import)listImp.get(i);
                if (imp.getDefinition() != null) {
                    boolean ret = this.isNillableTypeFromType(elementType, imp.getDefinition());
                    return ret;
                }
                ++i;
            }
        }
        return false;
    }

    public String getNamespaceFromPrefix(String prefix, Node element) {
        String namespace = DOMUtils.getNamespaceURIFromPrefix((Node)element, (String)prefix);
        if (namespace != null) {
            return namespace;
        }
        if (this.mm_def != null) {
            return ToolKit.getNameSpaceInWSDLWithImportInclude(this.mm_def, prefix);
        }
        REPORT_GENERATION.add(new InformationReport("Nothing namespace exists from the prefix " + prefix, null, 0));
        return null;
    }

    public String getPrefixFromNamespace(String namespace) {
        if (namespace == null) {
            return null;
        }
        if (this.mm_def == null) {
            return null;
        }
        return ToolKit.getPrefixInWSDLWithImportInclude(this.mm_def, namespace);
    }

    private ObjectSchema getTypeJavaArray(QName qwsdl, Definition wsdldoc, boolean writeEnable) throws Exception {
        Element nodeattr;
        WsdlNode wsdlNode = this.foundComplexTypeFromName(qwsdl.getLocalPart(), wsdldoc);
        if (wsdlNode == null) {
            JavaToWsdl.REPORT_GENERATION.add(new InformationReport("Type " + qwsdl.getLocalPart() + " was not found in the wsdl", null, 1));
            return new ObjectSchema("String[]", false, new com.sapportals.portal.prt.service.soap.util.QName("string", "http://www.w3.org/2001/XMLSchema"), "error");
        }
        Element schema = wsdlNode.getSchema();
        String prefixSch = schema.getPrefix();
        Element node = wsdlNode.getNode();
        String type = null;
        String namespaceOfRef = qwsdl.getNamespaceURI();
        NodeList listattr = node.getElementsByTagName("attribute");
        if (listattr.getLength() <= 0) {
            listattr = node.getElementsByTagName(prefixSch + ":" + "attribute");
        }
        if ((nodeattr = (Element)listattr.item(0)) != null) {
            type = DOMUtils.getAttribute((Element)nodeattr, (String)"wsdl:arrayType");
            if (type == null) {
                type = DOMUtils.getAttribute((Element)nodeattr, (String)"type");
            }
            if (type == null) {
                NamedNodeMap attrs = nodeattr.getAttributes();
                int k = 0;
                while (k < attrs.getLength()) {
                    Attr attr = (Attr)attrs.item(k);
                    if (attr.getLocalName().equals("arrayType")) {
                        type = attr.getNodeValue();
                        break;
                    }
                    ++k;
                }
            }
            if (type != null) {
                String nameItem = DOMUtils.getAttribute((Element)nodeattr, (String)"name");
                String prefix = null;
                prefix = type.indexOf(":") != -1 ? type.substring(0, type.indexOf(":")) : "xsd";
                String uri = null;
                if (schema.getAttributes() != null) {
                    NamedNodeMap listattrs = schema.getAttributes();
                    int ind_ns = 0;
                    while (ind_ns < listattrs.getLength()) {
                        Attr attr = (Attr)listattrs.item(ind_ns);
                        if (attr.getLocalName().equals(prefix)) {
                            uri = attr.getNodeValue();
                            break;
                        }
                        ++ind_ns;
                    }
                }
                if (uri == null) {
                    uri = this.mm_def.getNamespace(prefix);
                }
                if (uri == null) {
                    uri = ToolKit.getNameSpaceInWSDLWithImportInclude(this.mm_def, prefix);
                }
                QName qnameType = null;
                qnameType = type.indexOf("[") != -1 ? new QName(uri, type.substring(type.indexOf(":") + 1, type.indexOf("["))) : new QName(uri, type.substring(type.indexOf(":") + 1));
                String typeOfArray = null;
                String dimension = null;
                if (type.indexOf("[") != -1) {
                    dimension = type.substring(type.indexOf("["), type.lastIndexOf("]") + 1);
                    if (dimension.equals("[,]")) {
                        dimension = "[][]";
                    }
                } else {
                    dimension = "[]";
                }
                boolean arrayType = GenerateServiceFromWsdl.isArrayList(schema);
                if (qnameType.getLocalPart().indexOf("ArrayOf") >= 0 || qnameType.getLocalPart().indexOf("Array") >= 0 || arrayType) {
                    JavaToWsdl.REPORT_GENERATION.add(new InformationReport("This Array 2D format (Array of Array) type is not supporting, use this format 'string[][]'", null, 1));
                    REPORT_GENERATION.add(new InformationReport("This Array 2D format (Array of Array) type is not supporting, use this format 'string[][]'", null, 1));
                    typeOfArray = new ObjectSchema("String", false, new com.sapportals.portal.prt.service.soap.util.QName("string", "http://www.w3.org/2001/XMLSchema"), nameItem).getType() + "[]";
                } else {
                    typeOfArray = this.mm_complexTypeCurrentProcessing.contains(qnameType.getNamespaceURI() + '|' + qnameType.getLocalPart()) ? this.mm_namePackage + "." + ToolKit.toUpperFirstChar(qnameType.getLocalPart()) + dimension : this.getTypeJava(qnameType, wsdldoc, writeEnable).getType() + dimension;
                }
                return new ObjectSchema(typeOfArray, true, new com.sapportals.portal.prt.service.soap.util.QName(qnameType), nameItem, namespaceOfRef);
            }
        }
        if ((listattr = node.getElementsByTagName("element")).getLength() <= 0) {
            listattr = node.getElementsByTagName(prefixSch + ":" + "element");
        }
        nodeattr = (Element)listattr.item(0);
        type = DOMUtils.getAttribute((Element)nodeattr, (String)"type");
        boolean refType = false;
        if (type == null) {
            type = this.findTypeFromReferencedNode(type, nodeattr);
            refType = true;
        }
        boolean array2D = false;
        if (type == null && (type = GenerateServiceFromWsdl.typeArray2D(node)) != null) {
            array2D = true;
        }
        if (type != null) {
            String nameItem = DOMUtils.getAttribute((Element)nodeattr, (String)"name");
            if (refType) {
                String reference = DOMUtils.getAttribute((Element)nodeattr, (String)"ref");
                int indPrefix = reference.indexOf(":");
                if (indPrefix != -1) {
                    namespaceOfRef = this.getNamespaceFromPrefix(reference.substring(0, indPrefix), node);
                    nameItem = reference.substring(indPrefix + 1);
                } else {
                    namespaceOfRef = "";
                    nameItem = reference;
                }
            }
            String prefix = null;
            prefix = type.indexOf(":") != -1 ? type.substring(0, type.indexOf(":")) : "xsd";
            String uri = this.getNamespaceFromPrefix(prefix, node);
            QName qnameType = new QName(uri, type.substring(type.indexOf(":") + 1));
            String typeOfArray = null;
            String dimension = "[]";
            if (array2D) {
                dimension = "[][]";
            }
            typeOfArray = this.mm_complexTypeCurrentProcessing.contains(qnameType.getNamespaceURI() + '|' + qnameType.getLocalPart()) ? this.mm_namePackage + "." + ToolKit.toUpperFirstChar(qnameType.getLocalPart()) + dimension : this.getTypeJava(qnameType, wsdldoc, writeEnable).getType() + dimension;
            return new ObjectSchema(typeOfArray, true, new com.sapportals.portal.prt.service.soap.util.QName(qnameType), nameItem, namespaceOfRef);
        }
        REPORT_GENERATION.add(new InformationReport("Cannot create the array " + qwsdl.getLocalPart() + " from XSD Schema.", null, 1));
        return null;
    }

    private String findTypeFromReferencedNode(String type, Element nodeattr) throws IllegalArgumentException, DOMException {
        String reference = DOMUtils.getAttribute((Element)nodeattr, (String)"ref");
        Node nodeRef = this.foundNodeInTypesFromName(reference);
        if (nodeRef == null) {
            throw new IllegalArgumentException("Node reference not found (" + reference + ")");
        }
        NamedNodeMap attrsRef = nodeRef.getAttributes();
        Node nameattr = attrsRef.getNamedItem("name");
        Node typeRef = attrsRef.getNamedItem("type");
        if (typeRef == null) {
            throw new IllegalArgumentException("Type Node reference not found (" + reference + ")");
        }
        type = typeRef.getNodeValue();
        return type;
    }

    private void initStreams() throws Exception {
        URL inWsdl = new URL(this.mm_urlwsdl);
        if (inWsdl == null || inWsdl.openStream() == null) {
            REPORT_GENERATION.add(new InformationReport("Error : the InputStrean URL(" + inWsdl + ") is empty or not correct.", null, 2));
            throw new Exception("Error : the InputStrean URL(" + inWsdl + ") is null or not content.");
        }
        this.mm_inWsdl = inWsdl.openStream();
    }

    private boolean foundStringInVector(Vector list, String item, String portName) {
        int i = 0;
        while (i < list.size()) {
            if (((String)list.get(i)).equals(portName + " / " + item)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void writeClass(PrintWriter out) throws IOException {
        out.println();
        out.println("/**");
        out.println(" * Title: " + this.mm_nameService + ".java");
        if (this.mm_serverSideMode) {
            out.println(" * Description: Template Portal Service based on a Web Service.");
            out.println(" * Template was generated automatically by the SAP PORTAL ECLIPSE PLUGINS");
            out.println(" * from the wsdl url : " + this.mm_urlwsdl);
            out.println(" * Plugin version: " + JavaToWsdl.VERSION_ECLIPSEPLUGIN);
            out.println(" * @author " + System.getProperty("user.name"));
        } else {
            out.println(" * Description: Virtual Portal Service of " + this.mm_nameService + " Service.");
            out.println(" * This file was generated automatically by the SAP PORTAL ECLIPSE PLUGINS,");
            out.println(" * not to modify manually");
            out.println(" * Plugin version: " + JavaToWsdl.VERSION_ECLIPSEPLUGIN);
            out.println(" * @author SAP Portal EP6.0");
        }
        out.println(" * @version " + new SimpleDateFormat("yyyy.MM.dd G 'at' HH:mm:ss z").format(new Date()));
        out.println(" */");
        out.println();
        out.print("public class " + this.mm_nameService);
        if (this.mm_nameInterface != null) {
            out.print(" implements " + this.mm_nameInterface);
        }
        out.println(" {");
        out.flush();
    }

    private void writeConstants(PrintWriter out) throws IOException {
        out.println();
        out.flush();
    }

    private void writeFields(PrintWriter out, Definition wsdl) throws IOException {
        String namespace = wsdl.getTargetNamespace();
        out.println();
        out.println("\tprivate String mm_namespaceURI =\"" + namespace + "\";");
        out.println("\tprivate IServiceContext mm_serviceContext;");
        out.println("\tprivate ISOAPService mm_soapService = null;");
        out.println("\tprivate String mm_urlEndpoint = null;");
        out.println("\tprivate Vector mm_cookies =  new Vector();");
        out.println("\tprivate Object[] mm_cookiesFromResponse =  null;");
        out.println("\tpublic IUserContext mm_userCxt = null;");
        out.println("\tpublic boolean mm_isClone = false;");
        out.flush();
    }

    private void writeImport(PrintWriter out) throws IOException {
        out.println();
        out.println("import com.sapportals.portal.prt.service.IServiceContext;");
        out.println("import com.sapportals.portal.prt.session.IUserContext;");
        out.println();
        out.println("import com.sapportals.portal.prt.service.soap.ISOAPService;");
        out.println("import com.sapportals.portal.prt.service.soap.IPRTSOAPCall;");
        out.println("import com.sapportals.portal.prt.service.soap.exception.*;");
        out.println("import com.sapportals.portal.prt.service.soap.SOAPParameter;");
        out.println("import com.sapportals.portal.prt.service.soap.types.*;");
        out.println("import com.sapportals.portal.prt.service.soap.util.*;");
        out.println("import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;");
        out.println();
        out.println("import javax.xml.messaging.URLEndpoint;");
        out.println("import java.util.Properties;");
        out.println("import java.io.File;");
        out.println("import java.io.FileInputStream;");
        out.println();
        out.println("import java.util.*;");
        out.println("import java.math.BigDecimal;");
        out.flush();
    }

    private void writeMethod(PrintWriter out, String nameMethod, ObjectSchema typeReturn, XMLAttributeHandler params, String namespaceMethod, HashMap httpheaders, String url, ArrayList exceptions) {
        out.println();
        String namespaceURI = null;
        namespaceURI = namespaceMethod == null ? this.mm_def.getTargetNamespace() : (namespaceMethod.length() == 0 ? this.mm_def.getTargetNamespace() : namespaceMethod);
        int nbParams = params.getSize();
        out.println("\tpublic " + typeReturn.getType() + " " + nameMethod + " ( ");
        int nbParamsByLine = 4;
        int nbCurrentParamsbyLine = 0;
        out.print("\t\t");
        Object[] keysparams = params.getKeyOrdered().toArray();
        int i = 0;
        while (i < keysparams.length) {
            ObjectSchema type = (ObjectSchema)params.getAttribute((String)keysparams[i]);
            out.print(type.getType() + " " + (String)keysparams[i]);
            if (i != nbParams - 1) {
                out.print(", ");
            }
            if (nbCurrentParamsbyLine >= nbParamsByLine) {
                out.println("");
                nbCurrentParamsbyLine = 0;
            } else {
                ++nbCurrentParamsbyLine;
            }
            ++i;
        }
        if (exceptions.size() == 0) {
            out.print(" ) {");
        } else {
            out.println(") throws ");
            int i2 = 0;
            while (i2 < exceptions.size() - 1) {
                String nexp = (String)exceptions.get(i2);
                out.print(nexp + ",");
                ++i2;
            }
            out.println((String)exceptions.get(exceptions.size() - 1) + "  {");
        }
        out.println("\n\t\ttry {");
        if (!httpheaders.isEmpty()) {
            out.println("\t\t    HashMap httpheaders = new HashMap();");
            Iterator iter = httpheaders.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = (String)httpheaders.get(key);
                if (key.length() <= 0) continue;
                out.println("\t\t    httpheaders.put(\"" + key + "\",\"" + (value.length() == 0 ? "\\\"\\\"" : value) + "\");");
            }
            out.println();
        }
        out.println("\t\t    XMLAttributeHandler params = new XMLAttributeHandler();");
        int i3 = 0;
        while (i3 < keysparams.length) {
            out.print("\t\t    params.addAttribute(\"" + (String)keysparams[i3] + "\", new SOAPParameter(null,");
            ObjectSchema type = (ObjectSchema)params.getAttribute((String)keysparams[i3]);
            if (!ToolKit.isSimpleType(type.getType())) {
                out.println(type.getType() + ".class," + (String)keysparams[i3] + "));");
            } else {
                out.println(type.getType() + ".class," + ToolKit.writeWrapForPrimitive(type, (String)keysparams[i3]) + "));");
            }
            ++i3;
        }
        out.println();
        out.println("\t\t\tString aUrl = \"" + url + "\";");
        out.println("\t\t\tif(mm_urlEndpoint!=null)\n\t\t\t{");
        out.println("\t\t\t\t aUrl = mm_urlEndpoint;");
        out.println("\t\t\t}");
        out.println("\t\t\tIUserContext aUser = null;");
        out.println("\t\t\tString systemAlias = null;");
        out.println("\t\t\tif(mm_isClone)\n\t\t\t{");
        out.println("\t\t\t\t aUser = mm_userCxt;");
        out.println("\t\t\t\t systemAlias = mm_serviceContext.getServiceProfile().getProperty(ISOAPParamConstants.SYSTEM_ALIAS);");
        out.println("\t\t\t}");
        if (httpheaders.isEmpty()) {
            out.println("\t\t\tIPRTSOAPCall mm_soapcall = mm_soapService.getSOAPCallInstance(aUrl," + this.mm_nameInterface + ".KEY, mm_namespaceURI);");
        } else {
            out.println("\t\t\tIPRTSOAPCall mm_soapcall = mm_soapService.getSOAPCallInstance(httpheaders,aUrl," + this.mm_nameInterface + ".KEY, mm_namespaceURI);");
        }
        out.println();
        out.println("\t\t\tmm_cookiesFromResponse =null;");
        out.println("\t\t\tif (mm_cookies.size()>0){");
        out.println("\t\t\t\tEnumeration enumeration = mm_cookies.elements();");
        out.println("\t\t\t\twhile (enumeration.hasMoreElements())");
        out.println("\t\t\t\t{");
        out.println("\t\t\t\t\tObject element = (Object) enumeration.nextElement();");
        out.println("\t\t\t\t\tif (checkTypeObject(element))");
        out.println("\t\t\t\t\t\tmm_soapcall.addCookie(element);");
        out.println("\t\t\t\t}");
        out.println("\t\t\t}");
        out.println();
        if (!ToolKit.isSimpleType(typeReturn.getType())) {
            out.println("\t\t    " + typeReturn.getType() + " result = (" + typeReturn.getType() + ")mm_soapcall.invokeMethod(\"" + nameMethod + "\", params,\"" + namespaceURI + "\", aUser, systemAlias);");
        } else {
            out.println(this.writeCastForPrimitive(typeReturn, nameMethod, namespaceURI));
        }
        out.println("\t\t\tmm_cookiesFromResponse = mm_soapcall.getCookiesContainInResponse();");
        out.println("\t\t\tmm_soapcall = null;");
        out.println();
        if (typeReturn.getType().indexOf("void") == -1) {
            out.println("\t\t    return result;");
        }
        out.println("\t\t} catch (Exception soapex) {");
        out.println();
        out.println("\t\t    if ( soapex instanceof PRTFault) {");
        out.println("\t\t\tObject excp = ((PRTFault)soapex).throwException();");
        if (exceptions.size() > 0) {
            int i4 = 0;
            while (i4 < exceptions.size()) {
                String nexp = (String)exceptions.get(i4);
                out.println("\t\t\tif (excp instanceof " + nexp + ") throw (" + nexp + ")excp;");
                ++i4;
            }
        }
        out.println("\t\t\tthrow (PRTFault)soapex;");
        out.println("\t\t    }else");
        out.println("\t\t       throw new PRTFaultInternalError(this,soapex);");
        out.println("\t\t}");
        out.println("\t\tfinally{");
        out.println("\t\t\tmm_cookies.clear();");
        out.println("\t\t}");
        out.println("\t }");
        out.flush();
    }

    private void writeSignMethod(PrintWriter out, String nameMethod, ObjectSchema typeReturn, XMLAttributeHandler params, ArrayList exceptions) {
        out.println();
        int nbParams = params.getSize();
        out.println("\tpublic " + typeReturn.getType() + " " + nameMethod + " ( ");
        int nbParamsByLine = 4;
        int nbCurrentParamsbyLine = 0;
        out.print("\t\t");
        Object[] keysparams = params.getKeyOrdered().toArray();
        int i = 0;
        while (i < keysparams.length) {
            ObjectSchema type = (ObjectSchema)params.getAttribute((String)keysparams[i]);
            out.print(type.getType() + " " + (String)keysparams[i]);
            if (i != nbParams - 1) {
                out.print(", ");
            }
            if (nbCurrentParamsbyLine >= nbParamsByLine) {
                out.println("");
                nbCurrentParamsbyLine = 0;
            } else {
                ++nbCurrentParamsbyLine;
            }
            ++i;
        }
        if (exceptions.size() == 0) {
            out.println(");");
        } else {
            out.println(") throws ");
            int i2 = 0;
            while (i2 < exceptions.size() - 1) {
                String nexp = (String)exceptions.get(i2);
                out.print(nexp + ",");
                ++i2;
            }
            out.print((String)exceptions.get(exceptions.size() - 1) + ";");
            out.println();
        }
        out.flush();
    }

    private void writeTemplateMethod(PrintWriter out, String nameMethod, ObjectSchema typeReturn, XMLAttributeHandler params, ArrayList exceptions) {
        out.println();
        int nbParams = params.getSize();
        out.println("\tpublic " + typeReturn.getType() + " " + nameMethod + " ( ");
        int nbParamsByLine = 4;
        int nbCurrentParamsbyLine = 0;
        out.print("\t\t");
        Object[] keysparams = params.getKeyOrdered().toArray();
        int i = 0;
        while (i < keysparams.length) {
            ObjectSchema type = (ObjectSchema)params.getAttribute((String)keysparams[i]);
            out.print(type.getType() + " " + (String)keysparams[i]);
            if (i != nbParams - 1) {
                out.print(", ");
            }
            if (nbCurrentParamsbyLine >= nbParamsByLine) {
                out.println("");
                nbCurrentParamsbyLine = 0;
            } else {
                ++nbCurrentParamsbyLine;
            }
            ++i;
        }
        if (exceptions.size() == 0) {
            out.println(") {\n \t\t// TODO code here the implementation.\n\n");
            out.println("\t\treturn " + ToolKit.getDefaultValueReturnForType(typeReturn.getType()) + ";\n\t}");
        } else {
            out.println(") throws ");
            out.println("\t");
            int i2 = 0;
            while (i2 < exceptions.size() - 1) {
                String nexp = (String)exceptions.get(i2);
                out.print(nexp + ",");
                ++i2;
            }
            out.println((String)exceptions.get(exceptions.size() - 1));
            out.println("\t{\n \t// TODO code here the implementation.\n\n");
            out.println("\t\treturn " + ToolKit.getDefaultValueReturnForType(typeReturn.getType()) + ";\n\t}");
        }
        out.flush();
    }

    private String writeCastForPrimitive(ObjectSchema type, String nameMethod, String namespaceURI) {
        if (type != null && type.getType().indexOf("long") != -1) {
            return "\t\t    " + type.getType() + " result = ((Long)mm_soapcall.invokeMethod(\"" + nameMethod + "\", params,\"" + namespaceURI + "\", aUser, systemAlias))." + type.getType() + "Value();";
        }
        if (type != null && type.getType().indexOf("boolean") != -1) {
            return "\t\t    " + type.getType() + " result = ((Boolean)mm_soapcall.invokeMethod(\"" + nameMethod + "\", params,\"" + namespaceURI + "\", aUser, systemAlias))." + type.getType() + "Value();";
        }
        if (type != null && type.getType().indexOf("byte") != -1) {
            return "\t\t    " + type.getType() + " result = ((Byte)mm_soapcall.invokeMethod(\"" + nameMethod + "\", params,\"" + namespaceURI + "\", aUser, systemAlias))." + type.getType() + "Value();";
        }
        if (type != null && type.getType().indexOf("double") != -1) {
            return "\t\t    " + type.getType() + " result = ((Double)mm_soapcall.invokeMethod(\"" + nameMethod + "\", params,\"" + namespaceURI + "\", aUser, systemAlias))." + type.getType() + "Value();";
        }
        if (type != null && type.getType().indexOf("float") != -1) {
            return "\t\t    " + type.getType() + " result = ((Float)mm_soapcall.invokeMethod(\"" + nameMethod + "\", params,\"" + namespaceURI + "\", aUser, systemAlias))." + type.getType() + "Value();";
        }
        if (type != null && type.getType().indexOf("int") != -1) {
            return "\t\t    " + type.getType() + " result = ((Integer)mm_soapcall.invokeMethod(\"" + nameMethod + "\", params,\"" + namespaceURI + "\", aUser, systemAlias))." + type.getType() + "Value();";
        }
        if (type != null && type.getType().indexOf("short") != -1) {
            return "\t\t    " + type.getType() + " result = ((Short)mm_soapcall.invokeMethod(\"" + nameMethod + "\", params,\"" + namespaceURI + "\", aUser, systemAlias))." + type.getType() + "Value();";
        }
        if (type != null && type.getType().indexOf("String") != -1) {
            return "\t\t    " + type.getType() + " result = (String) mm_soapcall.invokeMethod(\"" + nameMethod + "\", params,\"" + namespaceURI + "\", aUser, systemAlias);";
        }
        if (type != null && type.getType().indexOf("void") != -1) {
            return "\t\t   mm_soapcall.invokeMethod(\"" + nameMethod + "\", params,\"" + namespaceURI + "\", aUser, systemAlias);";
        }
        return "";
    }

    private void writeMethods(PrintWriter out, Definition wsdl, boolean modeInterface) throws IOException, Exception {
        Iterator iterservice = wsdl.getServices().keySet().iterator();
        while (iterservice.hasNext()) {
            Object itemservice = iterservice.next();
            Service service = wsdl.getService((QName)itemservice);
            Iterator iterport = service.getPorts().keySet().iterator();
            while (iterport.hasNext()) {
                Object itemport = iterport.next();
                Port port = service.getPort((String)itemport);
                String url = null;
                Iterator iterextElments = port.getExtensibilityElements().iterator();
                while (iterextElments.hasNext()) {
                    ExtensibilityElement elem = (ExtensibilityElement)iterextElments.next();
                    if (!ISOAPParamConstants.Q_ELEM_SOAP_ADDRESS.getWsdlQName().getLocalPart().equalsIgnoreCase(elem.getElementType().getLocalPart()) || !"http://schemas.xmlsoap.org/wsdl/soap/".equals(elem.getElementType().getNamespaceURI())) continue;
                    SOAPAddress address = null;
                    try {
                        address = (SOAPAddress)elem;
                    }
                    catch (ClassCastException cex) {
                        UnknownExtensibilityElement elemunknown = (UnknownExtensibilityElement)elem;
                        ExtensionDeserializer der = wsdl.getExtensionRegistry().queryDeserializer(class$javax$wsdl$Port == null ? GenerateServiceFromWsdl.class$("javax.wsdl.Port") : class$javax$wsdl$Port, ISOAPParamConstants.Q_ELEM_SOAP_ADDRESS.getWsdlQName());
                        address = (SOAPAddress)der.unmarshall(class$javax$wsdl$Port == null ? GenerateServiceFromWsdl.class$("javax.wsdl.Port") : class$javax$wsdl$Port, ISOAPParamConstants.Q_ELEM_SOAP_ADDRESS.getWsdlQName(), elemunknown.getElement(), wsdl, wsdl.getExtensionRegistry());
                    }
                    if (address == null) continue;
                    url = address.getLocationURI();
                }
                Binding binding = port.getBinding();
                iterextElments = binding.getExtensibilityElements().iterator();
                while (iterextElments.hasNext()) {
                    ExtensibilityElement elem = (ExtensibilityElement)iterextElments.next();
                    if (!"binding".equalsIgnoreCase(elem.getElementType().getLocalPart()) || !"http://schemas.xmlsoap.org/wsdl/soap/".equals(elem.getElementType().getNamespaceURI())) continue;
                    this.processBinding(out, binding, modeInterface, wsdl, url, port.getName());
                }
            }
        }
    }

    private String foundAttributeExtensibilityElements(List ExtensibilityElements, String attribute_name) {
        String attribute = null;
        int i = 0;
        while (i < ExtensibilityElements.size()) {
            Object itemExt = ExtensibilityElements.get(i);
            if (itemExt.getClass().isAssignableFrom(class$javax$wsdl$extensions$UnknownExtensibilityElement == null ? GenerateServiceFromWsdl.class$("javax.wsdl.extensions.UnknownExtensibilityElement") : class$javax$wsdl$extensions$UnknownExtensibilityElement)) {
                UnknownExtensibilityElement element = (UnknownExtensibilityElement)itemExt;
                if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(element.getElementType().getNamespaceURI())) {
                    attribute = element.getElement().getAttribute(attribute_name);
                }
                if (attribute != null && attribute.length() != 0) break;
            }
            ++i;
        }
        if (attribute.length() == 0) {
            return null;
        }
        return attribute;
    }

    private void processBinding(PrintWriter out, Binding binding, boolean modeInterface, Definition wsdl, String url, String portName) throws Exception {
        List bindingoperations = binding.getBindingOperations();
        Iterator iter = bindingoperations.iterator();
        int countOperation = 0;
        while (iter.hasNext()) {
            BindingOperation item = (BindingOperation)iter.next();
            if (this.mm_methodsAllowedMethods == null || GenerateServiceFromWsdl.foundSelectedMethod(this.mm_methodsAllowedMethods, countOperation)) {
                String namespaceMethod;
                String soapaction = this.foundAttributeExtensibilityElements(item.getExtensibilityElements(), "soapAction");
                if (soapaction == null) {
                    soapaction = "";
                }
                if ((namespaceMethod = this.foundAttributeExtensibilityElements(item.getExtensibilityElements(), "namespace")) == null) {
                    namespaceMethod = this.foundAttributeExtensibilityElements(item.getBindingInput().getExtensibilityElements(), "namespace");
                }
                String useAttrInput = this.foundAttributeExtensibilityElements(item.getBindingInput().getExtensibilityElements(), "use");
                String useAttrOutput = this.foundAttributeExtensibilityElements(item.getBindingOutput().getExtensibilityElements(), "use");
                String style = this.foundAttributeExtensibilityElements(binding.getExtensibilityElements(), "style");
                this.processOperation(out, modeInterface, item.getOperation(), wsdl, url, soapaction, namespaceMethod, portName, style, useAttrInput, useAttrOutput);
            }
            ++countOperation;
        }
    }

    private static boolean foundSelectedMethod(Vector allowedMethods, int numOperation) {
        int i = 0;
        while (i < allowedMethods.size()) {
            if ((Integer)allowedMethods.get(i) == numOperation) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void processOperation(PrintWriter out, boolean modeInterface, Operation operation, Definition wsdl, String url, String soapaction, String namespaceMethod, String portName, String style, String useAttrInput, String useAttrOutput) throws Exception {
        Output output;
        Part partReturn;
        IPortalWebServiceMethod methodconfig = null;
        boolean error = false;
        String nameMethod = operation.getName();
        String targetNamespaceByDefault = wsdl.getTargetNamespace();
        if (!modeInterface) {
            methodconfig = this.mm_webserviceconfig.createPortalWebServiceMethod(nameMethod);
            methodconfig.setAuthenticated(false);
            methodconfig.setSOAPAction(soapaction);
            if (style != null) {
                if (style.equalsIgnoreCase("DOCUMENT")) {
                    methodconfig.setStyleEnconding(1);
                } else if (style.equalsIgnoreCase("RPC")) {
                    methodconfig.setStyleEnconding(0);
                } else {
                    methodconfig.setStyleEnconding(2);
                }
            }
        }
        if ((partReturn = (output = operation.getOutput()).getMessage().getPart("return")) == null) {
            partReturn = output.getMessage().getPart("_return");
        }
        if (partReturn == null) {
            partReturn = output.getMessage().getPart("response");
        }
        if (partReturn == null) {
            Iterator iter2 = output.getMessage().getParts().keySet().iterator();
            while (iter2.hasNext() && partReturn == null) {
                String nameRet = (String)iter2.next();
                partReturn = output.getMessage().getPart(nameRet);
            }
        }
        ObjectSchema ret = null;
        IPortalWebServiceParameter retconfig = null;
        if (!modeInterface) {
            retconfig = partReturn == null ? methodconfig.createReturnPortalWebServiceParameter("Response") : methodconfig.createReturnPortalWebServiceParameter(partReturn.getName());
        }
        if (partReturn == null) {
            ret = new ObjectSchema("void", false, null, null);
            if (!modeInterface) {
                retconfig.setAsAttribute(false);
                retconfig.setNillable(false);
                retconfig.setRequired(false);
                retconfig.addPortalWebServiceType("void", "void");
                retconfig.setDefaultJavaType("void");
                retconfig.setEnconding(useAttrOutput);
            }
        } else {
            if (partReturn.getTypeName() == null) {
                QName qntype = null;
                qntype = this.getTypeFromElement(partReturn.getElementName(), wsdl);
                ret = this.getTypeJava(qntype, wsdl);
                if (!modeInterface) {
                    retconfig.setNameElement(partReturn.getElementName().getLocalPart());
                    retconfig.setTargetNamespaceElement(partReturn.getElementName().getNamespaceURI());
                    retconfig.setEnconding(useAttrOutput);
                    retconfig.setAsAttribute(false);
                    retconfig.setNillable(this.isNillableTypeFromElement(partReturn.getElementName(), wsdl));
                    retconfig.setRequired(true);
                    if (qntype.getNamespaceURI() == null || qntype.getNamespaceURI().length() == 0) {
                        retconfig.setTargetNamespace(targetNamespaceByDefault);
                    } else {
                        retconfig.setTargetNamespace(qntype.getNamespaceURI());
                    }
                    if (ret.getType().indexOf("[") != -1) {
                        retconfig.setNameOfArrayItems(ret.getArrayItemName());
                    }
                    if (this.mm_complexTypes.get(qntype) == null) {
                        retconfig.addPortalWebServiceType(this.reconstructWSDLType(qntype), ret.getType());
                        retconfig.setDefaultJavaType(ret.getType());
                    } else {
                        retconfig.addPortalWebServiceType(this.reconstructWSDLType(qntype), ((ComplexType)this.mm_complexTypes.get(qntype)).getFullyClassName());
                        retconfig.setDefaultJavaType(((ComplexType)this.mm_complexTypes.get(qntype)).getFullyClassName());
                    }
                }
            } else {
                ret = this.getTypeJava(partReturn.getTypeName(), wsdl);
                if (!modeInterface) {
                    retconfig.setEnconding(useAttrOutput);
                    retconfig.setAsAttribute(false);
                    retconfig.setNillable(false);
                    retconfig.setRequired(true);
                    if (partReturn.getTypeName().getNamespaceURI() == null || partReturn.getTypeName().getNamespaceURI().length() == 0) {
                        retconfig.setTargetNamespace(targetNamespaceByDefault);
                    } else {
                        retconfig.setTargetNamespace(partReturn.getTypeName().getNamespaceURI());
                    }
                    if (ret.getType().indexOf("[") != -1) {
                        retconfig.setNameOfArrayItems(ret.getArrayItemName());
                    }
                    if (this.mm_complexTypes.get(partReturn.getTypeName()) == null) {
                        retconfig.addPortalWebServiceType(this.reconstructWSDLType(partReturn.getTypeName()), ret.getType());
                        retconfig.setDefaultJavaType(ret.getType());
                    } else {
                        retconfig.addPortalWebServiceType(this.reconstructWSDLType(partReturn.getTypeName()), ((ComplexType)this.mm_complexTypes.get(partReturn.getTypeName())).getFullyClassName());
                        retconfig.setDefaultJavaType(((ComplexType)this.mm_complexTypes.get(partReturn.getTypeName())).getFullyClassName());
                    }
                }
            }
        }
        Input input = operation.getInput();
        XMLAttributeHandler paramsprocessed = null;
        if (input != null && (paramsprocessed = modeInterface ? this.processInputOperation(wsdl, input, null, null) : this.processInputOperation(wsdl, input, methodconfig, useAttrInput)) == null) {
            error = true;
        }
        Map faults = operation.getFaults();
        ArrayList<String> exceptions = new ArrayList<String>();
        Iterator keys = faults.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Fault element = (Fault)faults.get(key);
            Message faultmsg = element.getMessage();
            if (faultmsg != null) {
                List parts = faultmsg.getOrderedParts(null);
                if (parts.size() >= 1) {
                    CustomException cException;
                    Part partException = (Part)parts.get(0);
                    QName typeException = partException.getTypeName();
                    if (typeException == null) {
                        typeException = partException.getElementName();
                    }
                    if (typeException == null) {
                        REPORT_GENERATION.add(new InformationReport("Error : The SOAP Fault " + element.getName() + " has no part in the message attached.", null, 1));
                    }
                    if ((cException = (CustomException)this.mm_customExceptions.get(typeException)) == null) {
                        String classname = this.createCustomType(typeException, null, true);
                        exceptions.add(classname);
                        continue;
                    }
                    exceptions.add(cException.getFullyClassName());
                    continue;
                }
                REPORT_GENERATION.add(new InformationReport("Error : The SOAP Fault " + element.getName() + " has no part in the message attached.", null, 1));
                continue;
            }
            REPORT_GENERATION.add(new InformationReport("Error : The SOAP Fault " + element.getName() + " has no message attached.", null, 1));
        }
        if (!error) {
            if (modeInterface) {
                this.writeSignMethod(out, nameMethod, ret, paramsprocessed, exceptions);
            } else if (this.mm_serverSideMode) {
                this.writeTemplateMethod(out, nameMethod, ret, paramsprocessed, exceptions);
            } else {
                HashMap<String, String> httpheaders = new HashMap<String, String>();
                if (soapaction != null) {
                    httpheaders.put("soapaction", soapaction);
                }
                this.writeMethod(out, nameMethod, ret, paramsprocessed, namespaceMethod, httpheaders, url, exceptions);
            }
        }
    }

    private XMLAttributeHandler processInputOperation(Definition wsdl, Input input, IPortalWebServiceMethod methodconfig, String useAttrInput) throws Exception {
        String targetNamespaceByDefault = wsdl.getTargetNamespace();
        XMLAttributeHandler paramsprocessed = new XMLAttributeHandler();
        List params = input.getMessage().getOrderedParts(null);
        Object[] keysparam = params.toArray();
        int ind = 0;
        while (ind < keysparam.length) {
            Part param = (Part)keysparam[ind];
            IPortalWebServiceParameter paramconfig = null;
            if (methodconfig != null) {
                paramconfig = methodconfig.createPortalWebServiceParameter(ind, param.getName());
                paramconfig.setEnconding(useAttrInput);
            }
            ObjectSchema ptype = null;
            if (methodconfig != null) {
                paramconfig.setAsAttribute(false);
                paramconfig.setRequired(true);
            }
            if (param.getTypeName() == null) {
                QName qntype = this.getTypeFromElement(param.getElementName(), wsdl);
                ptype = this.getTypeJava(qntype, wsdl);
                if (methodconfig != null) {
                    paramconfig.setNameElement(param.getElementName().getLocalPart());
                    paramconfig.setTargetNamespaceElement(param.getElementName().getNamespaceURI());
                    if (qntype.getNamespaceURI() == null || qntype.getNamespaceURI().length() == 0) {
                        paramconfig.setTargetNamespace(targetNamespaceByDefault);
                    } else {
                        paramconfig.setTargetNamespace(qntype.getNamespaceURI());
                    }
                    paramconfig.setNillable(this.isNillableTypeFromElement(param.getElementName(), wsdl));
                    if (ptype.getType().indexOf("[") != -1) {
                        paramconfig.setNameOfArrayItems(ptype.getArrayItemName());
                    }
                    if (this.mm_complexTypes.get(qntype) == null) {
                        paramconfig.addPortalWebServiceType(this.reconstructWSDLType(qntype), ptype.getType());
                        paramconfig.setDefaultJavaType(ptype.getType());
                    } else {
                        paramconfig.addPortalWebServiceType(this.reconstructWSDLType(qntype), ((ComplexType)this.mm_complexTypes.get(qntype)).getFullyClassName());
                        paramconfig.setDefaultJavaType(((ComplexType)this.mm_complexTypes.get(qntype)).getFullyClassName());
                    }
                }
            } else {
                ptype = this.getTypeJava(param.getTypeName(), wsdl);
                if (methodconfig != null) {
                    paramconfig.setNillable(false);
                    if (param.getTypeName().getNamespaceURI() == null || param.getTypeName().getNamespaceURI().length() == 0) {
                        paramconfig.setTargetNamespace(targetNamespaceByDefault);
                    } else {
                        paramconfig.setTargetNamespace(param.getTypeName().getNamespaceURI());
                    }
                    if (ptype.getType().indexOf("[") != -1) {
                        paramconfig.setNameOfArrayItems(ptype.getArrayItemName());
                    }
                    if (this.mm_complexTypes.get(param.getTypeName()) == null) {
                        paramconfig.addPortalWebServiceType(this.reconstructWSDLType(param.getTypeName()), ptype.getType());
                        paramconfig.setDefaultJavaType(ptype.getType());
                    } else {
                        paramconfig.addPortalWebServiceType(this.reconstructWSDLType(param.getTypeName()), ((ComplexType)this.mm_complexTypes.get(param.getTypeName())).getFullyClassName());
                        paramconfig.setDefaultJavaType(((ComplexType)this.mm_complexTypes.get(param.getTypeName())).getFullyClassName());
                    }
                }
            }
            if (ptype == null) {
                return null;
            }
            ptype.setType(ptype.getType());
            paramsprocessed.addAttribute(ToolKit.normalizeJavaName(GenerateServiceFromWsdl.checkNameParams(param.getName())), (Object)ptype);
            ++ind;
        }
        return paramsprocessed;
    }

    private void writeTemplatePRTService(PrintWriter out) throws IOException {
        out.println();
        out.println("\tpublic IServiceContext getContext() {\n\t\treturn mm_serviceContext;\n\t}");
        out.println();
        out.println("\tpublic String getKey() {\n\treturn " + this.mm_nameInterface + ".KEY;\n\t}");
        out.println();
        out.println("\tpublic void afterInit() {");
        out.println("\t\tmm_soapService = (ISOAPService)mm_serviceContext.getService(ISOAPService.KEY);");
        out.println("\t}");
        out.println();
        out.println("\t/**");
        out.println("\t * configure the service");
        out.println("\t * @param configuration");
        out.println("\t * @deprecated");
        out.println("\t */");
        out.println("\tpublic void configure(com.sapportals.portal.prt.service.IServiceConfiguration configuration) {\n\t}");
        out.println();
        out.println("\tpublic void destroy() {\n\t}");
        out.println();
        out.println("\tpublic void init(IServiceContext serviceContext) {\n\t\tmm_serviceContext = serviceContext;\n\t}");
        out.println();
        out.println("\t/**");
        out.println("\t * This method is called by the portal runtime");
        out.println("\t * when the service is released.");
        out.println("\t * @deprecated");
        out.println("\t */");
        out.println("\tpublic void release() {\n\t}");
        out.println("\tpublic void setURLEndPoint(URLEndpoint urlEndpoint){\n\tmm_urlEndpoint=urlEndpoint.getURL();\n\t}");
        out.println("\tpublic URLEndpoint getURLEndPoint(){\n\treturn new URLEndpoint(mm_urlEndpoint);\n\t}");
        out.println("\tpublic " + this.mm_nameInterface + " getSecurisedServiceConnection(IUserContext user){");
        out.println("\t\t" + this.mm_nameService + " service = new " + this.mm_nameService + "();\n");
        out.println("\t\tservice.init(mm_serviceContext);");
        out.println("\t\tservice.afterInit();");
        out.println("\t\tservice.mm_isClone = true;");
        out.println("\t\tservice.mm_userCxt = user;");
        out.println("\t\treturn service;");
        out.println("\t}");
        out.println();
        out.println("\t/**");
        out.println("\t* method returns an array of cookies which included in the soap response");
        out.println("\t* extracted during the last soap call (last method called on this proxy)");
        out.println("\t* ");
        out.println("\t* @return an array of Cookie (javax.servlet.http.Cookie), null if no cookies are present");
        out.println("\t* in the soap request.");
        out.println("\t*/");
        out.println("\tpublic Object[] getCookiesFromLastSOAPResponse() {");
        out.println("\t\treturn mm_cookiesFromResponse;");
        out.println("\t}");
        out.println();
        out.println();
        out.println("\t/**");
        out.println("\t* method which add a cookie (of javax.servlet.http.Cookie type) in the soap request ");
        out.println("\t* during the call of a method of this proxy class(the list of cookies is reseted after the");
        out.println("\t* call of the method).");
        out.println("\t* @param cookie- a Cookie (javax.servlet.http.Cookie), null if no accepted");
        out.println("\t* in the soap request.");
        out.println("\t*/");
        out.println("\tpublic void addCookieInSOAPRequest(Object cookie) throws IllegalArgumentException {");
        out.println("\t\tif (cookie == null){");
        out.println("\t\t\tthrow new IllegalArgumentException(\"The parameter passed is null.\");");
        out.println("\t\t}");
        out.println();
        out.println("\t\tif (checkTypeObject(cookie)){");
        out.println("\t\t\tmm_cookies.add(cookie);");
        out.println("\t\t}else{");
        out.println("\t\t\tthrow new IllegalArgumentException(\"The parameter (\"+cookie.toString()+\") passed is not a javax.servlet.http.Cookie object.\");");
        out.println("\t\t}");
        out.println("\t}");
        out.println();
        out.println("\tprivate boolean checkTypeObject(Object obj) {");
        out.println("\t\tif (obj.getClass().getName().equals(\"javax.servlet.http.Cookie\"))");
        out.println("\t\t\treturn true;");
        out.println("\t\treturn false;");
        out.println("\t\t}");
        out.println();
        out.flush();
    }

    private void writeInterfaceOfService(String name, String packageName, String key, PrintWriter out) throws Exception {
        if (packageName != null && packageName.length() > 0) {
            out.println("package " + packageName + ";");
        }
        out.println();
        out.println("/**");
        out.println(" * Title: " + name + ".java");
        if (this.mm_serverSideMode) {
            out.println(" * Description: Interface of the Portal Service " + name + ".");
            out.println(" * Template was generated automatically by the SAP PORTAL PLUGINS from the wsdl url :");
            out.println(" * " + this.mm_urlwsdl);
            out.println(" * @author " + System.getProperty("user.name"));
        } else {
            out.println(" * Description: Interface of the Portal Service " + name + ".");
            out.println(" *              This file was generated automatically by the Wizard, not to modify manually");
            out.println(" * @author SAP Portal EP6.0");
        }
        out.println(" * @version " + new SimpleDateFormat("yyyy.MM.dd G 'at' HH:mm:ss z").format(new Date()));
        out.println(" */");
        out.println();
        out.println("import com.sapportals.portal.prt.service.IService;");
        out.println("import com.sapportals.portal.prt.service.soap.types.*;");
        out.println("import com.sapportals.portal.prt.session.IUserContext;");
        out.println("import javax.xml.messaging.URLEndpoint;");
        out.println();
        out.println("import java.util.*;");
        out.println("import java.math.BigDecimal;");
        out.println();
        out.println("public interface " + name + " extends IService {");
        out.println();
        out.println("\tpublic static final String KEY =\"" + key + "\";");
        out.println("\tpublic void setURLEndPoint(URLEndpoint urlEndpoint);");
        out.println("\tpublic URLEndpoint getURLEndPoint();");
        out.println("\tpublic " + this.mm_nameInterface + " getSecurisedServiceConnection(IUserContext user);");
        out.println();
        if (this.mm_def != null) {
            this.writeMethods(out, this.mm_def, true);
        }
        out.println();
        out.println("\t/**");
        out.println("\t* method returns an array of cookies which included in the soap response");
        out.println("\t* extracted during the last soap call (last method called on this proxy)");
        out.println("\t* ");
        out.println("\t* @return an array of Cookie (javax.servlet.http.Cookie), null if no cookies are present");
        out.println("\t* in the soap request.");
        out.println("\t*/");
        out.println("\tpublic Object[] getCookiesFromLastSOAPResponse();");
        out.println();
        out.println("\t/**");
        out.println("\t* method which add a cookie (of javax.servlet.http.Cookie type) in the soap request ");
        out.println("\t* during the call of a method of this proxy class(the list of cookies is reseted after the");
        out.println("\t* call of the method).");
        out.println("\t* @param cookie- a Cookie (javax.servlet.http.Cookie), null if no accepted");
        out.println("\t* in the soap request.");
        out.println("\t*/");
        out.println("\tpublic void addCookieInSOAPRequest(Object cookie) throws IllegalArgumentException ;");
        out.println();
        out.println("}");
        out.println();
    }

    public String getNamePackage() {
        return this.mm_namePackage;
    }

    public String getNameService() {
        return this.mm_nameService;
    }

    public void setNameService(String nameService) {
        this.mm_nameService = nameService;
    }

    public void setNamePackage(String namePackage) {
        this.mm_namePackage = namePackage;
        this.mm_pathPackage = namePackage.replace('.', File.separatorChar);
    }

    public String getUrlWSDL() {
        return this.mm_urlwsdl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initSOAPConfigFile(File soapconfig) throws ParserConfigurationException, IllegalStateException, FileNotFoundException, SAXException, IOException {
        if (soapconfig == null || !soapconfig.exists()) {
            this.mm_soapconfig = PortalSOAPConfigFactory.getInstance().getSOAPConfigInstance(this.mm_projectName);
            this.mm_webserviceconfig = this.mm_soapconfig.createPortalWebService(this.mm_alias);
        }
        if (soapconfig != null && soapconfig.exists()) {
            block13: {
                FileInputStream fio = null;
                try {
                    try {
                        fio = new FileInputStream(soapconfig);
                        this.mm_soapconfig = PortalSOAPConfigFactory.getInstance().getSOAPConfigInstance(fio);
                    }
                    catch (IllegalStateException e) {
                        throw e;
                    }
                    catch (FileNotFoundException e) {
                        throw e;
                    }
                    catch (SAXException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (ParserConfigurationException e) {
                        throw e;
                    }
                    Object var9_4 = null;
                    if (fio == null) break block13;
                }
                catch (Throwable throwable) {
                    Object var9_5 = null;
                    if (fio != null) {
                        fio.close();
                    }
                    throw throwable;
                }
                fio.close();
            }
            this.mm_webserviceconfig = this.mm_soapconfig.createPortalWebService(this.mm_alias);
        }
    }

    public String getProjectName() {
        return this.mm_projectName;
    }

    public void setProjectName(String string) {
        this.mm_projectName = string;
    }

    public String getAlias() {
        return this.mm_alias;
    }

    public void setAlias(String string) {
        this.mm_alias = string;
    }

    public File getSoapconfigfile() {
        return this.mm_soapconfigfile;
    }

    public void setSoapconfigfile(File file) {
        this.mm_soapconfigfile = file;
    }

    public IPortalSOAPConfig getSoapconfig() {
        return this.mm_soapconfig;
    }

    public void setSoapconfig(IPortalSOAPConfig config) {
        this.mm_soapconfig = config;
    }

    public String getNamespaceFromPrefix(String prefix) {
        if (prefix == null) {
            return null;
        }
        if (this.mm_def == null) {
            return null;
        }
        return ToolKit.getNameSpaceInWSDLWithImportInclude(this.mm_def, prefix);
    }

    private String reconstructWSDLType(QName type) {
        if (this.mm_def != null) {
            String prefix = ToolKit.getPrefixInWSDLWithImportInclude(this.mm_def, type.getNamespaceURI());
            if (prefix != null && prefix.length() >= 1) {
                return prefix + ":" + type.getLocalPart();
            }
            return type.getLocalPart();
        }
        return type.getLocalPart();
    }

    public HashMap getCustomExceptions() {
        return this.mm_customExceptions;
    }

    public Definition getDef() {
        return this.mm_def;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

