/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.webserviceconfig.impl;

import com.sapportals.portal.prt.service.soap.webserviceconfig.IPortalSOAPConfigVersion;
import java.util.StringTokenizer;

public class PortalSOAPConfigVersionImpl
implements IPortalSOAPConfigVersion {
    private int mm_majorversion = 0;
    private int mm_microversion = 0;
    private int mm_minorversion = 0;

    public PortalSOAPConfigVersionImpl(int majorversion, int minorversion, int microversion) {
        this.mm_majorversion = majorversion;
        this.mm_minorversion = minorversion;
        this.mm_microversion = microversion;
    }

    public PortalSOAPConfigVersionImpl(String version) {
        StringTokenizer ps;
        if (version != null && (ps = new StringTokenizer(version, ",")).countTokens() == 3) {
            try {
                this.mm_majorversion = Integer.parseInt(ps.nextToken());
                this.mm_microversion = Integer.parseInt(ps.nextToken());
                this.mm_minorversion = Integer.parseInt(ps.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public boolean isCompatible(String version) {
        if (version == null) {
            return false;
        }
        StringTokenizer ps = new StringTokenizer(version, ",");
        if (ps.countTokens() == 3) {
            try {
                int major = Integer.parseInt(ps.nextToken());
                int minor = Integer.parseInt(ps.nextToken());
                int micro = Integer.parseInt(ps.nextToken());
                if (this.mm_majorversion < major) {
                    return false;
                }
                if (this.mm_minorversion < minor) {
                    return false;
                }
                return this.mm_microversion >= micro;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return false;
    }

    public void setMajorVersion(int value) {
        this.mm_majorversion = value;
    }

    public int getMajorVersion() {
        return this.mm_majorversion;
    }

    public void setMicroVersion(int value) {
        this.mm_microversion = value;
    }

    public int getMicroVersion() {
        return this.mm_microversion;
    }

    public void setMinorVersion(int value) {
        this.mm_minorversion = value;
    }

    public int getMinorVersion() {
        return this.mm_minorversion;
    }

    public String toString() {
        StringBuffer content = new StringBuffer();
        content.append(this.mm_majorversion);
        content.append(",");
        content.append(this.mm_minorversion);
        content.append(",");
        content.append(this.mm_microversion);
        return content.toString();
    }
}

