/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.webserviceconfig;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sapportals.portal.prt.service.soap.webserviceconfig.IPortalSOAPConfig;
import com.sapportals.portal.prt.service.soap.webserviceconfig.IPortalSOAPConfigVersion;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebService;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceMappingInterface;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceMethod;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceParameter;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceSerializer;
import com.sapportals.portal.prt.service.soap.webserviceconfig.impl.PortalSOAPConfigImpl;
import com.sapportals.portal.prt.service.soap.webserviceconfig.impl.PortalSOAPConfigVersionImpl;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PortalSOAPConfigFactory {
    private static PortalSOAPConfigFactory mm_instance = null;
    private DocumentBuilderFactory mm_DOMFactory = new DocumentBuilderFactoryImpl();
    public static final IPortalSOAPConfigVersion SOAP_CONFIG_VERSION = new PortalSOAPConfigVersionImpl(6, 0, 3);

    private PortalSOAPConfigFactory() {
    }

    public static PortalSOAPConfigFactory getInstance() {
        if (mm_instance != null) {
            return mm_instance;
        }
        mm_instance = new PortalSOAPConfigFactory();
        return mm_instance;
    }

    public IPortalSOAPConfig getSOAPConfigInstance(InputStream in) throws SAXException, IOException, ParserConfigurationException, IllegalStateException {
        try {
            Document dom = this.mm_DOMFactory.newDocumentBuilder().parse(in);
            return new PortalSOAPConfigImpl(dom);
        }
        catch (SAXException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (ParserConfigurationException ex) {
            throw ex;
        }
    }

    public IPortalSOAPConfig getSOAPConfigInstance(String application_name) throws ParserConfigurationException {
        try {
            Document dom = this.mm_DOMFactory.newDocumentBuilder().newDocument();
            return new PortalSOAPConfigImpl(dom, application_name);
        }
        catch (ParserConfigurationException ex) {
            return null;
        }
    }

    public static void main(String[] args) {
        IPortalSOAPConfig config = null;
        try {
            config = PortalSOAPConfigFactory.getInstance().getSOAPConfigInstance("FisrtConfigAppli");
            if (config == null) {
                throw new Exception("config null");
            }
            IPortalWebService pws = config.createPortalWebService("firstWebservice");
            IPortalWebServiceMethod item = pws.createPortalWebServiceMethod("method1");
            item.setAuthenticated(false);
            item.setJavaSignature(pws.getClass().getDeclaredMethods()[0].toString());
            item.setSOAPAction("urn:prt:portal");
            item.setStyleEnconding(1);
            IPortalWebServiceParameter param = item.createPortalWebServiceParameter(0, "param0");
            param.setAsAttribute(true);
            param.setDefaultValue("toto");
            param.setEnconding("litteral");
            param.setMinOccurs(0);
            param.setMaxOccurs(10);
            param.setNillable(true);
            param.setRequired(true);
            param.setTargetNamespace("http://www.sap.com/prt");
            param.addPortalWebServiceType("Vector", "java.util.Vector");
            IPortalWebServiceParameter ret = item.createReturnPortalWebServiceParameter("Response");
            ret.addPortalWebServiceType("string", "java.util.String");
            pws.createPortalWebServiceMethod("method1");
            pws.createPortalWebServiceMethod("method3");
            IPortalWebService pws1 = config.createPortalWebService("firstWebservice1");
            pws1.createPortalWebServiceMethod("method1");
            IPortalWebServiceSerializer ser = pws1.createPortalWebServiceSerializer("ser1");
            ser.setJavatype("java.util.Vector");
            ser.setLocalpart("Vector");
            ser.setNamespace("http://prt.com");
            ser.setSerializer("com.sap.portal.VectorSer");
            IPortalWebServiceSerializer ser2 = pws1.createPortalWebServiceSerializer("ser2");
            IPortalWebService pws2 = config.createPortalWebService("firstWebservice2");
            IPortalWebServiceMethod item1 = pws2.createPortalWebServiceMethod("method1");
            item1.createReturnPortalWebServiceParameter("Response");
            item1.createPortalWebServiceParameter(0, "param0");
            item1.createPortalWebServiceParameter(1, "param0");
            item1.createPortalWebServiceParameter(2, "param1");
            IPortalWebServiceMappingInterface mapping = pws2.createPortalWebServiceMappingInterface();
            mapping.addMappingInterface("java.util.List", "java.util.ArrayList");
            mapping.addMappingInterface("java.util.List2", "java.util.ArrayList");
            config.save((OutputStream)new FileOutputStream("c:/soapconfig.xml"));
            config = PortalSOAPConfigFactory.getInstance().getSOAPConfigInstance(new FileInputStream("c:/soapconfig.xml"));
            config.save((OutputStream)new FileOutputStream("c:/soapconfig1.xml"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

